/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.graphics;

import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MChemicalStruct
extends MObject {
    private static final long serialVersionUID = 7098670860634457343L;
    private transient MoleculeGraph moleculeGraph;

    public MChemicalStruct(MoleculeGraph m) {
        super(null, null, null);
        this.moleculeGraph = m;
    }

    protected MChemicalStruct(MChemicalStruct mcs) {
        super(mcs);
        this.moleculeGraph = (MoleculeGraph)mcs.getMoleculeGraph().clone();
    }

    public MoleculeGraph getMoleculeGraph() {
        return this.moleculeGraph;
    }

    @Override
    public Object clone() {
        return new MChemicalStruct(this);
    }

    @Override
    public boolean isEmpty() {
        return this.moleculeGraph.isEmpty();
    }

    @Override
    public int getPointCount() {
        return this.moleculeGraph.getAtomCount();
    }

    @Override
    public MPoint getPoint(int i) {
        return new MPoint(this.moleculeGraph.getAtom(i).getLocation());
    }

    @Override
    public boolean containsAtom(MolAtom a) {
        return this.moleculeGraph.contains(a);
    }

    @Override
    public void transform(CTransform3D t, int opts, CTransform3D trot) {
        this.moleculeGraph.transform(t);
    }

    @Override
    public void calcCenter(DPoint3 p, CTransform3D t) {
        this.moleculeGraph.calcCenter(p);
        if (t != null) {
            t.transform(p);
        }
    }

    @Override
    public double distanceFrom(double x, double y, CTransform3D t) {
        return MChemicalStruct.distanceFrom(this.moleculeGraph, x, y, t);
    }

    public static double distanceFrom(MoleculeGraph molg, double x, double y, CTransform3D t) {
        double dmin = Double.MAX_VALUE;
        MoleculeGraph umol = molg.getGraphUnion();
        DPoint3 p = new DPoint3();
        for (int i = 0; i < umol.getAtomCount(); ++i) {
            double dy;
            double dx;
            double d;
            MolAtom a = umol.getAtom(i);
            a.getLocation(p);
            if (t != null) {
                t.transform(p);
            }
            if (!((d = Math.sqrt((dx = p.x - x) * dx + (dy = p.y - y) * dy)) < dmin)) continue;
            dmin = d;
        }
        DPoint3 p1 = p;
        DPoint3 p2 = new DPoint3();
        for (int i = 0; i < umol.getBondCount(); ++i) {
            double ny;
            double nx;
            double d;
            double ey;
            MolBond b = umol.getBond(i);
            b.getAtom1().getLocation(p1);
            b.getAtom2().getLocation(p2);
            if (t != null) {
                t.transform(p1);
                t.transform(p2);
            }
            double x1 = x - p1.x;
            double y1 = y - p1.y;
            double x2 = x - p2.x;
            double y2 = y - p2.y;
            double rx = p2.x - p1.x;
            double ry = p2.y - p1.y;
            double rxy = Math.sqrt(rx * rx + ry * ry);
            double ex = rx / rxy;
            if (!(x1 * ex + y1 * (ey = ry / rxy) > 0.0) || !(x2 * ex + y2 * ey < 0.0) || !((d = Math.abs(x1 * (nx = -ey) + y1 * (ny = ex))) < dmin)) continue;
            dmin = d;
        }
        return dmin;
    }

    @Override
    public void setSelected(boolean s) {
        super.setSelected(s);
        MChemicalStruct.setSelected(this.moleculeGraph, s);
    }

    public static void setSelected(MoleculeGraph molg, boolean s) {
        MoleculeGraph umol = molg.getGraphUnion();
        for (int i = 0; i < umol.getAtomCount(); ++i) {
            umol.getAtom(i).setSelected(s);
        }
    }

    public boolean hasSelection() {
        return MChemicalStruct.hasSelection(this.moleculeGraph);
    }

    public static boolean hasSelection(MoleculeGraph molg) {
        MoleculeGraph umol = molg.getGraphUnion();
        for (int i = 0; i < umol.getAtomCount(); ++i) {
            if (!umol.getAtom(i).isSelected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void unselectContents() {
        MoleculeGraph umol = this.moleculeGraph.getGraphUnion();
        for (int i = 0; i < umol.getAtomCount(); ++i) {
            umol.getAtom(i).setSelected(false);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.writeObject(this.moleculeGraph);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize molecule graph object with future version (" + version + ")");
        }
        this.moleculeGraph = (MoleculeGraph)ois.readObject();
    }
}

