/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.graphics;

import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MAtomSetPoint;
import chemaxon.struc.graphics.MEFlowBasePoint;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;

public class MEFlow
extends MPolyline {
    private static final long serialVersionUID = 891769518407563834L;
    public static final int E_SOURCE = 0;
    public static final int E_SINK = 1;

    public MEFlow() {
        this(null, null, 2);
    }

    public MEFlow(int ne) {
        this(null, null, ne);
    }

    public MEFlow(MPoint p1, MPoint p2, int ne) {
        super(p1, p2, null, null);
        this.setArrowFlags(HEAD, ne == 1 ? ARROW_HALF_LEFT : 0);
        this.setArrowLength(HEAD, 0.6);
        this.setArrowWidth(HEAD, 0.5);
        this.setArcAngle(150.0);
    }

    public int getNumElectrons() {
        int f = this.getArrowFlags(HEAD) & ARROW_HALF_MASK;
        return f == ARROW_HALF_LEFT || f == ARROW_HALF_RIGHT ? 1 : 2;
    }

    @Override
    public MPoint getPoint(int i) {
        MAtomSetPoint masp;
        MolAtom[] atoms;
        MPoint mp = super.getPoint(i);
        if (i == 0 && mp instanceof MAtomSetPoint && (atoms = (masp = (MAtomSetPoint)mp).getAtoms()).length == 1) {
            MPoint q = this.getPointRef(1, null);
            mp = new MEFlowBasePoint(atoms[0], q);
            MPoint[] ps = new MPoint[]{mp, q};
            this.setPoints(ps);
        }
        return mp;
    }

    protected MEFlow(MEFlow l) {
        super(l);
    }

    @Override
    public Object clone() {
        return new MEFlow(this);
    }

    public Object getMolObject(int i) {
        MPoint p;
        MPoint mPoint = p = i < this.getPointRefCount() ? this.getPointRef(i, null) : null;
        if (p != null && p instanceof MAtomSetPoint) {
            MAtomSetPoint ap = (MAtomSetPoint)p;
            MolAtom[] atoms = ap.getAtoms();
            if (atoms.length == 1) {
                return atoms[0];
            }
            MolAtom[] e = atoms[0].getBondTo(atoms[1]);
            return e != null ? e : atoms;
        }
        if (p != null && p instanceof MEFlowBasePoint) {
            MEFlowBasePoint ap = (MEFlowBasePoint)p;
            return ap.getAtom();
        }
        return null;
    }

    @Override
    public int getPointRefCount() {
        return 2;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize EFlow object with future version (" + version + ")");
        }
    }

    private static boolean isValidSourceAtomForMolecule(MolAtom source, Molecule m) {
        MolAtom[] maarray = MEFlow.getValidSourceAtomsForMolecule(m);
        for (int i = 0; i < maarray.length; ++i) {
            if (source != maarray[i]) continue;
            return true;
        }
        return false;
    }

    public static MolAtom[] getValidSourceAtomsForMolecule(Molecule m) {
        ArrayList v = new ArrayList();
        Collections.addAll(v, m.getGraphUnion().getAtomArray());
        MolAtom[] atoms = new MolAtom[v.size()];
        v.toArray(atoms);
        return atoms;
    }

    private static boolean isValidSourceAtomSinkAtomForMolecule(MolAtom source, MolAtom sink, Molecule m) {
        MolAtom[] maarray = MEFlow.getValidSinkAtomsForMolecule(m, source);
        for (int i = 0; i < maarray.length; ++i) {
            if (sink != maarray[i]) continue;
            return true;
        }
        return false;
    }

    public static MolAtom[] getValidSinkAtomsForMolecule(Molecule m, MolAtom source) {
        if (source == null || m == null) {
            return new MolAtom[0];
        }
        ArrayList v = new ArrayList();
        Collections.addAll(v, m.getGraphUnion().getAtomArray());
        RxnMolecule rxn = RxnMolecule.getReaction(m);
        if (rxn != null) {
            m = rxn;
        }
        MoleculeGraph mg0 = null;
        Sgroup sg0 = null;
        mg0 = source.getParent();
        sg0 = MEFlow.getSgroupContaining(source);
        for (int i = v.size() - 1; i >= 0; --i) {
            MolAtom a1;
            MolAtom a = (MolAtom)v.get(i);
            MoleculeGraph aparent = a.getParent();
            if (!(mg0 == aparent || m instanceof RxnMolecule && mg0.getParent() == m && aparent.getParent() == m)) {
                v.remove(i);
                continue;
            }
            Sgroup sg = MEFlow.getSgroupContaining(a);
            if (sg0 == sg) continue;
            if (sg == null) {
                if (sg0 instanceof SuperatomSgroup) {
                    SuperatomSgroup ssg0 = (SuperatomSgroup)sg0;
                    a1 = ssg0.findAttachAtom();
                    if (a1 == source) continue;
                    v.remove(i);
                    continue;
                }
                v.remove(i);
                continue;
            }
            if (sg instanceof SuperatomSgroup) {
                SuperatomSgroup ssg = (SuperatomSgroup)sg;
                a1 = ssg.findAttachAtom();
                if (a == a1) continue;
                v.remove(i);
                continue;
            }
            v.remove(i);
        }
        MolAtom[] atoms = new MolAtom[v.size()];
        v.toArray(atoms);
        return atoms;
    }

    private static Sgroup getSgroupContaining(MolAtom a) {
        MoleculeGraph mg = a.getParent();
        if (mg instanceof Molecule) {
            Molecule m = (Molecule)mg;
            Sgroup sg = m.findSgroupContaining(a);
            return sg;
        }
        return null;
    }

    private static boolean isValidSourceBondSinkAtomForMolecule(MolBond source, MolAtom sink, Molecule m) {
        MolAtom[] maarray = MEFlow.getValidSinkAtomsForMolecule(m, source);
        for (int i = 0; i < maarray.length; ++i) {
            if (sink != maarray[i]) continue;
            return true;
        }
        return false;
    }

    public static MolAtom[] getValidSinkAtomsForMolecule(Molecule m, MolBond source) {
        if (source == null || m == null) {
            return new MolAtom[0];
        }
        MolAtom[] atoms = new MolAtom[]{source.getAtom1(), source.getAtom2()};
        return atoms;
    }

    private static boolean isValidSourceBondForMolecule(MolBond source, Molecule m) {
        MolBond[] maarray = MEFlow.getValidSourceBondsForMolecule(m);
        for (int i = 0; i < maarray.length; ++i) {
            if (source != maarray[i]) continue;
            return true;
        }
        return false;
    }

    public static MolBond[] getValidSourceBondsForMolecule(Molecule m) {
        return m.getBondArray();
    }

    private static boolean isValidSourceAtomSinkBondForMolecule(MolAtom source, MolBond sink, Molecule m) {
        MolBond[] maarray = MEFlow.getValidSinkBondsForMolecule(m, source);
        for (int i = 0; i < maarray.length; ++i) {
            if (sink != maarray[i]) continue;
            return true;
        }
        return false;
    }

    public static MolBond[] getValidSinkBondsForMolecule(Molecule m, MolAtom source) {
        if (source == null || m == null) {
            return new MolBond[0];
        }
        MolBond[] bonds = new MolBond[source.getBondCount()];
        for (int i = 0; i < bonds.length; ++i) {
            bonds[i] = source.getBond(i);
        }
        return bonds;
    }

    private static boolean isValidSourceBondSinkBondForMolecule(MolBond source, MolBond sink, Molecule m) {
        MolBond[] maarray = MEFlow.getValidSinkBondsForMolecule(m, source);
        for (int i = 0; i < maarray.length; ++i) {
            if (sink != maarray[i]) continue;
            return true;
        }
        return false;
    }

    public static MolBond[] getValidSinkBondsForMolecule(Molecule m, MolBond source) {
        if (source == null || m == null) {
            return new MolBond[0];
        }
        MolBond[] bonds = new MolBond[source.getAtom1().getBondCount() + source.getAtom2().getBondCount() - 2];
        int count = 0;
        MolAtom[] src = new MolAtom[]{source.getAtom1(), source.getAtom2()};
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < src[i].getBondCount(); ++j) {
                MolBond b = src[i].getBond(j);
                if (b.getAtom1() == src[1 - i] || b.getAtom2() == src[1 - i]) continue;
                bonds[count++] = b;
            }
        }
        return bonds;
    }

    private static boolean isValidSourceAtomPairForMolecule(MolAtom[] source, Molecule m) {
        if (source == null || source.length != 2) {
            return false;
        }
        MolAtom[][] maarray = MEFlow.getValidSourceAtomPairsForMolecule(m);
        for (int i = 0; i < maarray.length; ++i) {
            if (source[0] != maarray[i][0] || source[1] != maarray[i][1]) continue;
            return true;
        }
        return false;
    }

    public static MolAtom[][] getValidSourceAtomPairsForMolecule(Molecule m) {
        return new MolAtom[0][];
    }

    private static boolean isValidSourceAtomSinkAtomPairForMolecule(MolAtom source, MolAtom[] sink, Molecule m) {
        if (sink == null || sink.length != 2) {
            return false;
        }
        MolAtom[][] maarray = MEFlow.getValidSinkAtomPairsForMolecule(m, source);
        for (int i = 0; i < maarray.length; ++i) {
            if (sink[0] != maarray[i][0] || sink[1] != maarray[i][1]) continue;
            return true;
        }
        return false;
    }

    public static MolAtom[][] getValidSinkAtomPairsForMolecule(Molecule m, MolAtom source) {
        if (source == null || m == null) {
            return new MolAtom[0][];
        }
        MolAtom[] src = new MolAtom[]{source};
        int count = MEFlow.countOrFillAtomPairs(m, src, null);
        MolAtom[][] pairs = new MolAtom[count][];
        MEFlow.countOrFillAtomPairs(m, src, pairs);
        return pairs;
    }

    private static boolean isValidSourceBondSinkAtomPairForMolecule(MolBond source, MolAtom[] sink, Molecule m) {
        if (sink == null || sink.length != 2) {
            return false;
        }
        MolAtom[][] maarray = MEFlow.getValidSinkAtomPairsForMolecule(m, source);
        for (int i = 0; i < maarray.length; ++i) {
            if (sink[0] != maarray[i][0] || sink[1] != maarray[i][1]) continue;
            return true;
        }
        return false;
    }

    public static MolAtom[][] getValidSinkAtomPairsForMolecule(Molecule m, MolBond source) {
        if (source == null || m == null) {
            return new MolAtom[0][];
        }
        MolAtom[] src = new MolAtom[]{source.getAtom1(), source.getAtom2()};
        int count = MEFlow.countOrFillAtomPairs(m, src, null);
        MolAtom[][] pairs = new MolAtom[count][];
        MEFlow.countOrFillAtomPairs(m, src, pairs);
        return pairs;
    }

    private static int countOrFillAtomPairs(MoleculeGraph m, MolAtom[] src, MolAtom[][] pairs) {
        int count = 0;
        block0: for (int i = 0; i < m.getAtomCount(); ++i) {
            int j;
            SgroupAtom sga;
            SuperatomSgroup supsg;
            MolAtom[] attach;
            MolAtom a = m.getAtom(i);
            if (a.getAtno() == 135 && (attach = (supsg = (sga = (SgroupAtom)a).getSgroup()).getFreeLegalAttachAtoms()).length != 1) continue;
            for (j = 0; j < src.length; ++j) {
                if (src[j] == a) continue block0;
            }
            for (j = 0; j < src.length; ++j) {
                if (src[j].isBoundTo(a) || !MEFlow.isAcceptableAtomPair(src[j], a)) continue;
                MolAtom[] pair = new MolAtom[]{src[j], a};
                if (pairs != null) {
                    pairs[count] = pair;
                }
                ++count;
            }
        }
        return count;
    }

    private static boolean isAcceptableAtomPair(MolAtom a1, MolAtom a2) {
        MolAtom aa;
        SuperatomSgroup ssg;
        Sgroup sg2;
        Sgroup sg1 = MEFlow.getSgroupContaining(a1);
        if (sg1 == (sg2 = MEFlow.getSgroupContaining(a2))) {
            return true;
        }
        if (sg1 != null) {
            if (sg1 instanceof SuperatomSgroup) {
                ssg = (SuperatomSgroup)sg1;
                aa = ssg.findAttachAtom();
                if (aa != a1) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (sg2 != null) {
            if (sg2 instanceof SuperatomSgroup) {
                ssg = (SuperatomSgroup)sg2;
                aa = ssg.findAttachAtom();
                if (aa != a2) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidSourceForMolecule(Object source, Molecule m) {
        if (source != null && m != null) {
            if (source instanceof MolAtom) {
                return MEFlow.isValidSourceAtomForMolecule((MolAtom)source, m);
            }
            if (source instanceof MolBond) {
                return MEFlow.isValidSourceBondForMolecule((MolBond)source, m);
            }
            if (source instanceof MolAtom[]) {
                MolAtom[] sourceArray = (MolAtom[])source;
                if (sourceArray.length == 1) {
                    return MEFlow.isValidSourceAtomForMolecule(sourceArray[0], m);
                }
                if (sourceArray.length == 2 && sourceArray[0] != null && sourceArray[1] != null) {
                    if (sourceArray[0].isBoundTo(sourceArray[1])) {
                        return MEFlow.isValidSourceBondForMolecule(sourceArray[0].getBondTo(sourceArray[1]), m);
                    }
                    return MEFlow.isValidSourceAtomPairForMolecule(sourceArray, m);
                }
            }
        }
        return false;
    }

    public static boolean isValidSourceAndSinkForMolecule(Object source, Object sink, Molecule m) {
        if (sink != null && MEFlow.isValidSourceForMolecule(source, m)) {
            if (sink instanceof MolAtom) {
                if (source instanceof MolAtom) {
                    return MEFlow.isValidSourceAtomSinkAtomForMolecule((MolAtom)source, (MolAtom)sink, m);
                }
                if (source instanceof MolBond) {
                    return MEFlow.isValidSourceBondSinkAtomForMolecule((MolBond)source, (MolAtom)sink, m);
                }
                if (source instanceof MolAtom[]) {
                    MolAtom[] sourceArray = (MolAtom[])source;
                    if (sourceArray.length == 1) {
                        return MEFlow.isValidSourceAtomSinkAtomForMolecule(sourceArray[0], (MolAtom)sink, m);
                    }
                    if (sourceArray.length == 2 && sourceArray[0] != null && sourceArray[1] != null && sourceArray[0].isBoundTo(sourceArray[1])) {
                        return MEFlow.isValidSourceBondSinkAtomForMolecule(sourceArray[0].getBondTo(sourceArray[1]), (MolAtom)sink, m);
                    }
                }
            } else if (sink instanceof MolBond) {
                if (source instanceof MolAtom) {
                    return MEFlow.isValidSourceAtomSinkBondForMolecule((MolAtom)source, (MolBond)sink, m);
                }
                if (source instanceof MolBond) {
                    return MEFlow.isValidSourceBondSinkBondForMolecule((MolBond)source, (MolBond)sink, m);
                }
                if (source instanceof MolAtom[]) {
                    MolAtom[] sourceArray = (MolAtom[])source;
                    if (sourceArray.length == 1) {
                        return MEFlow.isValidSourceAtomSinkBondForMolecule(sourceArray[0], (MolBond)sink, m);
                    }
                    if (sourceArray.length == 2 && sourceArray[0] != null && sourceArray[1] != null && sourceArray[0].isBoundTo(sourceArray[1])) {
                        return MEFlow.isValidSourceBondSinkBondForMolecule(sourceArray[0].getBondTo(sourceArray[1]), (MolBond)sink, m);
                    }
                }
            } else if (sink instanceof MolAtom[]) {
                MolAtom[] sinkArray = (MolAtom[])sink;
                if (sinkArray.length == 1) {
                    return MEFlow.isValidSourceAndSinkForMolecule(source, sinkArray[0], m);
                }
                if (sinkArray.length == 2 && sinkArray[0].isBoundTo(sinkArray[1])) {
                    return MEFlow.isValidSourceAndSinkForMolecule(source, sinkArray[0].getBondTo(sinkArray[1]), m);
                }
                if (sinkArray.length != 2) {
                    return false;
                }
                if (source instanceof MolAtom) {
                    return MEFlow.isValidSourceAtomSinkAtomPairForMolecule((MolAtom)source, sinkArray, m);
                }
                if (source instanceof MolBond) {
                    return MEFlow.isValidSourceBondSinkAtomPairForMolecule((MolBond)source, sinkArray, m);
                }
                if (source instanceof MolAtom[]) {
                    MolAtom[] sourceArray = (MolAtom[])source;
                    if (sourceArray.length == 1) {
                        return MEFlow.isValidSourceAtomSinkAtomPairForMolecule(sourceArray[0], sinkArray, m);
                    }
                    if (sourceArray.length == 2 && sourceArray[0] != null && sourceArray[1] != null && sourceArray[0].isBoundTo(sourceArray[1])) {
                        return MEFlow.isValidSourceBondSinkAtomPairForMolecule(sourceArray[0].getBondTo(sourceArray[1]), sinkArray, m);
                    }
                }
            }
        }
        return false;
    }

    public Object getSource() {
        return this.getMolObject(0);
    }

    public Object getSink() {
        return this.getMolObject(1);
    }

    public boolean sourceIsAtom() {
        return MEFlow.isAtom(this.getSource());
    }

    public boolean sinkIsAtom() {
        return MEFlow.isAtom(this.getSink());
    }

    public static boolean isAtom(Object terminus) {
        return terminus instanceof MolAtom || terminus instanceof MEFlowBasePoint;
    }

    public boolean sourceIsBond() {
        return MEFlow.isBond(this.getSource());
    }

    public boolean sinkIsBond() {
        return MEFlow.isBond(this.getSink());
    }

    public static boolean isBond(Object terminus) {
        return terminus instanceof MolBond;
    }

    public boolean sinkIsIncipBond() {
        return MEFlow.isIncipBond(this.getSink());
    }

    public static boolean isIncipBond(Object sink) {
        return sink instanceof MolAtom[];
    }

    public MolAtom getSourceAtom() {
        return MEFlow.getAtom(this.getSource());
    }

    public MolAtom getSinkAtom() {
        return MEFlow.getAtom(this.getSink());
    }

    public static MolAtom getAtom(Object terminus) {
        MolAtom atom = terminus instanceof MolAtom ? (MolAtom)terminus : (terminus instanceof MEFlowBasePoint ? ((MEFlowBasePoint)terminus).getAtom() : null);
        return atom;
    }

    public static MolBond getBond(Object terminus) {
        if (terminus instanceof MolBond) {
            return (MolBond)terminus;
        }
        return null;
    }

    public MolBond getSourceBond() {
        return MEFlow.getBond(this.getSource());
    }

    public MolBond getSinkBond() {
        return MEFlow.getBond(this.getSink());
    }

    public MolAtom[] getSourceAtoms() {
        return MEFlow.getAtoms(this.getSource());
    }

    public MolAtom[] getSinkAtoms() {
        return MEFlow.getAtoms(this.getSink());
    }

    public static MolAtom[] getAtoms(Object terminus) {
        MolAtom[] atoms;
        if (MEFlow.isAtom(terminus)) {
            atoms = new MolAtom[]{MEFlow.getAtom(terminus)};
        } else if (MEFlow.isBond(terminus)) {
            MolBond bond = (MolBond)terminus;
            atoms = new MolAtom[]{bond.getAtom1(), bond.getAtom2()};
        } else {
            atoms = MEFlow.isIncipBond(terminus) ? (MolAtom[])terminus : new MolAtom[]{};
        }
        return atoms;
    }
}

