/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.graphics;

import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.graphics.MAtomSetPoint;
import chemaxon.struc.graphics.MChemicalStruct;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;

public class MEFlowBasePoint
extends MPoint {
    private static final long serialVersionUID = 1053944912020926984L;
    private transient MAtomSetPoint.MultiFaceAtom atom;
    private transient MPoint otherEnd;

    public MEFlowBasePoint() {
        super(0.0, 0.0, 0.0);
        this.atom = null;
        this.otherEnd = null;
    }

    public MEFlowBasePoint(MolAtom a, MPoint p) {
        super(0.0, 0.0, 0.0);
        this.setStartEnd(a, p);
    }

    public MEFlowBasePoint(MEFlowBasePoint p) {
        super(p);
        this.atom = p.atom;
        this.otherEnd = (MPoint)p.otherEnd.clone();
    }

    public boolean equals(MEFlowBasePoint o) {
        return this.atom.equals(o.atom) && this.otherEnd.equals(o.otherEnd);
    }

    @Override
    public boolean equals(MPoint o) {
        return o instanceof MEFlowBasePoint && this.equals((MEFlowBasePoint)o);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof MEFlowBasePoint && this.equals((MEFlowBasePoint)o);
    }

    @Override
    public Object clone() {
        return new MEFlowBasePoint(this);
    }

    public void setStartEnd(MolAtom a, MPoint p) {
        this.atom = new MAtomSetPoint.MultiFaceAtom(a);
        this.otherEnd = p;
    }

    public MolAtom getAtom() {
        return this.atom.getVisible();
    }

    public MPoint getOtherEnd() {
        return this.otherEnd;
    }

    @Override
    public boolean containsAtom(MolAtom a) {
        return this.atom.contains(a) || this.otherEnd.containsAtom(a);
    }

    @Override
    public void replaceAtom(MolAtom orig, MolAtom a) {
        this.atom.replace(orig, a);
        this.otherEnd.replaceAtom(orig, a);
    }

    @Override
    public void getLocation(DPoint3 out, CTransform3D trot) {
        if (this.atom == null) {
            out.x = 0.0;
            out.y = 0.0;
            out.z = 0.0;
        } else {
            MolAtom a = this.atom.getVisible();
            out.x = a.getX();
            out.y = a.getY();
            out.z = a.getZ();
            DPoint3[] dots = null;
            if (a.getRadicalCount() > 0) {
                dots = (DPoint3[])a.getTemporaryObject("radicalCoords");
            }
            if (dots == null && (a.getLonePairCount() != 0 || a.getElectronProp() > 0)) {
                dots = (DPoint3[])a.getTemporaryObject("lonePairCoords");
            }
            if (dots != null) {
                DPoint3 q = this.otherEnd.getLocation(null);
                double min = Double.MAX_VALUE;
                int jmin = 0;
                for (int j = 0; j < dots.length; ++j) {
                    double dz;
                    double dy;
                    double dx;
                    double rsq;
                    if (dots[j] == null || !((rsq = (dx = q.x - dots[j].x) * dx + (dy = q.y - dots[j].y) * dy + (dz = q.z - dots[j].z) * dz) + 1.0E-8 < min)) continue;
                    min = rsq;
                    jmin = j;
                }
                if (dots[jmin] != null) {
                    out.x = dots[jmin].x;
                    out.y = dots[jmin].y;
                    out.z = dots[jmin].z;
                }
            } else {
                DPoint3 nc = (DPoint3)a.getTemporaryObject("negativeChargeCoords");
                if (nc != null) {
                    out.x = nc.x;
                    out.y = nc.y;
                    out.z = nc.z;
                }
            }
        }
        if (trot != null) {
            trot.transform(out);
        }
    }

    @Override
    public void setLocation(DPoint3 p, CTransform3D trot) {
        if (this.atom == null) {
            super.setLocation(p, trot);
            return;
        }
        DPoint3 myloc = this.getLocation(null);
        if (trot != null) {
            CTransform3D tinvrot = new CTransform3D(trot);
            tinvrot.invert();
            p = new DPoint3(p);
            tinvrot.transform(p);
        }
        double dx = p.x - myloc.x;
        double dy = p.y - myloc.y;
        double dz = p.z - myloc.z;
        MolAtom a = this.atom.getVisible();
        a.setXYZ(a.getX() + dx, a.getY() + dy, a.getZ() + dz);
    }

    @Override
    public MPoint getPoint(int i) {
        return new MEFlowBasePoint(this);
    }

    @Override
    public void transform(CTransform3D t, int opts, CTransform3D trot) {
    }

    @Override
    public boolean isTransformable() {
        return false;
    }

    @Override
    public boolean checkValidity(MDocument doc, Collection<MolAtom> invec) {
        if (this.atom != null) {
            boolean ret = true;
            boolean found = false;
            for (int j = 0; j < doc.getObjectCount() && !found; ++j) {
                MObject mo = doc.getObject(j);
                found = mo instanceof MChemicalStruct && mo.containsAtom(this.atom.getVisible());
            }
            if (!found) {
                if (invec != null && !invec.contains(this.atom.getVisible())) {
                    invec.add(this.atom.getVisible());
                }
                ret = false;
            }
            if (ret) {
                ret = this.otherEnd != null ? this.otherEnd.checkValidity(doc, invec) : ret;
            }
            return ret;
        }
        return false;
    }

    @Override
    public void finishCloning(MDocument olddoc, MDocument newdoc) {
        for (int j = 0; j < olddoc.getObjectCount(); ++j) {
            MObject mo = olddoc.getObject(j);
            if (!(mo instanceof MChemicalStruct)) continue;
            MoleculeGraph m = ((MChemicalStruct)mo).getMoleculeGraph();
            int k = (m = m.getGraphUnion()).indexOf(this.atom.getVisible());
            if (k < 0) continue;
            MChemicalStruct mcs = (MChemicalStruct)newdoc.getObject(j);
            m = mcs.getMoleculeGraph().getGraphUnion();
            this.atom = new MAtomSetPoint.MultiFaceAtom(m.getAtom(k));
            break;
        }
        this.otherEnd.finishCloning(olddoc, newdoc);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(1);
        oos.writeObject(this.atom);
        oos.writeObject(this.otherEnd);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version == 0) {
            this.atom = new MAtomSetPoint.MultiFaceAtom((MolAtom)ois.readObject());
            this.otherEnd = (MPoint)ois.readObject();
        }
        if (version == 1) {
            this.atom = (MAtomSetPoint.MultiFaceAtom)ois.readObject();
            this.otherEnd = (MPoint)ois.readObject();
        }
        throw new IOException("Cannot deserialize point object with future version (" + version + ")");
    }
}

