/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.graphics;

import java.awt.Font;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;

public class MFont
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7769715209509613515L;
    private static final Properties FONT_FAMILY_HASH;
    private static final HashMap<String, Integer> STYLE_HASH;
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    private transient String theFamily;
    private transient short theStyle;
    private transient double theSize;
    private transient Font awtFont;

    public MFont(String family, int style, double size) {
        this.theFamily = family;
        this.theStyle = (short)style;
        this.theSize = size;
        this.awtFont = null;
    }

    public MFont(String str) throws IllegalArgumentException {
        double size;
        String family = null;
        int isize = -1;
        int style = 0;
        for (int i = 0; i < str.length(); ++i) {
            String s;
            Integer o;
            int k;
            if (str.charAt(i) != '-' || (k = str.indexOf(45, i + 1)) <= i || (o = STYLE_HASH.get(s = str.substring(i + 1, k).toUpperCase())) == null) continue;
            family = str.substring(0, i).trim();
            isize = k + 1;
            style = o;
            break;
        }
        if (family == null || family.length() == 0) {
            throw new IllegalArgumentException("font definition " + str + " does not contain a valid family name");
        }
        if (isize < 0) {
            throw new IllegalArgumentException("font definition " + str + " does not contain a valid style");
        }
        try {
            size = Double.valueOf(str.substring(isize));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("font definition " + str + " does not contain a valid size");
        }
        this.theFamily = family;
        this.theStyle = (short)style;
        this.theSize = size;
        this.awtFont = null;
    }

    public MFont(MFont f) {
        this.theFamily = f.theFamily;
        this.theStyle = f.theStyle;
        this.theSize = f.theSize;
        this.awtFont = f.awtFont;
    }

    public MFont(Font f) {
        this.theFamily = f.getFamily();
        this.theStyle = (short)f.getStyle();
        this.theSize = f.getSize2D();
        this.awtFont = f;
    }

    public String getFamily() {
        return this.theFamily;
    }

    public int getStyle() {
        return this.theStyle;
    }

    public double getSizeDouble() {
        return this.theSize;
    }

    public boolean isBold() {
        return (this.theStyle & 1) != 0;
    }

    public boolean isItalic() {
        return (this.theStyle & 2) != 0;
    }

    public Font getAWTFont() {
        Font f = this.awtFont;
        if (f == null) {
            String s = FONT_FAMILY_HASH.getProperty(this.theFamily.toLowerCase());
            if (s == null) {
                s = this.theFamily;
            }
            Font newFont = new Font(s, (int)this.theStyle, (int)this.theSize);
            this.awtFont = f = newFont.deriveFont((float)this.theSize);
        }
        return f;
    }

    public Font getScaledAWTFont(Float scale) {
        Font f = this.awtFont;
        if (f == null) {
            String s = FONT_FAMILY_HASH.getProperty(this.theFamily.toLowerCase());
            if (s == null) {
                s = this.theFamily;
            }
            f = new Font(s, (int)this.theStyle, (int)this.theSize);
            this.awtFont = f = f.deriveFont((float)this.theSize * scale.floatValue());
        } else {
            f = f.deriveFont((float)this.theSize * scale.floatValue());
        }
        return f;
    }

    public String getString() {
        StringBuffer sb = new StringBuffer(this.getFamily());
        sb.append('-');
        int style = this.getStyle();
        if (style == 0) {
            sb.append("PLAIN");
        } else {
            if ((style & 1) != 0) {
                sb.append("BOLD");
            }
            if ((style & 2) != 0) {
                sb.append("ITALIC");
            }
        }
        sb.append('-');
        sb.append(MFont.sizeToString(this.getSizeDouble()));
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof MFont) {
            MFont f = (MFont)o;
            return this.getFamily().equals(f.getFamily()) && this.getStyle() == f.getStyle() && this.getSizeDouble() == f.getSizeDouble();
        }
        return false;
    }

    public MFont cloneMFont() {
        MFont f = new MFont(this);
        return f;
    }

    public Object clone() {
        return this.cloneMFont();
    }

    public static String sizeToString(double size) {
        double intsize = Math.round(size);
        if (size == intsize && intsize >= -2.147483648E9 && intsize <= 2.147483647E9) {
            return String.valueOf((int)intsize);
        }
        return String.valueOf(size);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.writeUTF(this.theFamily);
        oos.writeShort(this.theStyle);
        oos.writeDouble(this.theSize);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize font wrapper object with future version (" + version + ")");
        }
        this.theFamily = ois.readUTF();
        this.theStyle = ois.readShort();
        this.theSize = ois.readDouble();
    }

    static {
        boolean java10;
        FONT_FAMILY_HASH = new Properties();
        String jver = System.getProperty("java.version");
        String os = System.getProperty("os.name");
        String vendor = System.getProperty("java.vendor");
        boolean netscape = vendor.equals("Netscape Communications Corporation");
        boolean bl = java10 = jver.startsWith("1.0") || netscape && (jver.equals("1.1.2") || jver.equals("1.1.5") && os.equals("Mac OS"));
        if (java10) {
            FONT_FAMILY_HASH.put("sansserif", "Helvetica");
        }
        HashMap<String, Integer> h = new HashMap<String, Integer>();
        h.put("", new Integer(0));
        h.put("PLAIN", new Integer(0));
        h.put("BOLD", new Integer(1));
        h.put("ITALIC", new Integer(2));
        h.put("BOLDITALIC", new Integer(3));
        STYLE_HASH = h;
    }
}

