/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.graphics;

import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MPolyline;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MMidPoint
extends MPoint {
    private static final long serialVersionUID = 5307361876930807239L;
    protected transient int polylinePointIndex;
    protected transient MPolyline parentLine;
    private transient boolean xyzSet = false;

    protected MMidPoint(MPolyline l, int i, double x, double y, double z) {
        super(x, y, z);
        this.polylinePointIndex = i;
        this.parentLine = l;
    }

    protected MMidPoint(MMidPoint p) {
        super(p);
        this.polylinePointIndex = p.polylinePointIndex;
        this.parentLine = p.parentLine;
        this.xyzSet = p.xyzSet;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof MMidPoint && this.equals((MMidPoint)o);
    }

    public boolean equals(MMidPoint o) {
        return this.polylinePointIndex == o.polylinePointIndex && this.parentLine == o.parentLine;
    }

    @Override
    public Object clone() {
        return new Sticky(this);
    }

    @Override
    public boolean isSelectableNow() {
        MPolyline l = this.parentLine;
        return l != null && !l.isSelected() && (l.internalPointAddCount == 0 || l.internalPointPos == this.polylinePointIndex);
    }

    @Override
    public boolean isChildOf(MObject o) {
        return this.parentLine == o;
    }

    public int getPositionInPolyline() {
        return this.polylinePointIndex;
    }

    public MPolyline getParentLine() {
        return this.parentLine;
    }

    void setParentLine(MPolyline l) {
        this.parentLine = l;
    }

    @Override
    public void addNotify() {
        this.parentLine.internalPointPos = this.polylinePointIndex;
        ++this.parentLine.internalPointAddCount;
    }

    @Override
    public void removeNotify() {
        if (--this.parentLine.internalPointAddCount == 0) {
            this.parentLine.internalPointPos = 0;
        }
    }

    @Override
    public void getLocation(DPoint3 q, CTransform3D t) {
        if (this.xyzSet) {
            this.getDraggedLocation(q, t);
        } else {
            this.getFixedLocation(q, t);
        }
    }

    private DPoint3 getDraggedLocation(CTransform3D t) {
        DPoint3 q = new DPoint3(0.0, 0.0, 0.0);
        this.getDraggedLocation(q, t);
        return q;
    }

    private void getDraggedLocation(DPoint3 q, CTransform3D t) {
        super.getLocation(q, t);
    }

    protected void getFixedLocation(DPoint3 q, CTransform3D t) {
        int n = this.parentLine.getPointCount();
        int i = this.polylinePointIndex;
        DPoint3 p = this.parentLine.getMidPointLocation(i % n, t);
        q.set(p);
    }

    @Override
    public void setLocation(DPoint3 p, CTransform3D trot) {
        super.setLocation(p, trot);
        this.correctArcAngle(trot);
    }

    @Override
    public void transform(CTransform3D t, int opts, CTransform3D trot) {
        super.transform(t, opts, trot);
        this.correctArcAngle(trot);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append('[');
        sb.append(this.parentLine.toString());
        sb.append(',');
        sb.append(this.polylinePointIndex);
        sb.append(']');
        return sb.toString();
    }

    private void correctArcAngle(CTransform3D trot) {
        int i = this.polylinePointIndex;
        MPolyline l = this.parentLine;
        int n = l.getPointCount();
        DPoint3 p1 = l.getPointRef(i % n, trot).getLocation(trot);
        DPoint3 p2 = l.getPointRef((i + 1) % n, trot).getLocation(trot);
        DPoint3 p4 = this.getLocation(trot);
        double sign = trot == null || trot.determinant2D() > 0.0 ? 1.0 : -1.0;
        l.transformArc(p1, p2, p4, sign);
        this.xyzSet = true;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.writeInt(this.polylinePointIndex);
        oos.writeObject(this.parentLine);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize middle point object with future version (" + version + ")");
        }
        this.polylinePointIndex = ois.readInt();
        this.parentLine = (MPolyline)ois.readObject();
    }

    public static class Sticky
    extends MMidPoint {
        private static final long serialVersionUID = 3223068581543532992L;

        public Sticky(MPolyline l, int i) {
            super(l, i, 0.0, 0.0, 0.0);
        }

        protected Sticky(MMidPoint p) {
            super(p);
        }

        @Override
        public Object clone() {
            return new Sticky(this);
        }

        @Override
        public void getLocation(DPoint3 q, CTransform3D t) {
            this.getFixedLocation(q, t);
        }
    }
}

