/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.graphics;

import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.graphics.MMidPoint;
import java.awt.Color;
import java.awt.Polygon;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

public class MPolyline
extends MObject {
    private static final long serialVersionUID = 4958026600768388648L;
    public static double DEFAULT_THICKNESS = 0.0625;
    public static final double DEFAULT_ARROW_HEAD_LENGTH = 0.8;
    public static final double DEFAULT_ARROW_HEAD_WIDTH = 0.5;
    public static int TAIL = 0;
    public static int HEAD = 1;
    public static int CLOSED_FLAG = 1;
    public static int THICKNESS_SET_FLAG = 2;
    public static int ARROW_BACK_FLAG = 1;
    public static int ARROW_HALF_MASK = 6;
    public static int ARROW_HALF_LEFT = 2;
    public static int ARROW_HALF_RIGHT = 4;
    protected transient MPoint[] points;
    private transient double thickness = 0.0;
    private transient double arcAngle = 0.0;
    private transient double[] arrowLength = null;
    private transient double[] arrowWidth = null;
    private transient int flags = 0;
    protected transient int[] arrowFlags = null;
    private transient double[] endPointSkips = null;
    transient int internalPointPos;
    transient int internalPointAddCount;

    public MPolyline() {
        this(null, null, null, null);
    }

    public MPolyline(MPoint p1, MPoint p2) {
        this(p1, p2, null, null);
    }

    public MPolyline(MPoint p1, MPoint p2, Color c, Color bg) {
        super(c, c, bg);
        if (p1 == null && p2 == null) {
            this.points = new MPoint[0];
        } else {
            this.points = new MPoint[2];
            this.points[0] = (MPoint)p1.clone();
            this.points[1] = (MPoint)p2.clone();
        }
        this.flags = 0;
        this.internalPointPos = 0;
        this.internalPointAddCount = 0;
    }

    protected MPolyline(boolean closed, Color c, Color bg) {
        super(c, c, bg);
        this.points = new MPoint[0];
        this.flags = closed ? CLOSED_FLAG : 0;
        this.internalPointPos = 0;
        this.internalPointAddCount = 0;
    }

    protected MPolyline(MPolyline l) {
        super(l);
        MPoint[] startp = l.points;
        this.points = new MPoint[startp.length];
        for (int i = 0; i < startp.length; ++i) {
            this.points[i] = (MPoint)startp[i].clone();
        }
        l.copyProperties(this);
        this.internalPointPos = 0;
        this.internalPointAddCount = 0;
    }

    public MPolyline(MPolyline l, MPoint p) {
        super(l.getColor(), l.getLineColor(), l.getBackground());
        MPoint[] startp = l.points;
        this.points = new MPoint[startp.length + 1];
        for (int i = 0; i < startp.length; ++i) {
            this.points[i] = (MPoint)startp[i].clone();
        }
        this.points[startp.length] = (MPoint)p.clone();
        this.internalPointPos = 0;
        this.internalPointAddCount = 0;
    }

    public void copyProperties(MPolyline l) {
        l.thickness = this.thickness;
        l.arcAngle = this.arcAngle;
        l.arrowLength = MPolyline.copyArrowProp(this.arrowLength);
        l.arrowWidth = MPolyline.copyArrowProp(this.arrowWidth);
        l.flags = this.flags;
        if (this.arrowFlags != null) {
            l.arrowFlags = new int[this.arrowFlags.length];
            System.arraycopy(this.arrowFlags, 0, l.arrowFlags, 0, this.arrowFlags.length);
        }
        if (this.endPointSkips != null) {
            l.endPointSkips = new double[this.endPointSkips.length];
            System.arraycopy(this.endPointSkips, 0, l.endPointSkips, 0, this.endPointSkips.length);
        }
    }

    public boolean isArrow() {
        return this.arrowFlags != null;
    }

    public void setArrow(boolean v) {
        if (v && this.isArrow() || !v && !this.isArrow()) {
            return;
        }
        if (v) {
            this.arrowFlags = new int[2];
            this.arrowLength = new double[2];
            this.arrowWidth = new double[2];
        } else {
            this.arrowFlags = null;
            this.arrowLength = null;
            this.arrowWidth = null;
        }
    }

    public void setPoints(MPoint[] p) {
        this.points = new MPoint[p.length];
        System.arraycopy(p, 0, this.points, 0, p.length);
    }

    @Override
    public Object clone() {
        return new MPolyline(this);
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int f) {
        this.flags = f;
    }

    public int getArrowFlags(int i) {
        return this.arrowFlags != null ? this.arrowFlags[i] : 0;
    }

    public void setArrowFlags(int i, int f) {
        if (f != 0) {
            this.setArrow(true);
        }
        if (this.arrowFlags != null) {
            this.arrowFlags[i] = f;
        }
    }

    public double getSkip(int i) {
        return this.endPointSkips != null ? this.endPointSkips[i] : 0.0;
    }

    public void setSkip(int i, double d) {
        if (d != 0.0) {
            if (this.endPointSkips == null) {
                this.endPointSkips = new double[2];
            }
            this.endPointSkips[i] = d;
        } else if (this.endPointSkips != null) {
            if (this.endPointSkips[1 - i] == 0.0) {
                this.endPointSkips = null;
            } else {
                this.endPointSkips[i] = 0.0;
            }
        }
    }

    @Override
    public boolean hasColor() {
        return false;
    }

    @Override
    public boolean hasLineColor() {
        return true;
    }

    @Override
    public boolean hasBackground() {
        return (this.flags & CLOSED_FLAG) != 0;
    }

    public boolean isThicknessSet() {
        return (this.flags & THICKNESS_SET_FLAG) != 0;
    }

    public double getThickness() {
        return this.isThicknessSet() ? this.thickness : DEFAULT_THICKNESS;
    }

    public void setThickness(double w) {
        this.flags = w == 0.0 ? (this.flags &= ~THICKNESS_SET_FLAG) : (this.flags |= THICKNESS_SET_FLAG);
        this.thickness = w;
    }

    public double getArcAngle() {
        return this.arcAngle;
    }

    public void setArcAngle(double phi) {
        this.arcAngle = phi;
    }

    public double getArcRadius(CTransform3D t) {
        if (this.arcAngle != 0.0) {
            return MPolyline.getArcRadius(this.points[0].getLocation(t), this.points[1].getLocation(t), this.arcAngle);
        }
        return 0.0;
    }

    public double getArrowLength(int i) {
        return this.arrowLength != null ? this.arrowLength[i] : 0.0;
    }

    public void setArrowLength(int i, double l) {
        if (l != 0.0) {
            this.setArrow(true);
        }
        if (this.arrowLength != null) {
            this.arrowLength[i] = l;
        }
    }

    public double getArrowWidth(int i) {
        return this.arrowWidth != null ? this.arrowWidth[i] : 0.0;
    }

    public void setArrowWidth(int i, double l) {
        if (l == 0.0) {
            if (this.arrowWidth != null) {
                if (this.arrowWidth[1 - i] == 0.0) {
                    this.setArrow(false);
                } else {
                    this.arrowFlags[i] = 0;
                    this.arrowLength[i] = 0.0;
                    this.arrowWidth[i] = 0.0;
                }
            }
        } else {
            this.setArrow(true);
            this.arrowWidth[i] = l;
        }
    }

    @Override
    public int getPointCount() {
        return this.points.length;
    }

    public MPoint[] getPoints() {
        int npoints = this.getPointCount();
        MPoint[] p = new MPoint[npoints];
        for (int i = 0; i < p.length; ++i) {
            p[i] = this.getPoint(i);
        }
        return p;
    }

    @Override
    public MPoint getPoint(int i) {
        return (MPoint)this.points[i].clone();
    }

    @Override
    public int getPointRefCount() {
        int n = this.points.length;
        boolean closed = (this.flags & CLOSED_FLAG) != 0;
        return closed ? 2 * n : 2 * n - 1;
    }

    @Override
    public MPoint getPointRef(int i, CTransform3D trot) {
        int n = this.points.length;
        if (i < n) {
            return this.points[i];
        }
        DPoint3 q = this.getMidPointLocation(i % n, trot);
        if (trot != null) {
            CTransform3D tinvrot = new CTransform3D(trot);
            tinvrot.invert();
            tinvrot.transform(q);
        }
        MMidPoint p = new MMidPoint(this, i % n, q.x, q.y, q.z);
        if (this.internalPointAddCount != 0 && this.internalPointPos == i) {
            p.setSelected(true);
        }
        return p;
    }

    public static void fixMidPointClones(MObject[] objarr0, MObject[] objarr) {
        for (int i = 0; i < objarr.length; ++i) {
            MObject oi0 = objarr0[i];
            if (!(oi0 instanceof MPolyline)) continue;
            MObject oi = objarr[i];
            for (int j = 0; j < oi0.getPointCount(); ++j) {
                MPoint oij0 = oi0.getPointRef(j, null);
                if (!(oij0 instanceof MMidPoint.Sticky)) continue;
                MMidPoint.Sticky rpij = (MMidPoint.Sticky)oi.getPointRef(j, null);
                int k = MPolyline.findParentLine(oij0, objarr0);
                if (k < 0) continue;
                rpij.setParentLine((MPolyline)objarr[k]);
            }
        }
    }

    private static int findParentLine(MObject o, MObject[] objarr0) {
        for (int k = 0; k < objarr0.length; ++k) {
            MObject ok0 = objarr0[k];
            if (!(ok0 instanceof MPolyline) || !o.isChildOf(ok0)) continue;
            return k;
        }
        return -1;
    }

    @Override
    public void transform(CTransform3D t, int opts, CTransform3D trot) {
        int npoints = this.getPointCount();
        for (int i = 0; i < npoints; ++i) {
            MPoint mp = this.points[i];
            mp.transform(t, opts, trot);
        }
        double c = Math.abs(t.getScale());
        for (int i = 0; i < 2; ++i) {
            this.setArrowLength(i, this.getArrowLength(i) * c);
            this.setArrowWidth(i, this.getArrowWidth(i) * c);
            this.setSkip(i, this.getSkip(i) * c);
        }
        if (t.m00 * t.m11 - t.m01 * t.m10 < 0.0) {
            this.arcAngle = -this.arcAngle;
        }
        if ((opts & 1) != 0 && npoints == 2) {
            MPoint mp0 = this.getPoint(0);
            MPoint mp1 = this.getPoint(1);
            if (!mp0.isTransformable() && !mp1.isTransformable()) {
                this.transformArc(mp0, mp1, t, trot);
            }
        }
    }

    public void reverse() {
        for (int i = 0; i < this.points.length / 2; ++i) {
            MPoint t = this.points[i];
            this.points[i] = this.points[this.points.length - i - 1];
            this.points[this.points.length - i - 1] = t;
        }
    }

    @Override
    public void updateBoundingRect(double[] xyminm, CTransform3D pretrf) {
        double angle = this.getArcAngle();
        if (angle == 0.0) {
            super.updateBoundingRect(xyminm, pretrf);
        } else {
            DPoint3 p1 = this.getPointRef(0, pretrf).getLocation();
            DPoint3 p2 = this.getPointRef(1, pretrf).getLocation();
            DPoint3[] refp = MPolyline.calcArcRefs(p1, p2, angle);
            for (int i = 0; i < refp.length; ++i) {
                DPoint3 p = refp[i];
                pretrf.transform(p);
                if (p.x < xyminm[0]) {
                    xyminm[0] = p.x;
                }
                if (p.y < xyminm[1]) {
                    xyminm[1] = p.y;
                }
                if (p.x > xyminm[2]) {
                    xyminm[2] = p.x;
                }
                if (!(p.y > xyminm[3])) continue;
                xyminm[3] = p.y;
            }
        }
    }

    private static DPoint3[] calcArcRefs(DPoint3 p1, DPoint3 p2, double angle) {
        angle = -angle;
        DPoint3 origo = MPolyline.getArcCenter(p1, p2, angle);
        double[] dx = new double[2];
        double[] dy = new double[2];
        dx[0] = p1.x - origo.x;
        dy[0] = p1.y - origo.y;
        dx[1] = p2.x - origo.x;
        dy[1] = p2.y - origo.y;
        DPoint3[] axps = new DPoint3[4];
        double r = Math.sqrt(dx[0] * dx[0] + dy[0] * dy[0]);
        axps[0] = new DPoint3(origo.x, (r *= 1.5) + origo.y, origo.z);
        axps[1] = new DPoint3(-r + origo.x, origo.y, origo.z);
        axps[2] = new DPoint3(origo.x, -r + origo.y, origo.z);
        axps[3] = new DPoint3(r + origo.x, origo.y, origo.z);
        int[] q = new int[2];
        for (int i = 0; i < 2; ++i) {
            if (0.0 <= dx[i]) {
                if (0.0 <= dy[i]) {
                    q[i] = 0;
                    continue;
                }
                q[i] = 3;
                continue;
            }
            q[i] = 0.0 <= dy[i] ? 1 : 2;
        }
        String order = "01230123";
        if (q[0] == q[1] && Math.abs(angle) < 180.0) {
            order = "";
        } else {
            if (angle < 0.0) {
                int t = q[0];
                q[0] = q[1];
                q[1] = t;
            }
            order = order.substring(q[0]);
            order = order.substring(0, order.indexOf(String.valueOf(q[1]), 1));
        }
        DPoint3[] crossings = new DPoint3[order.length() + 2];
        int j = 0;
        crossings[j++] = p1;
        crossings[j++] = p2;
        for (int i = 0; i < order.length(); ++i) {
            char c = order.charAt(i);
            int index = Integer.valueOf(String.valueOf(c));
            crossings[j++] = axps[index];
        }
        return crossings;
    }

    private void transformArc(MPoint mp0, MPoint mp1, CTransform3D t, CTransform3D trot) {
        DPoint3 p1 = mp0.getLocation(trot);
        DPoint3 p2 = mp1.getLocation(trot);
        double sign = trot == null || trot.determinant2D() > 0.0 ? 1.0 : -1.0;
        double angle = -sign * this.arcAngle;
        DPoint3 p4 = MPolyline.getArcMiddlePoint(p1, p2, angle);
        CTransform3D tinvrot = new CTransform3D(trot);
        tinvrot.invert();
        CTransform3D t2 = new CTransform3D(trot);
        t2.mul(t);
        t2.mul(tinvrot);
        t2.transform(p4);
        this.transformArc(p1, p2, p4, sign);
    }

    void transformArc(DPoint3 p1, DPoint3 p2, DPoint3 p4, double sign) {
        DPoint3 p3 = MPolyline.getLineMiddlePoint(p1, p2);
        if ((p2.x - p1.x) * (p4.y - p1.y) - (p2.y - p1.y) * (p4.x - p1.x) < 0.0) {
            sign = -sign;
        }
        DPoint3 p0 = MPolyline.getArcCenter(p1, p2, p4);
        double old = this.arcAngle;
        if (p0 == null) {
            this.arcAngle = 0.0;
        } else {
            double r01 = p0.distance2D(p1);
            double r03 = p0.distance2D(p3);
            double alpha = 2.0 * Math.acos(r03 / r01);
            if ((p4.x - p3.x) * (p3.x - p0.x) + (p4.y - p3.y) * (p3.y - p0.y) < 0.0) {
                alpha = Math.PI * 2 - alpha;
            }
            this.arcAngle = sign * alpha * 180.0 / Math.PI;
        }
        if ((old >= 0.0 && this.arcAngle < 0.0 || old < 0.0 && this.arcAngle >= 0.0) && this.arrowFlags != null) {
            this.setArrowFlags(0, this.getMirroredArrowFlags(0));
            this.setArrowFlags(1, this.getMirroredArrowFlags(1));
        }
    }

    @Override
    public void unselectContents() {
        int npoints = this.getPointCount();
        for (int i = 0; i < npoints; ++i) {
            MPoint mp = this.points[i];
            mp.setSelected(false);
        }
    }

    @Override
    public void calcCenter(DPoint3 p, CTransform3D trot) {
        int npoints = this.getPointCount();
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        DPoint3 tmp = new DPoint3(0.0, 0.0, 0.0);
        for (int i = 0; i < npoints; ++i) {
            MPoint mp = this.getPoint(i);
            mp.getLocation(tmp, trot);
            x += tmp.x;
            y += tmp.y;
            z += tmp.z;
        }
        p.x = x / (double)npoints;
        p.y = y / (double)npoints;
        p.z = z / (double)npoints;
    }

    public DPoint3 getMidPointLocation(int i, CTransform3D t) {
        int n = this.points.length;
        double angle = this.arcAngle;
        DPoint3 p1 = this.points[i].getLocation(t);
        DPoint3 p2 = this.points[(i + 1) % n].getLocation(t);
        if (angle == 0.0) {
            return MPolyline.getLineMiddlePoint(p1, p2);
        }
        if (t == null || t.determinant2D() > 0.0) {
            angle = -angle;
        }
        return MPolyline.getArcMiddlePoint(p1, p2, angle);
    }

    @Override
    public double distanceFrom(double x, double y, CTransform3D t) {
        return MPolyline.distanceFrom(this, x, y, t);
    }

    public static void rotate(DPoint3 p0, double dphi, DPoint3 p) {
        double phi = Math.atan2(p.y - p0.y, p.x - p0.x);
        double r = p0.distance2D(p);
        p.x = p0.x + r * Math.cos(phi += dphi);
        p.y = p0.y + r * Math.sin(phi);
    }

    private static DPoint3 getLineMiddlePoint(DPoint3 p1, DPoint3 p2) {
        return new DPoint3((p1.x + p2.x) / 2.0, (p1.y + p2.y) / 2.0, (p1.z + p2.z) / 2.0);
    }

    public static double getArcRadius(DPoint3 p1, DPoint3 p2, double angle) {
        DPoint3 p0 = MPolyline.getArcCenter(p1, p2, angle);
        return p0.distance2D(p1);
    }

    public static DPoint3 getArcCenter(DPoint3 p1, DPoint3 p2, double angle) {
        double dphi = (angle > 0.0 ? 90.0 - angle / 2.0 : -90.0 - angle / 2.0) * Math.PI / 180.0;
        DPoint3 p3 = MPolyline.getLineMiddlePoint(p1, p2);
        double dx13 = p3.x - p1.x;
        double dy13 = p3.y - p1.y;
        double tandphi = Math.tan(dphi);
        double px0 = p3.x - dy13 * tandphi;
        double py0 = p3.y + dx13 * tandphi;
        return new DPoint3(px0, py0, p3.z);
    }

    private static DPoint3 getArcCenter(DPoint3 p1, DPoint3 p2, DPoint3 p4) {
        double x4 = p4.x;
        double y1 = p1.y;
        double y2 = p2.y;
        double x1 = p1.x;
        double y4 = p4.y;
        double x2 = p2.x;
        double denom = x4 * y1 - x4 * y2 + x1 * y2 - x1 * y4 + x2 * y4 - x2 * y1;
        if (Math.abs(denom) < 1.0E-12) {
            return null;
        }
        double x0 = 0.5 * (x4 * x4 * y1 - x4 * x4 * y2 - y1 * y2 * y2 + y1 * y1 * y2 + x1 * x1 * y2 + y4 * x2 * x2 + y4 * y4 * y1 - y1 * x2 * x2 - y4 * x1 * x1 - y4 * y4 * y2 - y4 * y1 * y1 + y4 * y2 * y2) / denom;
        double y0 = -0.5 * (-x4 * x1 * x1 - x4 * y1 * y1 + x2 * x1 * x1 + x4 * x2 * x2 + x4 * y2 * y2 + x1 * x4 * x4 - x1 * x2 * x2 - x1 * y2 * y2 - x2 * x4 * x4 - x2 * y4 * y4 + x1 * y4 * y4 + x2 * y1 * y1) / denom;
        double z0 = (p1.z + p2.z) / 2.0;
        return new DPoint3(x0, y0, z0);
    }

    private static DPoint3 getArcMiddlePoint(DPoint3 p1, DPoint3 p2, double angle) {
        double alpha = angle * Math.PI / 720.0;
        DPoint3 p0 = MPolyline.getArcCenter(p1, p2, angle);
        double r12 = 0.5 * p1.distance2D(p2);
        double r14 = r12 / Math.cos(alpha);
        double beta = -alpha + Math.atan2(p2.y - p1.y, p2.x - p1.x);
        return new DPoint3(p1.x + r14 * Math.cos(beta), p1.y + r14 * Math.sin(beta), p0.z);
    }

    @Override
    public boolean isEmpty() {
        int npoints = this.getPointCount();
        return npoints < 2;
    }

    public boolean hasOutline() {
        return this.getLineColor() != null || !this.hasFace();
    }

    public boolean hasFace() {
        return (this.flags & CLOSED_FLAG) != 0 && this.getBackground() != null;
    }

    @Override
    public void removeChild(MObject o) {
        if (!this.isArrow() && o instanceof MPoint) {
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i] != o) continue;
                this.removePoint(i);
                return;
            }
        }
    }

    @Override
    public void addAttributeKeys(List<String> v) {
        String keystr = "thickness arcAngle headSkip headFlags headLength headWidth tailSkip tailFlags tailLength tailWidth";
        super.addAttributeKeys(v);
        StringTokenizer st = new StringTokenizer(keystr);
        while (st.hasMoreElements()) {
            v.add(st.nextToken());
        }
    }

    @Override
    public String getAttribute(String s) {
        if (s.equalsIgnoreCase("thickness")) {
            return (this.flags & THICKNESS_SET_FLAG) != 0 ? String.valueOf(this.thickness) : null;
        }
        if (s.equalsIgnoreCase("arcAngle")) {
            return this.arcAngle != 0.0 ? String.valueOf(this.arcAngle) : null;
        }
        if (s.equalsIgnoreCase("headFlags")) {
            return MPolyline.getArrowPropAsString(this.arrowFlags, HEAD);
        }
        if (s.equalsIgnoreCase("headLength")) {
            return MPolyline.getArrowPropAsString(this.arrowLength, HEAD);
        }
        if (s.equalsIgnoreCase("headWidth")) {
            return MPolyline.getArrowPropAsString(this.arrowWidth, HEAD);
        }
        if (s.equalsIgnoreCase("headSkip")) {
            return MPolyline.getArrowPropAsString(this.endPointSkips, HEAD);
        }
        if (s.equalsIgnoreCase("tailFlags")) {
            return MPolyline.getArrowPropAsString(this.arrowFlags, TAIL);
        }
        if (s.equalsIgnoreCase("tailLength")) {
            return MPolyline.getArrowPropAsString(this.arrowLength, TAIL);
        }
        if (s.equalsIgnoreCase("tailWidth")) {
            return MPolyline.getArrowPropAsString(this.arrowWidth, TAIL);
        }
        if (s.equalsIgnoreCase("tailSkip")) {
            return MPolyline.getArrowPropAsString(this.endPointSkips, TAIL);
        }
        return super.getAttribute(s);
    }

    @Override
    public void setAttribute(String s, String v) {
        if (s.equalsIgnoreCase("thickness")) {
            this.setThickness(Double.valueOf(v));
        } else if (s.equalsIgnoreCase("arcAngle")) {
            this.setArcAngle(Double.valueOf(v));
        } else if (s.equalsIgnoreCase("headFlags")) {
            this.setArrowFlags(HEAD, Integer.parseInt(v));
        } else if (s.equalsIgnoreCase("headLength")) {
            this.setArrowLength(HEAD, Double.valueOf(v));
        } else if (s.equalsIgnoreCase("headWidth")) {
            this.setArrowWidth(HEAD, Double.valueOf(v));
        } else if (s.equalsIgnoreCase("headSkip")) {
            this.setSkip(HEAD, Double.valueOf(v));
        } else if (s.equalsIgnoreCase("tailFlags")) {
            this.setArrowFlags(TAIL, Integer.parseInt(v));
        } else if (s.equalsIgnoreCase("tailLength")) {
            this.setArrowLength(TAIL, Double.valueOf(v));
        } else if (s.equalsIgnoreCase("tailWidth")) {
            this.setArrowWidth(TAIL, Double.valueOf(v));
        } else if (s.equalsIgnoreCase("tailSkip")) {
            this.setSkip(TAIL, Double.valueOf(v));
        } else {
            super.setAttribute(s, v);
        }
    }

    @Override
    public boolean containsAtom(MolAtom a) {
        for (int i = 0; i < this.points.length; ++i) {
            if (!this.points[i].containsAtom(a)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void replaceAtom(MolAtom orig, MolAtom a) {
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i].replaceAtom(orig, a);
        }
    }

    @Override
    public boolean checkValidity(MDocument doc, Collection<MolAtom> invec) {
        boolean ret = true;
        for (int i = 0; i < this.points.length; ++i) {
            if (this.points[i].checkValidity(doc, invec)) continue;
            ret = false;
        }
        return ret;
    }

    @Override
    public void finishCloning(MDocument olddoc, MDocument newdoc) {
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i].finishCloning(olddoc, newdoc);
        }
    }

    private void removePoint(int i) {
        MPoint[] d = new MPoint[this.points.length - 1];
        System.arraycopy(this.points, 0, d, 0, i);
        System.arraycopy(this.points, i + 1, d, i, d.length - i);
        this.points = d;
    }

    private static double[] copyArrowProp(double[] x) {
        if (x != null) {
            double[] y = new double[]{x[0], x[1]};
            return y;
        }
        return null;
    }

    private static String getArrowPropAsString(Object o, int i) {
        if (o == null) {
            return null;
        }
        if (o instanceof double[]) {
            double[] x = (double[])o;
            return x[i] != 0.0 ? String.valueOf(x[i]) : null;
        }
        if (o instanceof int[]) {
            int[] x = (int[])o;
            return x[i] != 0 ? String.valueOf(x[i]) : null;
        }
        throw new RuntimeException("unhandled arrow property class " + o.getClass());
    }

    private static double distanceFrom(MPolyline l, double x, double y, CTransform3D t) {
        int i;
        double dmin = Double.MAX_VALUE;
        double angle = l.getArcAngle();
        if (angle != 0.0 && (t == null || t.determinant2D() > 0.0)) {
            angle = -angle;
        }
        int flags = l.getFlags();
        int npoints = l.getPointCount();
        DPoint3 tp1 = new DPoint3();
        DPoint3 tp2 = new DPoint3();
        int n = i = (flags & CLOSED_FLAG) != 0 ? 0 : 1;
        while (i < npoints) {
            double d;
            double ey;
            MPoint p1 = l.getPoint((i + npoints - 1) % npoints);
            MPoint p2 = l.getPoint(i);
            DPoint3 pp1 = p1.getLocation(t);
            DPoint3 pp2 = p2.getLocation(t);
            tp1.set(pp1);
            tp2.set(pp2);
            DPoint3 p0 = null;
            DPoint3 tp0 = null;
            if (angle != 0.0) {
                p0 = MPolyline.getArcCenter(pp1, pp2, angle);
                tp0 = new DPoint3(p0);
            }
            double x1 = x - tp1.x;
            double y1 = y - tp1.y;
            double x2 = x - tp2.x;
            double y2 = y - tp2.y;
            double rx = tp2.x - tp1.x;
            double ry = tp2.y - tp1.y;
            double rxy = Math.sqrt(rx * rx + ry * ry);
            double ex = rx / rxy;
            if (x1 * ex + y1 * (ey = ry / rxy) < 0.0 && Math.abs(angle) < 180.0) {
                d = Math.sqrt(x1 * x1 + y1 * y1);
            } else if (x2 * ex + y2 * ey > 0.0 && Math.abs(angle) < 180.0) {
                d = Math.sqrt(x2 * x2 + y2 * y2);
            } else if (p0 != null) {
                double r01 = MPolyline.getArcRadius(pp1, pp2, angle);
                double x0 = x - tp0.x;
                double y0 = y - tp0.y;
                double r0 = Math.sqrt(x0 * x0 + y0 * y0);
                d = Math.abs(r01 - r0);
            } else {
                double nx = -ey;
                double ny = ex;
                d = Math.abs(x1 * nx + y1 * ny);
            }
            if (d < dmin) {
                dmin = d;
            }
            ++i;
        }
        if (l.hasFace()) {
            int[] xx = new int[npoints];
            int[] yy = new int[npoints];
            for (int i2 = 0; i2 < npoints; ++i2) {
                MPoint p = l.getPoint(i2);
                DPoint3 tp = p.getLocation(t);
                xx[i2] = (int)Math.round(1000.0 * tp.x);
                yy[i2] = (int)Math.round(1000.0 * tp.y);
            }
            Polygon poly = new Polygon(xx, yy, xx.length);
            if (poly.contains((int)Math.round(1000.0 * x), (int)Math.round(1000.0 * y))) {
                dmin = 0.0;
            }
        }
        return dmin;
    }

    protected int getMirroredArrowFlags(int i) {
        int f = this.arrowFlags[i];
        int half = f & ARROW_HALF_MASK;
        int f0 = f & ~ARROW_HALF_MASK;
        if (half == ARROW_HALF_LEFT) {
            return f0 | ARROW_HALF_RIGHT;
        }
        if (half == ARROW_HALF_RIGHT) {
            return f0 | ARROW_HALF_LEFT;
        }
        return f;
    }

    @Override
    public void fixClonedPoints(MObject[] objarr0, MObject[] objarr, int i) {
        MObject oi = objarr[i];
        for (int j = 0; j < this.getPointCount(); ++j) {
            MPoint oij0 = this.getPointRef(j, null);
            if (!(oij0 instanceof MMidPoint.Sticky)) continue;
            MMidPoint.Sticky rpij = (MMidPoint.Sticky)oi.getPointRef(j, null);
            int k = MPolyline.findParentLine(oij0, objarr0);
            if (k < 0) continue;
            rpij.setParentLine((MPolyline)objarr[k]);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        int f;
        oos.writeByte(2);
        oos.writeInt(this.points.length);
        for (int i = 0; i < this.points.length; ++i) {
            oos.writeObject(this.points[i]);
        }
        oos.writeInt(this.flags);
        if ((this.flags & THICKNESS_SET_FLAG) != 0) {
            oos.writeDouble(this.thickness);
        }
        oos.writeDouble(this.arcAngle);
        int n = f = this.endPointSkips != null ? 1 : 0;
        if (this.isArrow()) {
            f |= 2;
        }
        oos.writeInt(f);
        if ((f & 1) != 0) {
            oos.writeDouble(this.endPointSkips[0]);
            oos.writeDouble(this.endPointSkips[1]);
        }
        if ((f & 2) != 0) {
            for (int i = 0; i < 2; ++i) {
                oos.writeInt(this.arrowFlags[i]);
                oos.writeDouble(this.arrowLength[i]);
                oos.writeDouble(this.arrowWidth[i]);
            }
        }
        oos.writeInt(this.internalPointPos);
        oos.writeInt(this.internalPointAddCount);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 2) {
            throw new IOException("Cannot deserialize line object with future version (" + version + ")");
        }
        int n = ois.readInt();
        this.points = new MPoint[n];
        for (int i = 0; i < n; ++i) {
            this.points[i] = (MPoint)ois.readObject();
        }
        this.flags = ois.readInt();
        if ((this.flags & THICKNESS_SET_FLAG) != 0) {
            this.thickness = ois.readDouble();
        }
        if (version > 0) {
            this.arcAngle = ois.readDouble();
            int f = ois.readInt();
            if ((f & 1) != 0) {
                this.endPointSkips = new double[2];
                this.endPointSkips[0] = ois.readDouble();
                this.endPointSkips[1] = ois.readDouble();
            }
            if ((f & 2) != 0) {
                this.setArrow(true);
                for (int i = 0; i < 2; ++i) {
                    this.arrowFlags[i] = ois.readInt();
                    this.arrowLength[i] = ois.readDouble();
                    this.arrowWidth[i] = ois.readDouble();
                }
            }
        }
        if (version > 1) {
            this.internalPointPos = ois.readInt();
            this.internalPointAddCount = ois.readInt();
        }
    }
}

