/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.graphics;

import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MPolyline;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MRArrow
extends MPolyline {
    private static final long serialVersionUID = 8638690394107448092L;
    private transient int arrow_type = 0;

    public MRArrow(MPoint point, MPoint point2) {
        super(point, point2);
        this.setType(0);
    }

    public MRArrow() {
        this.setType(0);
    }

    public MRArrow(MRArrow arrow) {
        super(arrow);
        this.arrow_type = arrow.arrow_type;
    }

    @Override
    public Object clone() {
        return new MRArrow(this);
    }

    @Override
    public void removeChild(MObject o) {
    }

    public int getType() {
        return this.arrow_type;
    }

    public void copyProperties(MRArrow l) {
        super.copyProperties(l);
        l.arrow_type = this.arrow_type;
    }

    public void setType(int type) {
        if (type == 1 || type == 3 || type == 2) {
            this.setArrowFlags(TAIL, ARROW_BACK_FLAG);
        }
        if (type == 3) {
            this.setArrowWidth(MPolyline.HEAD, 0.2);
            this.setArrowLength(MPolyline.HEAD, 0.15);
            this.setArrowWidth(MPolyline.TAIL, 0.2);
            this.setArrowLength(MPolyline.TAIL, 0.15);
        } else if (type == 2) {
            this.setArrowWidth(MPolyline.HEAD, 0.2);
            this.setArrowLength(MPolyline.HEAD, 0.14);
            this.setArrowWidth(MPolyline.TAIL, 0.2);
            this.setArrowLength(MPolyline.TAIL, 0.14);
        } else if (type == 1) {
            this.setArrowWidth(MPolyline.HEAD, 0.3);
            this.setArrowLength(MPolyline.HEAD, 0.5);
            this.setArrowWidth(MPolyline.TAIL, 0.3);
            this.setArrowLength(MPolyline.TAIL, 0.5);
        } else if (type == 0) {
            this.setArrowWidth(MPolyline.HEAD, 0.3);
            this.setArrowLength(MPolyline.HEAD, 0.5);
            this.setArrowWidth(MPolyline.TAIL, 0.0);
            this.setArrowLength(MPolyline.TAIL, 0.0);
        }
        this.arrow_type = type;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.writeInt(this.arrow_type);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize MRArrow object with future version (" + version + ")");
        }
        this.arrow_type = ois.readInt();
    }
}

