/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.graphics;

import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.graphics.MRectanglePoint;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

public class MRectangle
extends MPolyline {
    private static final long serialVersionUID = 2948229815278089239L;
    public static final int T_NOROT = 1;
    public static final int P_NW = 0;
    public static final int P_NE = 1;
    public static final int P_SE = 2;
    public static final int P_SW = 3;
    public static final int P_CENTER = 4;
    public static final int P_N = 5;
    public static final int P_E = 6;
    public static final int P_S = 7;
    public static final int P_W = 8;
    private static final String[] P_NAMES = new String[9];
    transient byte internalPointPos;
    transient int internalPointAddCount;
    private transient byte tOption = 0;
    private transient byte tCenter = (byte)4;

    public MRectangle() {
        this(new MPoint(0.0, 0.0, 0.0), new MPoint(0.0, 0.0, 0.0), null, null);
    }

    public MRectangle(MPoint p1, MPoint p2) {
        this(p1, p2, null, null);
    }

    public MRectangle(MPoint p1, MPoint p2, Color c, Color bg) {
        super(true, c, bg);
        this.internalPointPos = 0;
        this.internalPointAddCount = 0;
        this.setCorners(p1, p2);
    }

    protected MRectangle(MRectangle r) {
        super(r);
        this.tOption = r.tOption;
        this.tCenter = r.tCenter;
        this.internalPointPos = 0;
        this.internalPointAddCount = 0;
    }

    @Override
    public void calcCenter(DPoint3 p, CTransform3D t) {
        if (this.tCenter >= 0 && this.tCenter < 4) {
            this.getPointRef(this.tCenter - 0, t).getLocation(p, t);
        } else if (this.tCenter == 4) {
            super.calcCenter(p, t);
        } else {
            int j;
            int i;
            if (this.tCenter == 5) {
                i = 0;
                j = 1;
            } else if (this.tCenter == 6) {
                i = 1;
                j = 2;
            } else if (this.tCenter == 7) {
                i = 2;
                j = 3;
            } else {
                i = 0;
                j = 3;
            }
            DPoint3 p1 = this.getPointRef(i, t).getLocation(t);
            DPoint3 p2 = this.getPointRef(j, t).getLocation(t);
            p.x = (p1.x + p2.x) / 2.0;
            p.y = (p1.y + p2.y) / 2.0;
            p.z = (p1.z + p2.z) / 2.0;
        }
    }

    @Override
    public void transform(CTransform3D t, int opts, CTransform3D trot) {
        t = this.convertTransform(t, false);
        super.transform(t, opts, trot);
    }

    public void transformTo2D() {
        DPoint3 p0 = new DPoint3();
        this.calcCenter(p0, null);
        DPoint3[] p = new DPoint3[4];
        for (int i = 0; i < p.length; ++i) {
            p[i] = super.getPointRef(i, null).getLocation();
        }
        double hx = p[1].x - p[0].x;
        double hy = p[1].y - p[0].y;
        double hz = p[1].z - p[0].z;
        double hr = Math.sqrt(hx * hx + hy * hy + hz * hz);
        double vx = p[3].x - p[0].x;
        double vy = p[3].y - p[0].y;
        double vz = p[3].z - p[0].z;
        double vr = Math.sqrt(vx * vx + vy * vy + vz * vz);
        DPoint3[] q = new DPoint3[4];
        if (this.tCenter == 0) {
            q[0] = new DPoint3(0.0, 0.0, 0.0);
            q[1] = new DPoint3(hr, 0.0, 0.0);
            q[2] = new DPoint3(hr, -vr, 0.0);
            q[3] = new DPoint3(0.0, -vr, 0.0);
        } else if (this.tCenter == 1) {
            q[0] = new DPoint3(-hr, 0.0, 0.0);
            q[1] = new DPoint3(0.0, 0.0, 0.0);
            q[2] = new DPoint3(0.0, -vr, 0.0);
            q[3] = new DPoint3(-hr, -vr, 0.0);
        } else if (this.tCenter == 2) {
            q[0] = new DPoint3(-hr, vr, 0.0);
            q[1] = new DPoint3(0.0, vr, 0.0);
            q[2] = new DPoint3(0.0, 0.0, 0.0);
            q[3] = new DPoint3(-hr, 0.0, 0.0);
        } else if (this.tCenter == 3) {
            q[0] = new DPoint3(0.0, vr, 0.0);
            q[1] = new DPoint3(hr, vr, 0.0);
            q[2] = new DPoint3(hr, 0.0, 0.0);
            q[3] = new DPoint3(0.0, 0.0, 0.0);
        } else if (this.tCenter == 4) {
            q[0] = new DPoint3(-hr / 2.0, vr / 2.0, 0.0);
            q[1] = new DPoint3(hr / 2.0, vr / 2.0, 0.0);
            q[2] = new DPoint3(hr / 2.0, -vr / 2.0, 0.0);
            q[3] = new DPoint3(-hr / 2.0, -vr / 2.0, 0.0);
        } else if (this.tCenter == 5) {
            q[0] = new DPoint3(-hr / 2.0, 0.0, 0.0);
            q[1] = new DPoint3(hr / 2.0, 0.0, 0.0);
            q[2] = new DPoint3(hr / 2.0, -vr, 0.0);
            q[3] = new DPoint3(-hr / 2.0, -vr, 0.0);
        } else if (this.tCenter == 6) {
            q[0] = new DPoint3(-hr, vr / 2.0, 0.0);
            q[1] = new DPoint3(0.0, vr / 2.0, 0.0);
            q[2] = new DPoint3(0.0, -vr / 2.0, 0.0);
            q[3] = new DPoint3(-hr, -vr / 2.0, 0.0);
        } else if (this.tCenter == 7) {
            q[0] = new DPoint3(-hr / 2.0, vr, 0.0);
            q[1] = new DPoint3(hr / 2.0, vr, 0.0);
            q[2] = new DPoint3(hr / 2.0, 0.0, 0.0);
            q[3] = new DPoint3(-hr / 2.0, 0.0, 0.0);
        } else if (this.tCenter == 8) {
            q[0] = new DPoint3(0.0, vr / 2.0, 0.0);
            q[1] = new DPoint3(hr, vr / 2.0, 0.0);
            q[2] = new DPoint3(hr, -vr / 2.0, 0.0);
            q[3] = new DPoint3(0.0, -vr / 2.0, 0.0);
        }
        for (int i = 0; i < 4; ++i) {
            q[i].x += p0.x;
            q[i].y += p0.y;
            q[i].z += p0.z;
            super.getPointRef(i, null).setLocation(q[i], null);
        }
    }

    public CTransform3D convertTransform(CTransform3D t, boolean paint) {
        if ((this.tOption & 1) != 0) {
            DPoint3 p0 = new DPoint3();
            this.calcCenter(p0, null);
            double scale = t.getScale();
            DPoint3 p = new DPoint3(p0);
            t.transform(p);
            t = new CTransform3D();
            t.setZero();
            if (paint && scale < 0.0) {
                t.m00 = -scale;
                t.m11 = scale;
                t.m22 = -scale;
                t.m03 = p.x + scale * p0.x;
                t.m13 = p.y - scale * p0.y;
                t.m23 = p.z + scale * p0.z;
            } else {
                t.m00 = scale;
                t.m11 = scale;
                t.m22 = scale;
                t.m03 = p.x - scale * p0.x;
                t.m13 = p.y - scale * p0.y;
                t.m23 = p.z - scale * p0.z;
            }
            t.m33 = 1.0;
        }
        return t;
    }

    @Override
    public void addAttributeKeys(List<String> l) {
        super.addAttributeKeys(l);
        l.add("toption");
        l.add("tcenter");
    }

    @Override
    public String getAttribute(String s) {
        String v = super.getAttribute(s);
        if (v != null) {
            return v;
        }
        if (s.equalsIgnoreCase("toption")) {
            if (this.tOption != 0) {
                if (this.tOption == 1) {
                    return "NOROT";
                }
                throw new RuntimeException("Illegal MRectangle transform options: " + this.tOption);
            }
            return null;
        }
        if (s.equalsIgnoreCase("tcenter")) {
            if (this.tCenter != 4) {
                return P_NAMES[this.tCenter];
            }
            return null;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAttribute(String s, String v) {
        if (s.equalsIgnoreCase("toption")) {
            if (v == null || v.equals("ALLOW_ALL")) {
                this.tOption = 0;
                return;
            } else {
                if (!v.equals("NOROT")) throw new RuntimeException("Illegal MRectangle transform options: " + this.tOption);
                this.tOption = 1;
            }
            return;
        } else if (s.equalsIgnoreCase("tcenter")) {
            for (int i = 0; i < P_NAMES.length; ++i) {
                if (!P_NAMES[i].equals(v)) continue;
                this.tCenter = (byte)i;
                return;
            }
            return;
        } else {
            super.setAttribute(s, v);
        }
    }

    @Override
    public double distanceFrom(double x, double y, CTransform3D t) {
        t = this.convertTransform(t, true);
        return super.distanceFrom(x, y, t);
    }

    public void setCorners(MPoint p1, MPoint p2) {
        MPoint[] points = new MPoint[4];
        DPoint3 q1 = p1.getLocation();
        DPoint3 q2 = p2.getLocation();
        double z = (q1.z + q2.z) / 2.0;
        points[0] = new MPoint(p1);
        points[1] = new MPoint(q2.x, q1.y, z);
        points[2] = new MPoint(p2);
        points[3] = new MPoint(q1.x, q2.y, z);
        this.setPoints(points);
    }

    public int getTOption() {
        return this.tOption;
    }

    public void setTOption(int opts) {
        this.tOption = (byte)opts;
    }

    public int getTCenter() {
        return this.tCenter;
    }

    public void setTCenter(int t) {
        this.tCenter = (byte)t;
    }

    @Override
    public Object clone() {
        return new MRectangle(this);
    }

    @Override
    public void removeChild(MObject o) {
    }

    @Override
    public int getPointRefCount() {
        return 8;
    }

    @Override
    public MPoint getPointRef(int i, CTransform3D trot) {
        double z;
        double y;
        double x;
        Cloneable p;
        if (i < 4) {
            p = super.getPointRef(i, trot).getLocation(null);
            x = ((DPoint3)p).x;
            y = ((DPoint3)p).y;
            z = ((DPoint3)p).z;
        } else {
            DPoint3 p1 = super.getPointRef(i & 3, trot).getLocation(null);
            DPoint3 p2 = super.getPointRef(i + 1 & 3, trot).getLocation(null);
            x = (p1.x + p2.x) / 2.0;
            y = (p1.y + p2.y) / 2.0;
            z = (p1.z + p2.z) / 2.0;
        }
        p = new MRectanglePoint(this, i, x, y, z);
        if (this.internalPointAddCount != 0 && this.internalPointPos == i) {
            ((MObject)p).setSelected(true);
        }
        return p;
    }

    public static void fixRectanglePointClones(MObject[] objarr0, MObject[] objarr) {
        for (int i = 0; i < objarr.length; ++i) {
            MObject oi0 = objarr0[i];
            if (!(oi0 instanceof MPolyline)) continue;
            MObject oi = objarr[i];
            for (int j = 0; j < oi0.getPointCount(); ++j) {
                MPoint oij0 = oi0.getPointRef(j, null);
                if (!(oij0 instanceof MRectanglePoint.Sticky)) continue;
                MRectanglePoint.Sticky rpij = (MRectanglePoint.Sticky)oi.getPointRef(j, null);
                int k = MRectangle.findParentRect(oij0, objarr0);
                if (k < 0) continue;
                rpij.setParentRect((MRectangle)objarr[k]);
            }
        }
    }

    @Override
    public void fixClonedPoints(MObject[] objarr0, MObject[] objarr, int i) {
        MObject oi = objarr[i];
        for (int j = 0; j < this.getPointCount(); ++j) {
            MPoint oij0 = this.getPointRef(j, null);
            if (!(oij0 instanceof MRectanglePoint.Sticky)) continue;
            MRectanglePoint.Sticky rpij = (MRectanglePoint.Sticky)oi.getPointRef(j, null);
            int k = MRectangle.findParentRect(oij0, objarr0);
            if (k < 0) continue;
            rpij.setParentRect((MRectangle)objarr[k]);
        }
    }

    private static int findParentRect(MObject o, MObject[] objarr0) {
        for (int k = 0; k < objarr0.length; ++k) {
            MObject ok0 = objarr0[k];
            if (!(ok0 instanceof MRectangle) || !o.isChildOf(ok0)) continue;
            return k;
        }
        return -1;
    }

    public final Shape getClip(CTransform3D t) {
        DPoint3[] p = new DPoint3[4];
        for (int i = 0; i < p.length; ++i) {
            p[i] = t == null ? super.getPointRef(i, t).getLocation() : super.getPointRef(i, t).getLocation(t);
        }
        double ex = p[0].x - p[2].x;
        double ey = p[0].y - p[2].y;
        double er = Math.sqrt(ex * ex + ey * ey);
        p[0].x += (ex /= er);
        p[0].y += (ey /= er);
        p[2].x -= ex;
        p[2].y -= ey;
        ex = p[1].x - p[3].x;
        ey = p[1].y - p[3].y;
        er = Math.sqrt(ex * ex + ey * ey);
        p[1].x += (ex /= er);
        p[1].y += (ey /= er);
        p[3].x -= ex;
        p[3].y -= ey;
        int[] xx = new int[p.length];
        int[] yy = new int[p.length];
        for (int i = 0; i < p.length; ++i) {
            xx[i] = (int)Math.round(p[i].x);
            yy[i] = (int)Math.round(p[i].y);
        }
        if (xx[0] == xx[3] && xx[1] == xx[2] && yy[0] == yy[1] && yy[2] == yy[3]) {
            int xmin = Math.min(xx[0], xx[1]);
            int ymin = Math.min(yy[0], yy[2]);
            int xmax = Math.max(xx[0], xx[1]);
            int ymax = Math.max(yy[0], yy[2]);
            return new Rectangle(xmin, ymin, xmax - xmin + 1, ymax - ymin + 1);
        }
        return new Polygon(xx, yy, xx.length);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(1);
        oos.writeByte(this.internalPointPos);
        oos.writeInt(this.internalPointAddCount);
        oos.writeByte(this.tOption);
        oos.writeByte(this.tCenter);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 1) {
            throw new IOException("Cannot deserialize rectangle object with future version (" + version + ")");
        }
        this.internalPointPos = ois.readByte();
        this.internalPointAddCount = ois.readInt();
        if (version > 0) {
            this.tOption = ois.readByte();
            this.tCenter = ois.readByte();
        }
    }

    static {
        MRectangle.P_NAMES[1] = "NE";
        MRectangle.P_NAMES[0] = "NW";
        MRectangle.P_NAMES[3] = "SW";
        MRectangle.P_NAMES[2] = "SE";
        MRectangle.P_NAMES[4] = "CENTER";
        MRectangle.P_NAMES[5] = "N";
        MRectangle.P_NAMES[6] = "E";
        MRectangle.P_NAMES[7] = "S";
        MRectangle.P_NAMES[8] = "W";
    }
}

