/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.graphics;

import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.graphics.MRectangle;
import chemaxon.struc.graphics.MRoundedRectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MRectanglePoint
extends MPoint {
    private static final long serialVersionUID = -3067277054033050963L;
    protected transient byte positionInRect;
    protected transient MRectangle parentRect;

    protected MRectanglePoint(MRectangle r, int i, double x, double y, double z) {
        super(x, y, z);
        this.positionInRect = (byte)i;
        this.parentRect = r;
    }

    protected MRectanglePoint(MRectanglePoint p) {
        super(p);
        this.positionInRect = p.positionInRect;
        this.parentRect = p.parentRect;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof MRectanglePoint && this.equals((MRectanglePoint)o);
    }

    public boolean equals(MRectanglePoint o) {
        return this.positionInRect == o.positionInRect && this.parentRect == o.parentRect;
    }

    @Override
    public Object clone() {
        return new Sticky(this);
    }

    @Override
    public boolean isSelectableNow() {
        MRectangle r = this.parentRect;
        return r != null && !r.isSelected() && (r.internalPointAddCount == 0 || r.internalPointPos == this.positionInRect);
    }

    @Override
    public boolean isChildOf(MObject o) {
        return this.parentRect == o;
    }

    public int getPositionInRect() {
        return this.positionInRect;
    }

    public MRectangle getParentRect() {
        return this.parentRect;
    }

    void setParentRect(MRectangle r) {
        this.parentRect = r;
    }

    @Override
    public void addNotify() {
        this.parentRect.internalPointPos = this.positionInRect;
        ++this.parentRect.internalPointAddCount;
    }

    @Override
    public void removeNotify() {
        if (--this.parentRect.internalPointAddCount == 0) {
            this.parentRect.internalPointPos = 0;
        }
    }

    @Override
    public void setLocation(DPoint3 p, CTransform3D t) {
        super.setLocation(p, t);
        this.correctOtherCorners(t);
    }

    @Override
    public void transform(CTransform3D t, int opts, CTransform3D trot) {
        super.transform(t, opts, trot);
        if (this.positionInRect > 7) {
            this.correctRoundedCorners(trot);
        } else {
            this.correctOtherCorners(trot);
        }
    }

    @Override
    public String toString() {
        return "MRectanglePoint " + this.positionInRect + " " + this.parentRect;
    }

    private void correctRoundedCorners(CTransform3D trot) {
        MRoundedRectangle r = (MRoundedRectangle)this.parentRect;
        DPoint3 myloc = this.getLocation(trot);
        byte i = this.positionInRect;
        int j = i - 8 & 1;
        int k = j == 0 ? 1 : -1;
        DPoint3 corner = r.getPoint(i & 3).getLocation(null);
        DPoint3 p1 = r.getPoint(i + 1 & 3).getLocation(null);
        DPoint3 p3 = r.getPoint(i + 3 & 3).getLocation(null);
        double omega = corner.angle2D(p1.x, p1.y) - corner.angle2D(p3.x, p3.y);
        double d = 0.1 * r.getThickness();
        double aw = 0.0;
        double ah = 0.0;
        if (omega <= 1.5707963267948966 + d && omega >= 1.5707963267948966 - d || omega <= 4.71238898038469 + d && omega >= 4.71238898038469 - d || omega <= -1.5707963267948966 + d && omega >= -1.5707963267948966 - d) {
            Double alpha = myloc.angle2D(corner.x, corner.y) - p3.angle2D(corner.x, corner.y);
            double dx = myloc.x - corner.x;
            double dy = myloc.y - corner.y;
            aw = Math.hypot(dx, dy) * Math.sin((double)j * Math.PI * 0.5 + (double)k * alpha);
            ah = Math.hypot(dx, dy) * Math.cos((double)j * Math.PI * 0.5 + (double)k * alpha);
        } else {
            Double beta;
            Double alpha;
            if (i == 8 || i == 10) {
                alpha = myloc.angle2D(corner.x, corner.y) - p3.angle2D(corner.x, corner.y);
                beta = -myloc.angle2D(corner.x, corner.y) + p1.angle2D(corner.x, corner.y);
            } else {
                alpha = -myloc.angle2D(corner.x, corner.y) + p1.angle2D(corner.x, corner.y);
                beta = myloc.angle2D(corner.x, corner.y) - p3.angle2D(corner.x, corner.y);
                omega = Math.PI - omega;
            }
            double f = Math.hypot(myloc.x - corner.x, myloc.y - corner.y);
            aw = f * Math.sin(alpha) / Math.sin(omega);
            ah = f * Math.sin(beta) / Math.sin(omega);
        }
        if (aw < 0.0) {
            aw = d;
        }
        if (ah < 0.0) {
            ah = d;
        }
        r.setCornersRadius(aw, ah);
    }

    private void correctOtherCorners(CTransform3D trot) {
        MPoint mq2;
        MPoint mq1;
        DPoint3 q2;
        DPoint3 q1;
        double fy;
        double fx;
        double rf;
        double ey;
        double ex;
        double re;
        double dy;
        double dx;
        MRectangle r = this.parentRect;
        MPoint[] mcorners = new MPoint[4];
        DPoint3[] corners = new DPoint3[4];
        for (int i = 0; i < 4; ++i) {
            mcorners[i] = r.getPoint(i);
            corners[i] = mcorners[i].getLocation(trot);
        }
        DPoint3 myloc = this.getLocation(trot);
        byte i = this.positionInRect;
        if (i < 4) {
            dx = myloc.x - corners[i + 2 & 3].x;
            dy = myloc.y - corners[i + 2 & 3].y;
            if (Math.abs(dx) < 0.1 || Math.abs(dy) < 0.1) {
                return;
            }
        }
        if ((re = Math.sqrt((ex = corners[1].x - corners[0].x) * ex + (ey = corners[1].y - corners[0].y) * ey)) > 0.01) {
            ex /= re;
            ey /= re;
        }
        if ((rf = Math.sqrt((fx = corners[0].x - corners[3].x) * fx + (fy = corners[0].y - corners[3].y) * fy)) > 0.01) {
            fx /= rf;
            fy /= rf;
        }
        if (i < 4) {
            dx = myloc.x - corners[i].x;
            dy = myloc.y - corners[i].y;
            q1 = corners[i + 1 & 3];
            q2 = corners[i + 3 & 3];
            mq1 = mcorners[i + 1 & 3];
            mq2 = mcorners[i + 3 & 3];
            if ((i & 1) == 0) {
                DPoint3 tp = q1;
                q1 = q2;
                q2 = tp;
                MPoint tmp = mq1;
                mq1 = mq2;
                mq2 = tmp;
            }
        } else {
            q1 = corners[i & 3];
            q2 = corners[i + 1 & 3];
            mq1 = mcorners[i & 3];
            mq2 = mcorners[i + 1 & 3];
            dx = myloc.x - (q1.x + q2.x) / 2.0;
            dy = myloc.y - (q1.y + q2.y) / 2.0;
        }
        double e = dx * ex + dy * ey;
        ex *= e;
        ey *= e;
        double f = dx * fx + dy * fy;
        fx *= f;
        fy *= f;
        if (i < 4) {
            mcorners[i].setLocation(myloc, trot);
            mq1.setLocation(new DPoint3(q1.x + ex, q1.y + ey, q1.z), trot);
            mq2.setLocation(new DPoint3(q2.x + fx, q2.y + fy, q2.z), trot);
        } else {
            double gx = ex;
            double gy = ey;
            if ((i & 1) == 0) {
                gx = fx;
                gy = fy;
            }
            mq1.setLocation(new DPoint3(q1.x + gx, q1.y + gy, q1.z), trot);
            mq2.setLocation(new DPoint3(q2.x + gx, q2.y + gy, q2.z), trot);
        }
        r.setPoints(mcorners);
    }

    @Override
    public boolean isTransformable() {
        if (this.parentRect instanceof MBracket && ((MBracket)this.parentRect).getBracketOrientation() == 4 && this.positionInRect > 3) {
            return false;
        }
        return super.isTransformable();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.writeByte(this.positionInRect);
        oos.writeObject(this.parentRect);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize rectangle point object with future version (" + version + ")");
        }
        this.positionInRect = ois.readByte();
        this.parentRect = (MRectangle)ois.readObject();
    }

    public static class Sticky
    extends MRectanglePoint {
        private static final long serialVersionUID = 3364078480306200948L;

        public Sticky(MRectangle r, int pos) {
            super(r, pos, 0.0, 0.0, 0.0);
        }

        protected Sticky(MRectanglePoint p) {
            super(p);
        }

        @Override
        public Object clone() {
            return new Sticky(this);
        }

        @Override
        public void getLocation(DPoint3 q, CTransform3D trot) {
            byte i = this.positionInRect;
            if (i < 4) {
                MPoint p = this.parentRect.getPointRef(i, trot);
                p.getLocation(q, trot);
            } else {
                int i1 = i & 3;
                int i2 = i + 1 & 3;
                DPoint3 p1 = this.parentRect.getPointRef(i1, trot).getLocation(null);
                DPoint3 p2 = this.parentRect.getPointRef(i2, trot).getLocation(null);
                q.x = (p1.x + p2.x) / 2.0;
                q.y = (p1.y + p2.y) / 2.0;
                q.z = (p1.z + p2.z) / 2.0;
                if (trot != null) {
                    trot.transform(q);
                }
            }
        }
    }
}

