/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.graphics;

import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MRectangle;
import chemaxon.struc.graphics.MRectanglePoint;
import java.awt.Color;
import java.awt.Shape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

public class MRoundedRectangle
extends MRectangle {
    private double arcWidth = 0.0;
    private double arcHeight = 0.0;

    public MRoundedRectangle() {
        this(new MPoint(0.0, 0.0, 0.0), new MPoint(0.0, 0.0, 0.0), null);
    }

    public MRoundedRectangle(MPoint p1, MPoint p2) {
        this(p1, p2, null);
    }

    public MRoundedRectangle(MPoint p1, MPoint p2, double aw, double ah) {
        this(p1, p2, aw, ah, null);
    }

    public MRoundedRectangle(MPoint p1, MPoint p2, Color c) {
        super(p1, p2, c, null);
    }

    public MRoundedRectangle(MPoint p1, MPoint p2, double aw, double ah, Color c) {
        super(p1, p2, c, null);
        this.arcWidth = aw;
        this.arcHeight = ah;
    }

    protected MRoundedRectangle(MRoundedRectangle rr) {
        super(rr);
        this.arcWidth = rr.arcWidth;
        this.arcHeight = rr.arcHeight;
    }

    @Override
    public Object clone() {
        return new MRoundedRectangle(this);
    }

    public void setArcWidth(double aw) {
        this.arcWidth = aw;
    }

    public void setArcHeight(double ah) {
        this.arcHeight = ah;
    }

    public double getArcWidth() {
        return this.arcWidth;
    }

    public double getArcHeight() {
        return this.arcHeight;
    }

    public void setCornersRadius(double aw, double ah) {
        this.arcWidth = aw;
        this.arcHeight = ah;
    }

    public void correctCornersRadius(double aw, double ah) {
        this.arcWidth += aw;
        this.arcHeight += ah;
    }

    @Override
    public void addAttributeKeys(List<String> l) {
        super.addAttributeKeys(l);
        l.add("arcWidth");
        l.add("arcHeight");
    }

    @Override
    public String getAttribute(String s) {
        if (s.equalsIgnoreCase("arcWidth")) {
            return this.arcWidth != 0.0 ? String.valueOf(this.arcWidth) : null;
        }
        if (s.equalsIgnoreCase("arcHeight")) {
            return this.arcHeight != 0.0 ? String.valueOf(this.arcHeight) : null;
        }
        return super.getAttribute(s);
    }

    @Override
    public void setAttribute(String s, String v) {
        if (s.equalsIgnoreCase("arcWidth")) {
            this.setArcWidth(Double.valueOf(v));
        } else if (s.equalsIgnoreCase("arcHeight")) {
            this.setArcHeight(Double.valueOf(v));
        } else {
            super.setAttribute(s, v);
        }
    }

    @Override
    public boolean containsPoint(DPoint3 p, CTransform3D trot) {
        Shape sr = this.getClip(trot);
        return sr.contains(p.x, p.y);
    }

    @Override
    public int getPointRefCount() {
        return 12;
    }

    @Override
    public MPoint getPointRef(int i, CTransform3D trot) {
        MPoint p;
        if (i < 8) {
            p = super.getPointRef(i, trot);
        } else {
            p = this.getInnerPointRef(i, trot);
            if (this.internalPointAddCount != 0 && this.internalPointPos == i) {
                p.setSelected(true);
            }
        }
        return p;
    }

    public MPoint getInnerPointRef(int i, CTransform3D trot) {
        double y;
        double x;
        DPoint3 p0 = this.getPointRef(i & 3, trot).getLocation(null);
        DPoint3 p1 = this.getPointRef(i + 1 & 3, trot).getLocation(null);
        DPoint3 p3 = this.getPointRef(i + 3 & 3, trot).getLocation(null);
        double d01 = Math.hypot(p0.x - p1.x, p0.y - p1.y);
        double d03 = Math.hypot(p0.x - p3.x, p0.y - p3.y);
        double arw = this.arcWidth;
        double arh = this.arcHeight;
        double[] beta = new double[2];
        if (i == 8 || i == 10) {
            beta[0] = Math.PI - p0.angle2D(p1.x, p1.y);
            beta[1] = p0.angle2D(p3.x, p3.y);
            if (d03 < 2.0 * arh) {
                arw = d03 / (arh * 2.0) * arw;
                arh = d03 / 2.0;
            }
            if (d01 < 2.0 * arw) {
                arh = d01 / (arw * 2.0) * arh;
                arw = d01 / 2.0;
            }
        } else {
            beta[0] = p0.angle2D(p3.x, p3.y);
            beta[1] = Math.PI - p0.angle2D(p1.x, p1.y);
            if (d03 < 2.0 * arw) {
                arh = d03 / (arw * 2.0) * arh;
                arw = d03 / 2.0;
            }
            if (d01 < 2.0 * arh) {
                arw = d01 / (arh * 2.0) * arw;
                arh = d01 / 2.0;
            }
        }
        double[] m = new double[2];
        double[] n = new double[2];
        double s = arw;
        for (int k = 0; k <= 1; ++k) {
            m[k] = s * Math.cos(beta[k]);
            n[k] = s * Math.sin(beta[k]);
            s = arh;
        }
        if (i == 8 || i == 10) {
            x = p0.x - m[0] + m[1];
            y = p0.y + n[0] + n[1];
        } else {
            x = p0.x + m[0] - m[1];
            y = p0.y + n[0] + n[1];
        }
        double z = p0.z;
        MRectanglePoint p = new MRectanglePoint(this, i, x, y, z);
        if (this.internalPointAddCount != 0 && this.internalPointPos == i) {
            p.setSelected(true);
        }
        return p;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(1);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 1) {
            throw new IOException("Cannot deserialize bracket object with future version (" + version + ")");
        }
        if (version > 0) {
            // empty if block
        }
    }
}

