/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.graphics;

import chemaxon.struc.graphics.MFont;
import java.awt.Color;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.StringTokenizer;

public class MTextAttributes
implements Externalizable {
    private static final long serialVersionUID = 6561552003080652755L;
    public static final MTextAttributes DEFAULT = new MTextAttributes(0, 0, null, null, 1.0, 0.0, 0.0);
    public static final int A_SUBLEVEL = 1;
    public static final int A_FOREGROUND = 2;
    public static final int A_FONT = 4;
    public static final int A_FONTFAMILY = 8;
    public static final int A_FONTSIZE = 16;
    public static final int A_BOLD = 32;
    public static final int A_ITALIC = 64;
    public static final int A_FONT_BITS = 124;
    public static final int A_SCALE = 128;
    public static final int A_DX = 256;
    public static final int A_DY = 512;
    public static final int A_ALL = 1023;
    public static final double DEFAULT_SUPERSCRIPT_SCALE = 0.7;
    public static final double DEFAULT_SUPERSCRIPT_DELTAY = 0.6;
    public static final int DEFAULT_SUPERSCRIPT_SUBLEVEL = 1;
    private int setBits = 0;
    private byte subLevel = 0;
    private Color foregroundColor = null;
    private MFont baseFont = null;
    private double fontScale = 1.0;
    private double deltaX = 0.0;
    private double deltaY = 0.0;

    public MTextAttributes(int set, int subl, Color c, MFont ft, double scale, double dx, double dy) {
        this.setBits = set;
        this.subLevel = (byte)subl;
        this.foregroundColor = c;
        this.baseFont = ft;
        this.fontScale = scale;
        this.deltaX = dx;
        this.deltaY = dy;
    }

    private MTextAttributes(String str, MFont deffnt, MFontCreator fntcreator, MTextAttributes prev) throws IllegalArgumentException {
        if (str.startsWith("{") && str.endsWith("}")) {
            str = str.substring(1, str.length() - 1);
            StringTokenizer st = new StringTokenizer(str, ",");
            this.setBits = prev.getSet();
            this.foregroundColor = prev.getForeground();
            this.subLevel = prev.getSubLevel();
            this.fontScale = prev.getScale();
            this.deltaX = prev.getDx();
            MFont prevfnt = prev.getBaseFont();
            if (prevfnt == null) {
                prevfnt = deffnt;
            }
            String fntname = prevfnt.getFamily();
            int style = prevfnt.getStyle();
            double size = prevfnt.getSizeDouble();
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.startsWith("subL=")) {
                    s = s.substring(5);
                    try {
                        this.subLevel = Byte.parseByte(s);
                        this.setBits |= 1;
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("Cannot read " + s);
                    }
                }
                if (s.startsWith("fg=DEFAULT")) {
                    this.foregroundColor = null;
                    this.setBits &= 0xFFFFFFFD;
                    continue;
                }
                if (s.startsWith("fg=#")) {
                    s = s.substring(4);
                    int rgb = 0;
                    try {
                        rgb = Integer.parseInt(s, 16);
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("Cannot read font size: " + s);
                    }
                    this.foregroundColor = new Color(rgb);
                    this.setBits |= 2;
                    continue;
                }
                if (s.startsWith("font=DEFAULT")) {
                    fntname = null;
                    style = 0;
                    size = 0.0;
                    this.setBits &= 0xFFFFFF83;
                    continue;
                }
                if (s.startsWith("font=")) {
                    fntname = s.substring(5);
                    this.setBits |= 8;
                    continue;
                }
                if (s.equals("bold")) {
                    style |= 1;
                    this.setBits |= 0x20;
                    continue;
                }
                if (s.equals("nobold")) {
                    style &= 0xFFFFFFFE;
                    this.setBits &= 0xFFFFFFDF;
                    continue;
                }
                if (s.equals("italic")) {
                    style |= 2;
                    this.setBits |= 0x40;
                    continue;
                }
                if (s.equals("noitalic")) {
                    style &= 0xFFFFFFFD;
                    this.setBits &= 0xFFFFFFBF;
                    continue;
                }
                if (s.startsWith("size=")) {
                    try {
                        size = Double.valueOf(s.substring(5));
                        this.setBits |= 0x10;
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("Cannot read " + s);
                    }
                }
                if (s.startsWith("scale=")) {
                    try {
                        this.fontScale = Double.valueOf(s.substring(6));
                        this.setBits |= 0x80;
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("Cannot read " + s);
                    }
                }
                if (s.startsWith("dx=")) {
                    s = s.substring(3);
                    try {
                        this.deltaX = Double.valueOf(s);
                        this.setBits |= 0x100;
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("Cannot read " + s);
                    }
                }
                if (!s.startsWith("dy=")) continue;
                s = s.substring(3);
                try {
                    this.deltaY = Double.valueOf(s);
                    this.setBits |= 0x200;
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Cannot read " + s);
                }
            }
            if (fntname != null || style != 0 || size != 0.0) {
                String deffntname = deffnt.getFamily();
                if (fntname == null) {
                    fntname = deffntname;
                }
                if (size == 0.0) {
                    size = deffnt.getSizeDouble();
                }
                this.baseFont = fntcreator.reuseFont(fntname, style, size);
            }
        }
    }

    public int getSet() {
        return this.setBits;
    }

    public MTextAttributes decode(String str, MFont deffnt, MFontCreator fntcreator) throws IllegalArgumentException {
        return new MTextAttributes(str, deffnt, fntcreator, this);
    }

    public byte getSubLevel() {
        return this.subLevel;
    }

    public Color getForeground() {
        return this.foregroundColor;
    }

    public MFont getBaseFont() {
        return this.baseFont;
    }

    public String getFontFamily() {
        if ((this.setBits & 0xC) != 0 && this.baseFont != null) {
            return this.baseFont.getFamily();
        }
        return null;
    }

    public double getScale() {
        return this.fontScale;
    }

    public double getDx() {
        return this.deltaX;
    }

    public double getDy() {
        return this.deltaY;
    }

    public boolean isDefault() {
        return this.subLevel == 0 && this.foregroundColor == null && this.baseFont == null && this.deltaX == 0.0 && this.deltaY == 0.0;
    }

    public boolean isFontDefault(MFont deffnt) {
        return this.baseFont == null || MTextAttributes.equals(this.baseFont, deffnt);
    }

    public boolean isFontRegular() {
        return this.baseFont == null || this.baseFont.getStyle() == 0;
    }

    public String toString() {
        return this.encode(null, null);
    }

    public String encode(MFont deffnt, MTextAttributes prev) {
        Color fg = this.getForeground();
        MFont font = this.getBaseFont();
        boolean attrwritten = false;
        StringBuffer sb = new StringBuffer("{");
        byte prevsubl = 0;
        Color prevfg = null;
        MFont prevfnt = null;
        double prevscale = 1.0;
        double prevdx = 0.0;
        if (prev != null) {
            prevsubl = prev.getSubLevel();
            prevfg = prev.getForeground();
            prevfnt = prev.getBaseFont();
            prevscale = prev.getScale();
            prevdx = prev.getDx();
        }
        if (this.getSubLevel() != prevsubl) {
            if (attrwritten) {
                sb.append(",");
            }
            sb.append("subL=" + this.getSubLevel());
            attrwritten = true;
        }
        if (!MTextAttributes.equals(fg, prevfg)) {
            if (attrwritten) {
                sb.append(",");
            }
            if (fg == null) {
                sb.append("fg=DEFAULT");
            } else {
                sb.append("fg=#");
                int rgb = fg.getRGB();
                String s = Integer.toString(rgb & 0xFFFFFF, 16);
                s = "00000" + s;
                sb.append(s.substring(s.length() - 6, s.length()));
            }
            attrwritten = true;
        }
        if (!MTextAttributes.equals(font, prevfnt)) {
            if (font == null) {
                if (attrwritten) {
                    sb.append(",");
                }
                sb.append("font=DEFAULT");
                attrwritten = true;
            } else {
                double size;
                int style;
                String prevname = null;
                int prevstyle = 0;
                double prevsize = 0.0;
                if (prevfnt != null) {
                    prevname = prevfnt.getFamily();
                    prevstyle = prevfnt.getStyle();
                    prevsize = prevfnt.getSizeDouble();
                } else if (deffnt != null) {
                    prevname = deffnt.getFamily();
                    prevstyle = deffnt.getStyle();
                    prevsize = deffnt.getSizeDouble();
                }
                String name = font.getFamily();
                if (!MTextAttributes.equals(name, prevname)) {
                    if (attrwritten) {
                        sb.append(",");
                    }
                    sb.append("font=");
                    sb.append(font.getFamily());
                    attrwritten = true;
                }
                if ((((style = font.getStyle()) ^ prevstyle) & 1) != 0) {
                    if (attrwritten) {
                        sb.append(",");
                    }
                    sb.append((style & 1) != 0 ? "bold" : "nobold");
                    attrwritten = true;
                }
                if (((style ^ prevstyle) & 2) != 0) {
                    if (attrwritten) {
                        sb.append(",");
                    }
                    sb.append((style & 2) != 0 ? "italic" : "noitalic");
                    attrwritten = true;
                }
                if ((size = font.getSizeDouble()) != prevsize) {
                    if (attrwritten) {
                        sb.append(",");
                    }
                    sb.append("size=");
                    sb.append(MFont.sizeToString(size));
                    attrwritten = true;
                }
            }
        }
        if (this.getScale() != prevscale) {
            if (attrwritten) {
                sb.append(",");
            }
            sb.append("scale=" + this.getScale());
            attrwritten = true;
        }
        if (this.getDx() != prevdx) {
            if (attrwritten) {
                sb.append(",");
            }
            sb.append("dx=" + this.getDx());
            attrwritten = true;
        }
        if (this.getDy() != 0.0) {
            if (attrwritten) {
                sb.append(",");
            }
            sb.append("dy=" + this.getDy());
            attrwritten = true;
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equalsNext(MTextAttributes o) {
        boolean fontseq = MTextAttributes.equals(this.baseFont, o.baseFont);
        if (!fontseq) {
            if (this.baseFont == null && o.baseFont != null) {
                fontseq = (o.setBits & 0x7C) == 0;
            } else if (this.baseFont != null && o.baseFont == null) {
                fontseq = (this.setBits & 0x7C) == 0;
            }
        }
        return this.subLevel == o.subLevel && MTextAttributes.equals(this.foregroundColor, o.foregroundColor) && fontseq && this.fontScale == o.fontScale && this.deltaX == o.deltaX && o.deltaY == 0.0;
    }

    public boolean equals(MTextAttributes o) {
        return o == this || o != null && this.subLevel == o.subLevel && MTextAttributes.equals(this.foregroundColor, o.foregroundColor) && MTextAttributes.equals(this.baseFont, o.baseFont) && this.fontScale == o.fontScale && this.deltaX == o.deltaX && this.deltaY == o.deltaY;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MTextAttributes) {
            return this.equals((MTextAttributes)o);
        }
        return false;
    }

    public boolean isCompatible(MTextAttributes newCommon, MTextAttributes origCommon, MFont deffnt) {
        boolean v;
        int f = newCommon.getSet();
        if ((f & 1) != 0 && (origCommon == null ? this.subLevel != newCommon.subLevel : newCommon.subLevel != origCommon.subLevel)) {
            return false;
        }
        if ((f & 2) != 0 && !MTextAttributes.equals(this.foregroundColor, newCommon.foregroundColor)) {
            return false;
        }
        if ((f & 4) != 0 && !MTextAttributes.equals(this.baseFont, newCommon.baseFont)) {
            return false;
        }
        if ((f & 8) != 0 && (this.baseFont == null ? newCommon.baseFont != null && !MTextAttributes.haveEqualType(newCommon.baseFont, deffnt) : (newCommon.baseFont != null ? !MTextAttributes.haveEqualType(this.baseFont, newCommon.baseFont) : !MTextAttributes.haveEqualType(this.baseFont, deffnt)))) {
            return false;
        }
        if ((f & 0x10) != 0) {
            MFont ofont;
            MFont mFont = ofont = newCommon.baseFont != null ? newCommon.baseFont : deffnt;
            if (this.baseFont == null && !MTextAttributes.haveEqualSize(ofont, deffnt) || this.baseFont != null && !MTextAttributes.haveEqualSize(this.baseFont, ofont)) {
                return false;
            }
        }
        if ((f & 0x20) != 0) {
            int ostyle = newCommon.baseFont != null ? newCommon.baseFont.getStyle() : 0;
            boolean bl = v = (ostyle & 1) != 0;
            if (this.baseFont == null && v || this.baseFont != null && this.baseFont.isBold() != v) {
                return false;
            }
        }
        if ((f & 0x40) != 0) {
            int ostyle = newCommon.baseFont != null ? newCommon.baseFont.getStyle() : 0;
            boolean bl = v = (ostyle & 2) != 0;
            if (this.baseFont == null && v || this.baseFont != null && this.baseFont.isItalic() != v) {
                return false;
            }
        }
        if ((f & 0x80) != 0 && this.fontScale != newCommon.fontScale) {
            return false;
        }
        if ((f & 0x100) != 0 && this.deltaX != newCommon.deltaX) {
            return false;
        }
        return (f & 0x200) == 0 || this.deltaY == newCommon.deltaY;
    }

    public MTextAttributes getCompatibleAttributes(MTextAttributes attr, MFont deffnt, MFontCreator ftcreator, int set0) {
        byte csubl = 0;
        Color cfg = null;
        MFont cfont = null;
        double cscale = 0.0;
        double cdx = 0.0;
        double cdy = 0.0;
        int f = attr.getSet() | set0;
        if (this.subLevel == attr.subLevel) {
            csubl = this.subLevel;
        } else {
            csubl = Math.abs(this.subLevel) < Math.abs(attr.subLevel) ? this.subLevel : attr.subLevel;
            f &= 0xFFFFFFFE;
        }
        if ((f & 2) != 0) {
            if (MTextAttributes.equals(this.foregroundColor, attr.foregroundColor)) {
                cfg = this.foregroundColor;
            } else {
                f &= 0xFFFFFFFD;
            }
        }
        if ((f & 4) != 0) {
            if (MTextAttributes.equals(this.baseFont, attr.baseFont)) {
                cfont = this.baseFont;
            } else {
                f &= 0xFFFFFFFB;
            }
        }
        if ((f & 8) != 0) {
            if (this.baseFont == null) {
                if (attr.baseFont != null && !MTextAttributes.haveEqualType(attr.baseFont, deffnt)) {
                    f &= 0xFFFFFFF3;
                }
            } else if (attr.baseFont == null && !MTextAttributes.haveEqualType(this.baseFont, deffnt)) {
                f &= 0xFFFFFFF3;
            } else if (attr.baseFont != null && MTextAttributes.haveEqualType(this.baseFont, attr.baseFont)) {
                cfont = this.baseFont;
            } else {
                f &= 0xFFFFFFF3;
            }
        }
        if ((f & 0x10) != 0) {
            if (this.baseFont == null) {
                if (attr.baseFont != null && !MTextAttributes.haveEqualSize(attr.baseFont, deffnt)) {
                    f &= 0xFFFFFFEB;
                }
            } else if (attr.baseFont == null && !MTextAttributes.haveEqualSize(this.baseFont, deffnt)) {
                f &= 0xFFFFFFEB;
            } else if (attr.baseFont != null && MTextAttributes.haveEqualSize(this.baseFont, attr.baseFont)) {
                cfont = this.baseFont;
            } else {
                f &= 0xFFFFFFEB;
            }
        }
        if ((f & 0x20) != 0) {
            if (this.baseFont == null) {
                if (attr.baseFont != null && attr.baseFont.isBold()) {
                    f &= 0xFFFFFFDB;
                }
            } else if (attr.baseFont != null && this.baseFont.isBold() != attr.baseFont.isBold()) {
                f &= 0xFFFFFFDB;
            } else if (attr.baseFont != null && this.baseFont.isBold() == attr.baseFont.isBold()) {
                cfont = this.baseFont;
            } else {
                f &= 0xFFFFFFDB;
            }
        }
        if ((f & 0x40) != 0) {
            if (this.baseFont == null) {
                if (attr.baseFont != null && attr.baseFont.isItalic()) {
                    f &= 0xFFFFFFBB;
                }
            } else if (attr.baseFont != null && this.baseFont.isItalic() != attr.baseFont.isItalic()) {
                f &= 0xFFFFFFBB;
            } else if (attr.baseFont != null && this.baseFont.isItalic() == attr.baseFont.isItalic()) {
                cfont = this.baseFont;
            } else {
                f &= 0xFFFFFFBB;
            }
        }
        if (this.fontScale == attr.fontScale) {
            cscale = this.fontScale;
        } else {
            cscale = this.fontScale > attr.fontScale ? this.fontScale : attr.fontScale;
            f &= 0xFFFFFF7F;
        }
        if ((f & 0x100) != 0) {
            if (this.deltaX == attr.deltaX) {
                cdx = this.deltaX;
            } else {
                f &= 0xFFFFFEFF;
            }
        }
        if ((f & 0x200) != 0) {
            if (this.deltaY == attr.deltaY) {
                cdy = this.deltaY;
            } else {
                f &= 0xFFFFFDFF;
            }
        }
        if ((f & 4) == 0 && cfont != null) {
            String name = deffnt.getFamily();
            double size = deffnt.getSizeDouble();
            int style = 0;
            if ((f & 8) != 0) {
                name = cfont.getFamily();
            }
            if ((f & 0x10) != 0) {
                size = cfont.getSizeDouble();
            }
            if ((f & 0x20) != 0 && cfont.isBold()) {
                style |= 1;
            }
            if ((f & 0x40) != 0 && cfont.isItalic()) {
                style |= 2;
            }
            if ((cfont = ftcreator.reuseFont(name, style, size)).equals(deffnt)) {
                cfont = null;
            }
        }
        if (csubl == 0 && cfg == null && cfont == null && cscale == 1.0 && cdx == 0.0 && cdy == 0.0 && f == 0) {
            return DEFAULT;
        }
        if (csubl == this.subLevel && MTextAttributes.equals(cfg, this.foregroundColor) && MTextAttributes.equals(cfont, this.baseFont) && cscale == this.fontScale && cdx == this.deltaX && cdy == this.deltaY && f == this.getSet()) {
            return this;
        }
        return new MTextAttributes(f, csubl, cfg, cfont, cscale, cdx, cdy);
    }

    public MTextAttributes createCompatible(MTextAttributes newCommon, MTextAttributes origCommon, MFont deffnt, MFontCreator ftcreator) {
        int newCommonFtstyle;
        int newSubl = this.subLevel;
        Color newFg = this.foregroundColor;
        MFont newFont = this.baseFont;
        String newFontName = null;
        double newFontSize = 0.0;
        int newFontStyle = 0;
        if (this.baseFont != null) {
            newFontName = this.baseFont.getFamily();
            newFontSize = this.baseFont.getSizeDouble();
            newFontStyle = this.baseFont.getStyle();
        }
        double newScale = this.fontScale;
        double newDx = this.deltaX;
        double newDy = this.deltaY;
        int commonSet = newCommon.getSet();
        int newSet = this.getSet() | commonSet;
        if ((commonSet & 1) != 0) {
            if (origCommon == null) {
                newSubl = newCommon.subLevel;
            } else {
                int shift = Math.abs(this.subLevel) - Math.abs(origCommon.subLevel);
                newSubl = newCommon.subLevel > 0 ? Math.max(newCommon.subLevel + shift, 0) : -Math.max(-newCommon.subLevel + shift, 0);
            }
        }
        if ((commonSet & 2) != 0 && (newFg = newCommon.foregroundColor) == null) {
            newSet &= 0xFFFFFFFD;
        }
        if ((commonSet & 4) != 0 && (newFont = newCommon.baseFont) == null) {
            newSet &= 0xFFFFFFFB;
        }
        if ((commonSet & 8) != 0) {
            newFont = null;
            String string = newFontName = newCommon.baseFont != null ? newCommon.baseFont.getFamily() : deffnt.getFamily();
        }
        if ((commonSet & 0x10) != 0) {
            newFont = null;
            MFont ft = newCommon.baseFont;
            newFontSize = (ft != null ? ft : deffnt).getSizeDouble();
        }
        int n = newCommonFtstyle = newCommon.baseFont != null ? newCommon.baseFont.getStyle() : 0;
        if ((commonSet & 0x20) != 0) {
            newFont = null;
            newFontStyle &= 0xFFFFFFFE;
            newFontStyle |= newCommonFtstyle & 1;
        }
        if ((commonSet & 0x40) != 0) {
            newFont = null;
            newFontStyle &= 0xFFFFFFFD;
            newFontStyle |= newCommonFtstyle & 2;
        }
        if (newFont == null && (commonSet & 0x78) != 0) {
            if (newFontName == null && newFontSize == 0.0 && newFontStyle == 0) {
                newFont = null;
            } else {
                if (newFontName == null) {
                    newFontName = deffnt.getFamily();
                }
                if (newFontSize == 0.0) {
                    newFontSize = deffnt.getSizeDouble();
                }
                newFont = ftcreator.reuseFont(newFontName, newFontStyle, newFontSize);
            }
        }
        if ((commonSet & 0x80) != 0 && (newScale = newCommon.fontScale) == 0.0) {
            newSet &= 0xFFFFFF7F;
        }
        if ((commonSet & 0x100) != 0) {
            newDx = newCommon.deltaX;
        }
        if ((commonSet & 0x200) != 0) {
            newDy = newCommon.deltaY;
        }
        if (newSet == this.getSet() && newSubl == this.subLevel && MTextAttributes.equals(newFg, this.foregroundColor) && MTextAttributes.equals(newFont, this.baseFont) && newScale == this.fontScale && newDx == this.deltaX && newDy == this.deltaY) {
            return this;
        }
        return new MTextAttributes(newSet, newSubl, newFg, newFont, newScale, newDx, newDy);
    }

    public MTextAttributes createNext() {
        if (this.deltaY == 0.0 && (this.getSet() & 0x200) == 0) {
            return this;
        }
        return new MTextAttributes(this.getSet() & 0xFFFFFDFF, this.subLevel, this.foregroundColor, this.baseFont, this.fontScale, this.deltaX, 0.0);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize MTextAttributes with future version (" + version + ")");
        }
        this.subLevel = in.readByte();
        byte f = in.readByte();
        if ((f & 1) != 0) {
            int rgb = in.readInt();
            this.foregroundColor = new Color(rgb);
        } else {
            this.foregroundColor = null;
        }
        if ((f & 2) != 0) {
            String name = (String)in.readObject();
            double sz = in.readDouble();
            int bold = (f & 4) != 0 ? 1 : 0;
            int italic = (f & 8) != 0 ? 2 : 0;
            this.baseFont = new MFont(name, bold | italic, sz);
        } else {
            this.baseFont = null;
        }
        double d = this.fontScale = (f & 0x10) != 0 ? in.readDouble() : 1.0;
        if ((f & 0x20) != 0) {
            this.deltaX = in.readDouble();
            this.deltaY = in.readDouble();
        } else {
            this.deltaX = 0.0;
            this.deltaY = 0.0;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int f;
        out.writeByte(0);
        out.writeShort(this.subLevel);
        int n = f = this.foregroundColor != null ? 1 : 0;
        if (this.baseFont != null) {
            f = (byte)(f | 2);
            if (this.baseFont.isBold()) {
                f = (byte)(f | 4);
            }
            if (this.baseFont.isItalic()) {
                f = (byte)(f | 8);
            }
        }
        if (this.fontScale != 1.0) {
            f = (byte)(f | 0x10);
        }
        if (this.deltaX != 0.0 || this.deltaY != 0.0) {
            f = (byte)(f | 0x20);
        }
        out.writeByte(f);
        if ((f & 1) != 0) {
            out.writeInt(this.foregroundColor.getRGB());
        }
        if ((f & 2) != 0) {
            out.writeObject(this.baseFont.getFamily());
            out.writeDouble(this.baseFont.getSizeDouble());
        }
        if ((f & 0x10) != 0) {
            out.writeDouble(this.fontScale);
        }
        if ((f & 0x20) != 0) {
            out.writeDouble(this.deltaX);
            out.writeDouble(this.deltaY);
        }
    }

    private static boolean haveEqualType(MFont ft, MFont o) {
        return ft.getFamily().equals(o.getFamily());
    }

    private static boolean haveEqualSize(MFont ft, MFont o) {
        return ft.getSizeDouble() == o.getSizeDouble();
    }

    private static boolean equals(Object a, Object b) {
        return a == null && b == null || a != null && b != null && a.equals(b);
    }

    static interface MFontCreator {
        public MFont reuseFont(String var1, int var2, double var3);
    }
}

