/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.graphics;

import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MFont;
import chemaxon.struc.graphics.MRectangle;
import chemaxon.struc.graphics.MTextAttributes;
import chemaxon.struc.graphics.MTextBoxModule;
import chemaxon.struc.graphics.MTextDocument;
import java.awt.Color;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ActionMap;

public class MTextBox
extends MRectangle {
    private static final long serialVersionUID = -7272723232157967384L;
    public static final int FONT_DEFAULT_SCALE = 10;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_BOTTOM = 2;
    private transient MTextDocument text;
    private transient double fontScale;
    private transient int horizontalAlignment;
    private transient int verticalAlignment;
    transient int cursorRow;
    transient int cursorColumn;
    transient int cursorPosition;
    private transient MTextAttributes textAttributesAtCursor;
    private transient int selectionStartPosition;
    private transient int selectionEndPosition;
    private transient List<MTextDocument.Portion> wrappedLines;
    private transient int selectionStartRow;
    private transient int selectionStartColumn;
    private transient int selectionEndRow;
    private transient int selectionEndColumn;
    transient double currentHeight;
    transient double currentWidth;
    transient FontMetrics currentDefaultFontMetrics;
    transient boolean autoHeight;
    private transient double minimumHeight;
    private transient boolean minimumHeightSet;
    private transient boolean autoSize;
    private ActionMap actionMap = null;

    public MTextBox() {
        this.text = new MTextDocument();
        this.fontScale = 10.0;
        this.horizontalAlignment = 0;
        this.verticalAlignment = 0;
        this.cursorPosition = 0;
        this.cursorRow = 0;
        this.cursorColumn = 0;
        this.selectionStartPosition = 0;
        this.selectionStartRow = 0;
        this.selectionStartColumn = 0;
        this.selectionEndPosition = 0;
        this.selectionEndRow = 0;
        this.selectionEndColumn = 0;
        this.wrappedLines = new ArrayList<MTextDocument.Portion>();
    }

    protected MTextBox(MTextBox t) {
        super(t);
        this.text = new MTextDocument(t.text);
        this.autoSize = t.autoSize;
        this.fontScale = t.fontScale;
        this.horizontalAlignment = t.horizontalAlignment;
        this.verticalAlignment = t.verticalAlignment;
        this.cursorRow = t.cursorRow;
        this.cursorColumn = t.cursorColumn;
        this.setCursorPos0(t.cursorPosition);
        this.selectionStartPosition = t.selectionStartPosition;
        this.selectionStartRow = t.selectionStartRow;
        this.selectionStartColumn = t.selectionStartColumn;
        this.selectionEndPosition = t.selectionEndPosition;
        this.selectionEndRow = t.selectionEndRow;
        this.selectionEndColumn = t.selectionEndColumn;
        this.wrappedLines = new ArrayList<MTextDocument.Portion>(t.wrappedLines.size());
        this.wrappedLines.addAll(t.wrappedLines);
    }

    @Override
    public Object clone() {
        return new MTextBox(this);
    }

    public ActionMap getActionMap() {
        return this.actionMap;
    }

    public void setActionMap(ActionMap map) {
        this.actionMap = map;
    }

    public MTextDocument getTextDocument() {
        return this.text;
    }

    public String getText() {
        return this.text.getPlainText();
    }

    public void setText(String s) {
        this.text.setPlainText(s);
    }

    public boolean isEditable() {
        return true;
    }

    public final MFont getBaseFont() {
        return this.text.getDefaultFont();
    }

    public final String getBaseFontFamily() {
        return this.getBaseFont().getFamily();
    }

    public final void setBaseFontFamily(String name) {
        MFont f = this.text.getDefaultFont();
        this.text.setDefaultFont(new MFont(name, f.getStyle(), f.getSizeDouble()));
    }

    public final int getBaseFontStyle() {
        return this.getBaseFont().getStyle();
    }

    public final void setBaseFontStyle(int style) {
        MFont f = this.text.getDefaultFont();
        this.text.setDefaultFont(new MFont(f.getFamily(), style, f.getSizeDouble()));
    }

    public final double getFontScale() {
        return this.fontScale;
    }

    public final void setFontScale(double scale) {
        this.fontScale = scale;
    }

    public final int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public final void setHorizontalAlignment(int align) {
        this.horizontalAlignment = align;
    }

    public final int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public final void setVerticalAlignment(int align) {
        this.verticalAlignment = align;
    }

    public int getLineCount() {
        return this.wrappedLines.size();
    }

    public MTextDocument.Portion getLine(int i) {
        return this.wrappedLines.get(i);
    }

    public void clearLines() {
        this.wrappedLines.clear();
    }

    int getLinePosition(int i) {
        return this.getLine(i).getStartPos();
    }

    public void setAutoSize(boolean v) {
        this.autoSize = v;
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    @Override
    public boolean isEmpty() {
        return this.text.getPlainText().length() == 0;
    }

    public boolean hasRichText() {
        return this.text.getSectionCount() != 1 || !this.text.getSection(0).getAttributes().isDefault();
    }

    @Override
    public void addAttributeKeys(List<String> l) {
        super.addAttributeKeys(l);
        l.add("fontScale");
        l.add("halign");
        l.add("valign");
        l.add("autoSize");
    }

    @Override
    public void addCdataAttributeKeys(List<String> l) {
        l.add("text");
    }

    @Override
    public String getAttribute(String s) {
        String v = super.getAttribute(s);
        if (v != null) {
            return v;
        }
        if (s.equalsIgnoreCase("text")) {
            return this.text.toString();
        }
        if (s.equalsIgnoreCase("fontScale")) {
            return String.valueOf(this.fontScale);
        }
        if (s.equalsIgnoreCase("halign")) {
            int a = this.horizontalAlignment;
            return a == 2 ? "RIGHT" : (a == 1 ? "CENTER" : "LEFT");
        }
        if (s.equalsIgnoreCase("valign")) {
            int a = this.verticalAlignment;
            return a == 2 ? "BOTTOM" : (a == 1 ? "CENTER" : "TOP");
        }
        if (s.equalsIgnoreCase("autoSize")) {
            return String.valueOf(this.autoSize);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAttribute(String s, String v) {
        if (s.equalsIgnoreCase("text")) {
            this.text.readFromString(v);
            return;
        } else if (s.equalsIgnoreCase("fontScale")) {
            this.fontScale = Double.valueOf(v);
            return;
        } else if (s.equalsIgnoreCase("halign")) {
            if (v.equalsIgnoreCase("RIGHT")) {
                this.horizontalAlignment = 2;
                return;
            } else if (v.equalsIgnoreCase("CENTER")) {
                this.horizontalAlignment = 1;
                return;
            } else {
                if (!v.equalsIgnoreCase("LEFT")) throw new IllegalArgumentException("invalid horizontal alignment " + v);
                this.horizontalAlignment = 0;
            }
            return;
        } else if (s.equalsIgnoreCase("valign")) {
            if (v.equalsIgnoreCase("BOTTOM")) {
                this.verticalAlignment = 2;
                return;
            } else if (v.equalsIgnoreCase("CENTER")) {
                this.verticalAlignment = 1;
                return;
            } else {
                if (!v.equalsIgnoreCase("TOP")) throw new IllegalArgumentException("invalid vertical alignment " + v);
                this.verticalAlignment = 0;
            }
            return;
        } else if (s.equalsIgnoreCase("autoSize")) {
            this.autoSize = Boolean.valueOf(v);
            return;
        } else {
            super.setAttribute(s, v);
        }
    }

    public boolean hasSelection() {
        return this.selectionEndPosition != this.selectionStartPosition;
    }

    public String getSelectedString() {
        if (this.hasSelection()) {
            return this.text.substring(this.getSelectionStartPos(), this.getSelectionEndPos());
        }
        return null;
    }

    public void deleteCharBackward() {
        MTextBoxModule.deleteCharBackwards(this);
    }

    public void deleteChar() {
        MTextBoxModule.deleteChar(this);
    }

    public void addChar(char c) {
        this.addString(String.valueOf(c));
    }

    public void addString(String s) {
        MTextBoxModule.addString(this, s);
        if (this.textAttributesAtCursor != null) {
            this.textAttributesAtCursor = this.textAttributesAtCursor.createNext();
        }
    }

    public int getCursorPos() {
        return this.cursorPosition;
    }

    public void setCursorPos(int i, boolean select) {
        if (select) {
            if (!this.hasSelection()) {
                this.selectionStartPosition = this.cursorPosition;
            }
            this.selectionEndPosition = i;
        } else {
            this.unselectContents();
        }
        this.setCursorPos0(i);
    }

    public final int getPreviousNormalTextSectionIndex() {
        MTextAttributes attr;
        int k0 = -1;
        int subl = 0;
        if (this.hasSelection()) {
            int selstart = this.getSelectionStartPos();
            int selend = this.getSelectionEndPos();
            if (selstart > 0) {
                attr = this.text.getAttributes(selstart, selend - selstart, 0);
                k0 = this.text.getSectionIndexOfCharAt(selstart - 1);
                subl = attr.getSubLevel();
            }
        } else if (this.cursorPosition > 0) {
            k0 = this.text.getSectionIndexOfCharAt(this.cursorPosition - 1);
            MTextAttributes attr2 = this.textAttributesAtCursor;
            if (attr2 == null) {
                attr2 = this.text.getSection(k0).getAttributes();
            }
            subl = attr2.getSubLevel();
        }
        int abssubl = Math.abs(subl);
        for (int k = k0; k >= 0; --k) {
            attr = this.text.getSection(k).getAttributes();
            if (Math.abs(attr.getSubLevel()) >= abssubl) continue;
            return k;
        }
        return -1;
    }

    public final int getCurrentSubLevel() {
        MTextAttributes attr = this.getCurrentTextAttributes(0);
        if (this.hasSelection()) {
            int selstart = this.getSelectionStartPos();
            int k = this.text.getSectionIndexOfCharAt(selstart);
            MTextDocument.Section sec = this.text.getSection(k);
            return sec.getAttributes().getSubLevel();
        }
        if (attr != null && (attr.getSet() & 1) != 0) {
            return attr.getSubLevel();
        }
        return 0;
    }

    public final int getCurrentScriptCount(int subl) {
        return this.text.getScriptCount(this.getCursorPos(), subl);
    }

    public final MTextAttributes getCurrentTextAttributes(int set0) {
        if (this.hasSelection()) {
            int selstart = this.getSelectionStartPos();
            int selend = this.getSelectionEndPos();
            MTextAttributes attr = this.text.getAttributes(selstart, selend - selstart, set0);
            return attr;
        }
        MTextAttributes attr = this.textAttributesAtCursor;
        if (set0 != 0 && attr != null) {
            attr = attr.getCompatibleAttributes(attr, this.text.getDefaultFont(), this.text, set0);
        }
        return attr;
    }

    public final MTextAttributes getTextAttributesAtCursor() {
        return this.textAttributesAtCursor;
    }

    public void setCurrentTextAttributes(MTextAttributes attr) {
        if (this.hasSelection()) {
            int selstart = this.getSelectionStartPos();
            int selend = this.getSelectionEndPos();
            this.text.setAttributes(selstart, selend - selstart, attr);
        } else {
            MTextAttributes orig = this.textAttributesAtCursor;
            this.textAttributesAtCursor = orig == null ? attr : orig.createCompatible(attr, null, this.text.getDefaultFont(), this.text);
        }
    }

    public final boolean isCurrentFontDefault() {
        if (this.hasSelection()) {
            int selstart = this.getSelectionStartPos();
            int selend = this.getSelectionEndPos();
            return this.text.isFontDefaultInRange(selstart, selend - selstart);
        }
        MTextAttributes attr = this.textAttributesAtCursor;
        return attr == null || attr.isFontDefault(this.text.getDefaultFont());
    }

    public final boolean isCurrentFontRegular() {
        if (this.hasSelection()) {
            int selstart = this.getSelectionStartPos();
            int selend = this.getSelectionEndPos();
            return this.text.isFontRegularInRange(selstart, selend - selstart);
        }
        MTextAttributes attr = this.textAttributesAtCursor;
        return attr == null || attr.isFontRegular();
    }

    public final Color getCurrentForeground() {
        if (this.hasSelection()) {
            int selend;
            int selstart = this.getSelectionStartPos();
            MTextAttributes attr = this.text.getAttributes(selstart, (selend = this.getSelectionEndPos()) - selstart, 0);
            if (attr != null && (attr.getSet() & 2) != 0) {
                return attr.getForeground();
            }
        } else {
            MTextAttributes attr = this.textAttributesAtCursor;
            if (attr != null) {
                return attr.getForeground();
            }
        }
        return null;
    }

    public final void setCurrentForeground(Color c) {
        MTextAttributes attr = this.getCurrentTextAttributes(0);
        if (attr != null) {
            double dy = this.hasSelection() ? attr.getDy() : 0.0;
            attr = new MTextAttributes(2, attr.getSubLevel(), c, attr.getBaseFont(), attr.getScale(), attr.getDx(), dy);
        } else {
            attr = new MTextAttributes(2, 0, c, null, 1.0, 0.0, 0.0);
        }
        this.setCurrentTextAttributes(attr);
    }

    public final void setCurrentFont(MFont ft, int setflags) {
        MTextAttributes attr = this.getCurrentTextAttributes(0);
        if (attr != null) {
            double dy = this.hasSelection() ? attr.getDy() : 0.0;
            attr = new MTextAttributes(setflags, attr.getSubLevel(), attr.getForeground(), ft, attr.getScale(), attr.getDx(), dy);
        } else {
            attr = new MTextAttributes(setflags, 0, null, ft, 1.0, 0.0, 0.0);
        }
        this.setCurrentTextAttributes(attr);
    }

    void setCursorPos0(int i) {
        int oldi = this.cursorPosition;
        this.cursorPosition = i;
        if (i >= 0 && i < this.text.length()) {
            int k = this.text.getSectionIndexOfCharAt(i);
            MTextDocument.Section sec = this.text.getSection(k);
            if (sec.getPosition() == i && k > 0) {
                sec = this.text.getSection(--k);
            }
            MTextAttributes attr = sec.getAttributes();
            if (sec.getPosition() < i) {
                attr = attr.createNext();
            }
            this.textAttributesAtCursor = attr;
        } else if (i == this.text.length() && this.text.length() != 0) {
            MTextDocument.Section sec = this.text.getSection(this.text.getSectionCount() - 1);
            MTextAttributes attr = sec.getAttributes();
            if (sec.getPosition() < i) {
                attr = attr.createNext();
            }
            this.textAttributesAtCursor = attr;
        } else {
            this.textAttributesAtCursor = null;
        }
    }

    public void cursorUp(boolean select) {
        MTextBoxModule.cursorUp(this, select);
    }

    public void cursorDown(boolean select) {
        MTextBoxModule.cursorDown(this, select);
    }

    public void cursorToRowStart(boolean select) {
        MTextBoxModule.cursowToRowStart(this, select);
    }

    public void cursorToRowEnd(boolean select) {
        MTextBoxModule.cursowToRowEnd(this, select);
    }

    public int getSelectionStartPos() {
        return this.selectionStartPosition < this.selectionEndPosition ? this.selectionStartPosition : this.selectionEndPosition;
    }

    public int getSelectionEndPos() {
        return this.selectionStartPosition < this.selectionEndPosition ? this.selectionEndPosition : this.selectionStartPosition;
    }

    public int getSelectionStartRow() {
        return this.selectionStartRow;
    }

    public int getSelectionEndRow() {
        return this.selectionEndRow;
    }

    public int getSelectionStartColumn() {
        return this.selectionStartColumn;
    }

    public int getSelectionEndColumn() {
        return this.selectionEndColumn;
    }

    public void setCursorRow(int i) {
        this.cursorRow = i;
    }

    public int getCursorRow() {
        return this.cursorRow;
    }

    public int getCursorColumn() {
        return this.cursorColumn;
    }

    public void setCurrentWidth(double w) {
        this.currentWidth = w;
    }

    public double getCurrentWidth() {
        return this.currentWidth;
    }

    public void setCurrentHeight(double h) {
        this.currentHeight = h;
    }

    public double getCurrentHeight() {
        return this.currentHeight;
    }

    public void setAutoHeight(boolean v) {
        this.autoHeight = v;
    }

    public boolean isAutoHeight() {
        return this.autoHeight;
    }

    public void setMinimumHeight(double h) {
        this.minimumHeight = h;
    }

    public double getMinimumHeight() {
        return this.minimumHeight;
    }

    public void setMinimumHeightSet(boolean v) {
        this.minimumHeightSet = v;
    }

    public boolean isMinimumHeightSet() {
        return this.minimumHeightSet;
    }

    public void setCurrentDefaultFontMetrics(FontMetrics fm) {
        this.currentDefaultFontMetrics = fm;
    }

    public FontMetrics getCurrentDefaultFontMetrics() {
        return this.currentDefaultFontMetrics;
    }

    @Override
    public void setPoints(MPoint[] p) {
        super.setPoints(p);
        this.minimumHeightSet = false;
    }

    @Override
    public boolean hasColor() {
        return true;
    }

    @Override
    public boolean hasBackground() {
        return true;
    }

    @Override
    public boolean hasFace() {
        return true;
    }

    @Override
    public void transform(CTransform3D t, int opts, CTransform3D trot) {
        super.transform(t, opts, trot);
        double c = t.getScale();
        this.fontScale *= c;
        if (Math.abs((double)Math.round(2.0 * this.fontScale) - 2.0 * this.fontScale) < 1.0E-12) {
            this.fontScale = 0.5 * (double)Math.round(2.0 * this.fontScale);
        }
    }

    @Override
    public void setSelected(boolean v) {
        super.setSelected(v);
        if (v) {
            // empty if block
        }
    }

    @Override
    public void unselectContents() {
        super.unselectContents();
        this.selectionStartPosition = 0;
        this.selectionEndPosition = 0;
    }

    public void setRowAndColumn0(int i) {
        int numlines = this.getLineCount();
        if (this.cursorPosition == i) {
            this.cursorRow = numlines;
            this.cursorColumn = 0;
        }
        if (this.getSelectionStartPos() == i) {
            this.selectionStartRow = numlines;
            this.selectionStartColumn = 0;
        }
        if (this.getSelectionEndPos() == i) {
            this.selectionEndRow = numlines;
            this.selectionEndColumn = 0;
        }
    }

    public void addLine(MTextDocument.Portion s) {
        int i0 = s.getStartPos();
        int numlines = this.getLineCount();
        if (this.cursorPosition >= i0 && this.cursorPosition <= s.getEndPos()) {
            this.cursorRow = numlines;
            this.cursorColumn = this.cursorPosition - i0;
            if (this.cursorColumn == s.length() && s.endsWith('\n')) {
                this.cursorColumn = 0;
                ++this.cursorRow;
            }
        }
        if (this.getSelectionStartPos() >= i0 && this.getSelectionStartPos() <= s.getEndPos()) {
            this.selectionStartRow = numlines;
            this.selectionStartColumn = this.getSelectionStartPos() - i0;
            if (this.selectionStartColumn == s.length() && s.endsWith('\n')) {
                this.selectionStartColumn = 0;
                ++this.selectionStartRow;
            }
        }
        if (this.getSelectionEndPos() >= i0 && this.getSelectionEndPos() <= s.getEndPos()) {
            this.selectionEndRow = numlines;
            this.selectionEndColumn = this.getSelectionEndPos() - i0;
            if (this.selectionEndColumn == s.length() && s.endsWith('\n')) {
                this.selectionEndColumn = 0;
                ++this.selectionEndRow;
            }
        }
        this.wrappedLines.add(s);
    }

    public int determinePosition(DPoint3 p, boolean allowExternalPoints) {
        return MTextBoxModule.determinePosition(this, p, allowExternalPoints);
    }

    public String getPreBreakingChars() {
        return "";
    }

    public String getBreakingChars() {
        return " \t";
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(3);
        this.text.writeExternal(oos);
        oos.writeDouble(this.fontScale);
        int align = this.horizontalAlignment | this.verticalAlignment << 2;
        oos.writeByte((byte)align);
        oos.writeInt(this.cursorPosition);
        oos.writeInt(this.selectionStartPosition);
        oos.writeInt(this.selectionEndPosition);
        int f = 0;
        if (this.autoSize) {
            f |= 1;
        }
        oos.writeInt(f);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 3) {
            throw new IOException("Cannot deserialize text object with future version (" + version + ")");
        }
        this.text = new MTextDocument();
        this.text.readExternal(ois);
        if (version > 0) {
            this.fontScale = ois.readDouble();
        }
        if (version > 2) {
            byte align = ois.readByte();
            this.horizontalAlignment = align & 3;
            this.verticalAlignment = align >> 2 & 3;
        } else {
            this.horizontalAlignment = 0;
            this.verticalAlignment = 0;
        }
        this.cursorPosition = ois.readInt();
        this.selectionStartPosition = ois.readInt();
        this.selectionEndPosition = ois.readInt();
        int f = ois.readInt();
        this.autoSize = (f & 1) != 0;
        this.wrappedLines = new ArrayList<MTextDocument.Portion>();
    }
}

