/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.graphics;

import chemaxon.struc.DPoint3;
import chemaxon.struc.graphics.MFont;
import chemaxon.struc.graphics.MTextAttributes;
import chemaxon.struc.graphics.MTextBox;
import chemaxon.struc.graphics.MTextDocument;
import java.awt.FontMetrics;

class MTextBoxModule {
    MTextBoxModule() {
    }

    static void addString(MTextBox tbox, String s) {
        MTextDocument text = tbox.getTextDocument();
        int crspos = tbox.cursorPosition;
        int selstart = tbox.getSelectionStartPos();
        int selend = tbox.getSelectionEndPos();
        if (tbox.hasSelection()) {
            text.replace(selstart, selend - selstart, s);
            tbox.setCursorPos0(selstart + s.length());
            tbox.unselectContents();
        } else {
            MTextAttributes attrs = tbox.getCurrentTextAttributes(0);
            if (crspos == text.length()) {
                text.append(s, attrs);
            } else {
                text.insert(crspos, s, attrs);
            }
            tbox.cursorPosition += s.length();
        }
        tbox.autoHeight = true;
    }

    static void deleteCharBackwards(MTextBox tbox) {
        int crspos = tbox.cursorPosition;
        if (tbox.hasSelection()) {
            MTextBoxModule.deleteChar(tbox);
            tbox.autoHeight = true;
        } else if (crspos > 0) {
            MTextDocument text = tbox.getTextDocument();
            text.remove(crspos - 1, 1);
            tbox.setCursorPos0(crspos - 1);
            tbox.autoHeight = true;
        }
    }

    static void deleteChar(MTextBox tbox) {
        MTextDocument text = tbox.getTextDocument();
        int crspos = tbox.cursorPosition;
        int selstart = tbox.getSelectionStartPos();
        int selend = tbox.getSelectionEndPos();
        if (tbox.hasSelection()) {
            text.remove(selstart, selend - selstart);
            tbox.setCursorPos0(tbox.getSelectionStartPos());
            tbox.unselectContents();
            tbox.autoHeight = true;
        } else if (crspos < text.length()) {
            text.remove(crspos, 1);
            tbox.autoHeight = true;
        }
    }

    static void cursowToRowStart(MTextBox tbox, boolean select) {
        int col = tbox.cursorColumn;
        tbox.cursorColumn = 0;
        int newpos = tbox.cursorPosition - col;
        tbox.setCursorPos(newpos, select);
    }

    static void cursowToRowEnd(MTextBox tbox, boolean select) {
        int length;
        int col = tbox.cursorColumn;
        MTextDocument.Portion s = tbox.getLine(tbox.cursorRow);
        tbox.cursorColumn = length = s.endsWith('\n') ? s.length() - 1 : s.length();
        int newpos = tbox.cursorPosition + (length - col);
        tbox.setCursorPos(newpos, select);
    }

    static void cursorUp(MTextBox tbox, boolean select) {
        int crscol = tbox.cursorColumn;
        if (tbox.cursorRow > 0) {
            --tbox.cursorRow;
            MTextDocument.Portion s = tbox.getLine(tbox.cursorRow);
            int newpos = tbox.cursorPosition - crscol;
            int l = s.length();
            if (s.endsWith('\n')) {
                --l;
            }
            if (crscol > l) {
                tbox.cursorColumn = l;
                --newpos;
            } else {
                newpos -= s.length() - crscol;
            }
            tbox.setCursorPos(newpos, select);
        }
    }

    static void cursorDown(MTextBox tbox, boolean select) {
        int crscol = tbox.cursorColumn;
        if (tbox.cursorRow < tbox.getLineCount() - 1) {
            MTextDocument.Portion s = tbox.getLine(tbox.cursorRow);
            ++tbox.cursorRow;
            int newpos = tbox.cursorPosition + s.length() - crscol;
            s = tbox.getLine(tbox.cursorRow);
            int l = s.length();
            if (s.endsWith('\n')) {
                --l;
            }
            if (crscol > l) {
                tbox.cursorColumn = crscol = l;
            }
            tbox.setCursorPos(newpos += crscol, select);
        }
    }

    static int determinePosition(MTextBox tbox, DPoint3 p, boolean allowExternalPoints) {
        double width = tbox.currentWidth;
        double height = tbox.currentHeight;
        DPoint3 p0 = tbox.getPoint(0).getLocation();
        DPoint3 p1 = tbox.getPoint(1).getLocation();
        DPoint3 p2 = tbox.getPoint(2).getLocation();
        DPoint3 p3 = tbox.getPoint(3).getLocation();
        double rx01 = p1.x - p0.x;
        double ry01 = p1.y - p0.y;
        double r01 = Math.sqrt(rx01 * rx01 + ry01 * ry01);
        if (r01 == 0.0) {
            return -1;
        }
        double ex01 = rx01 / r01;
        double ey01 = ry01 / r01;
        double rx03 = p3.x - p0.x;
        double ry03 = p3.y - p0.y;
        double r03 = Math.sqrt(rx03 * rx03 + ry03 * ry03);
        if (r03 == 0.0) {
            return -1;
        }
        double ex03 = rx03 / r03;
        double ey03 = ry03 / r03;
        double e01p = ex01 * (p.x - p0.x) + ey01 * (p.y - p0.y);
        double e03p = ex03 * (p.x - p0.x) + ey03 * (p.y - p0.y);
        double e01e03 = ex01 * ex03 + ey01 * ey03;
        double x = e01p - e01e03 * e03p;
        double y = e03p - e01e03 * e01p;
        double xi = width * (x / r01);
        double yi = height * (y / r03);
        if (!allowExternalPoints && (xi < 0.0 || xi >= width || yi < 0.0 || yi >= height)) {
            return -1;
        }
        return MTextBoxModule.determinePosition0(tbox, xi, yi);
    }

    private static int determinePosition0(MTextBox tbox, double x, double y) {
        double descent;
        MTextDocument.Portion line;
        double ascent;
        double nexth;
        int iline;
        int nlines = tbox.getLineCount();
        double h = 0.0;
        FontMetrics fm0 = tbox.currentDefaultFontMetrics;
        MFont dmfont = tbox.getBaseFont();
        for (iline = 0; iline < nlines && !((nexth = h + (ascent = (line = tbox.getLine(iline)).getAscent(null, fm0)) + (descent = line.getDescent(null, fm0))) > y); ++iline) {
            h = nexth;
        }
        if (nlines == 0) {
            return -1;
        }
        if (iline < 0) {
            iline = 0;
        }
        if (iline >= nlines) {
            iline = nlines - 1;
        }
        MTextDocument text = tbox.getTextDocument();
        MTextDocument.Portion line2 = tbox.getLine(iline);
        if (line2.endsWith(' ') || line2.endsWith('\n')) {
            line2 = line2.getPortion(0, line2.length() - 1);
        }
        int i0 = tbox.getLinePosition(iline);
        if (x < 0.0) {
            return i0;
        }
        double xl = 0.0;
        double ascent2 = line2.getAscent(null, fm0);
        int index = -1;
        for (int j = 1; j <= line2.length(); ++j) {
            MTextDocument.Portion portion = line2.getPortion(0, j);
            double xr0 = portion.portionXAdvance(null, dmfont, fm0);
            double xr = portion.portionWidth(null, dmfont, fm0);
            int k = text.getSectionIndexOfCharAt(Math.min(Math.max(i0 + j - 1, 0), Math.max(text.length() - 1, 0)));
            MTextDocument.Section sec = text.getSection(k);
            double y0 = ascent2 + h - text.getSectionShiftY(k);
            FontMetrics fm = sec.getFontMetrics(null, text.getDefaultFont());
            if (fm == null) {
                fm = fm0;
            }
            double ascentj = fm.getAscent();
            double descentj = fm.getDescent();
            double y1 = y0 - ascentj;
            double y2 = y0 + descentj;
            if (x >= xl && x < xr && y >= y1 && y < y2) {
                double xc = (xl + xr) / 2.0;
                int i = i0 + j - 1;
                if (x > xc) {
                    // empty if block
                }
                index = ++i;
            }
            xl = xr0;
        }
        return index >= 0 ? index : i0 + line2.length();
    }
}

