/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.prop;

import chemaxon.core.spi.MPropHandlerIface;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MProp;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.StringTokenizer;

public class MDoubleArrayProp
extends MProp {
    private static final long serialVersionUID = -5670039985685584647L;
    private transient double[] doubleValues;

    public MDoubleArrayProp(double[] x) {
        int n = x.length;
        this.doubleValues = new double[n];
        System.arraycopy(x, 0, this.doubleValues, 0, n);
    }

    public MDoubleArrayProp(String sval, int size, int c) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(sval, c != -1 ? String.valueOf((char)c) : " \t\r\n");
        try {
            double[] x;
            if (size >= 0) {
                x = new double[size];
                for (int i = 0; i < size; ++i) {
                    x[i] = Double.valueOf(st.nextToken());
                }
            } else {
                double[] y;
                x = new double[16];
                int n = 0;
                while (st.hasMoreTokens()) {
                    if (n == x.length) {
                        y = new double[x.length * 2];
                        System.arraycopy(x, 0, y, 0, n);
                        x = y;
                    }
                    x[n] = Double.valueOf(st.nextToken());
                    ++n;
                }
                if (n != x.length) {
                    y = new double[n];
                    System.arraycopy(x, 0, y, 0, n);
                    x = y;
                }
            }
            this.doubleValues = x;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public int getPropArraySize() {
        return this.doubleValues.length;
    }

    @Override
    public String convertToString(String fmt, int flags) {
        MPropHandlerIface handler = (MPropHandlerIface)MarvinModule.load("chemaxon.marvin.io.MPropHandlerUtil");
        return handler.convertToString(this, fmt);
    }

    @Override
    public Object getPropValue() {
        return this.doubleValues;
    }

    public final double[] getDoubleArray() {
        return this.doubleValues;
    }

    @Override
    public String getPropType() {
        return "double";
    }

    @Override
    public String getPropXSDType() {
        return "double";
    }

    @Override
    public MProp cloneProp() {
        return new MDoubleArrayProp(this.doubleValues);
    }

    public Object clone() {
        return this.cloneProp();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int n = in.readInt();
        double[] x = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = in.readDouble();
        }
        this.doubleValues = x;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        double[] x = this.doubleValues;
        out.writeInt(x.length);
        for (int i = 0; i < x.length; ++i) {
            out.writeDouble(x[i]);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof MDoubleArrayProp) {
            MDoubleArrayProp p = (MDoubleArrayProp)o;
            if (Arrays.equals(this.getDoubleArray(), p.getDoubleArray())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.doubleValues.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(this.doubleValues[i]);
        }
        return sb.toString();
    }
}

