/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.prop;

import chemaxon.core.spi.MPropHandlerIface;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MProp;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.StringTokenizer;

public class MIntegerArrayProp
extends MProp {
    private static final long serialVersionUID = 6651869314046996057L;
    private transient int[] intValues;

    public MIntegerArrayProp(int[] x) {
        int n = x.length;
        this.intValues = new int[n];
        System.arraycopy(x, 0, this.intValues, 0, n);
    }

    public MIntegerArrayProp(String sval, int size, int c) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(sval, c != -1 ? String.valueOf((char)c) : " \t\r\n");
        try {
            int[] x;
            if (size >= 0) {
                x = new int[size];
                for (int i = 0; i < size; ++i) {
                    x[i] = Integer.parseInt(st.nextToken());
                }
            } else {
                int[] y;
                x = new int[16];
                int n = 0;
                while (st.hasMoreTokens()) {
                    if (n == x.length) {
                        y = new int[x.length * 2];
                        System.arraycopy(x, 0, y, 0, n);
                        x = y;
                    }
                    x[n] = Integer.parseInt(st.nextToken());
                    ++n;
                }
                if (n != x.length) {
                    y = new int[n];
                    System.arraycopy(x, 0, y, 0, n);
                    x = y;
                }
            }
            this.intValues = x;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public int getPropArraySize() {
        return this.intValues.length;
    }

    @Override
    public String convertToString(String fmt, int flags) {
        MPropHandlerIface handler = (MPropHandlerIface)MarvinModule.load("chemaxon.marvin.io.MPropHandlerUtil");
        return handler.convertToString(this, fmt);
    }

    @Override
    public Object getPropValue() {
        return this.intValues;
    }

    public final int[] getIntArray() {
        return this.intValues;
    }

    @Override
    public String getPropType() {
        return "integer";
    }

    @Override
    public String getPropXSDType() {
        return "integer";
    }

    @Override
    public MProp cloneProp() {
        return new MIntegerArrayProp(this.intValues);
    }

    public Object clone() {
        return this.cloneProp();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int n = in.readInt();
        int[] x = new int[n];
        for (int i = 0; i < n; ++i) {
            x[i] = in.readInt();
        }
        this.intValues = x;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int[] x = this.intValues;
        out.writeInt(x.length);
        for (int i = 0; i < x.length; ++i) {
            out.writeInt(x[i]);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof MIntegerArrayProp) {
            MIntegerArrayProp p = (MIntegerArrayProp)o;
            if (Arrays.equals(this.intValues, p.intValues)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.intValues.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(this.intValues[i]);
        }
        return sb.toString();
    }
}

