/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.prop;

import chemaxon.common.util.Base64Util;
import chemaxon.core.spi.MPropHandlerIface;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MProp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;

public class MObjectProp
extends MProp {
    private static final long serialVersionUID = 4005646748655675692L;
    private transient Object object;

    public MObjectProp(Object o) {
        if (o == null) {
            throw new NullPointerException("MObjectProp cannot be created with null argument");
        }
        this.object = o;
    }

    public MObjectProp(String sval) throws IOException {
        byte[] bytes = Base64Util.decode(sval);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            this.object = ois.readObject();
            ois.close();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String convertToString(String fmt, int flags) throws MolExportException {
        try {
            MPropHandlerIface handler = (MPropHandlerIface)MarvinModule.load("chemaxon.marvin.io.MPropHandlerUtil");
            return handler.convertToString(this, fmt);
        }
        catch (IllegalArgumentException e) {
            throw new MolExportException(e);
        }
    }

    @Override
    public Object getPropValue() {
        return this.object;
    }

    @Override
    public String getPropType() {
        return "object";
    }

    @Override
    public String getPropXSDType() {
        return "ENTITY";
    }

    @Override
    public MProp cloneProp() {
        Object o = this.object;
        if (o instanceof Cloneable) {
            Method m = null;
            try {
                m = o.getClass().getMethod("clone", new Class[0]);
                o = m.invoke(o, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new MObjectProp(o);
    }

    public Object clone() {
        return this.cloneProp();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.object = in.readObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.object);
    }

    public boolean equals(Object o) {
        if (o instanceof MObjectProp) {
            MObjectProp p = (MObjectProp)o;
            if (this.object.equals(p.object)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.object);
            oos.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            return Base64Util.encode(baos.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

