/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.prop;

import chemaxon.struc.DPoint3;
import chemaxon.struc.MProp;
import chemaxon.struc.Molecule;
import chemaxon.struc.prop.MBooleanProp;
import chemaxon.struc.prop.MByteArrayProp;
import chemaxon.struc.prop.MDoubleArrayProp;
import chemaxon.struc.prop.MDoubleProp;
import chemaxon.struc.prop.MHCoords3DProp;
import chemaxon.struc.prop.MIntegerArrayProp;
import chemaxon.struc.prop.MIntegerProp;
import chemaxon.struc.prop.MMoleculeProp;
import chemaxon.struc.prop.MObjectProp;
import chemaxon.struc.prop.MStringProp;
import java.util.Iterator;
import java.util.Map;

public class MPropFactory {
    public static MProp getMProp(Object val) {
        if (val instanceof MProp) {
            return (MProp)val;
        }
        if (val instanceof String) {
            return new MStringProp((String)val);
        }
        if (val instanceof Boolean) {
            return new MBooleanProp((Boolean)val);
        }
        if (val instanceof Integer) {
            return new MIntegerProp((Integer)val);
        }
        if (val instanceof Double) {
            return new MDoubleProp((Double)val);
        }
        if (val instanceof Molecule) {
            return new MMoleculeProp((Molecule)val);
        }
        if (val instanceof int[]) {
            return new MIntegerArrayProp((int[])val);
        }
        if (val instanceof double[]) {
            return new MDoubleArrayProp((double[])val);
        }
        if (val instanceof byte[]) {
            return new MByteArrayProp((byte[])val);
        }
        if (val instanceof Map) {
            Map map = (Map)val;
            Object key = null;
            Object o = null;
            Iterator<Object> it = map.keySet().iterator();
            if (it.hasNext()) {
                key = it.next();
            }
            if ((it = map.entrySet().iterator()).hasNext()) {
                o = it.next();
            }
            if (key != null && o != null && key instanceof Integer && o instanceof DPoint3[]) {
                return new MHCoords3DProp(map, 0L);
            }
        }
        return new MObjectProp(val);
    }
}

