/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.sgroup;

import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Vector;

public class DataSgroup
extends Sgroup {
    private static final long serialVersionUID = -3132191586564122343L;
    private static final String[] CONTEXTS = new String[]{"Atom", "Bond", "Single Bond", "Double Bond", "Fragment", "Group (Selection)"};
    public static final int DT_UNSPEC = 0;
    public static final int DT_FORMATTED = 1;
    public static final int DT_NUMERIC = 2;
    public static final int DT_TEXT = 3;
    public static final int DT_URL = 4;
    public static final int HIDDEN = -2;
    private transient String fieldName = "";
    private transient int fieldType;
    private transient String units;
    private transient String queryCode;
    private transient String queryOp;
    private transient double xCoordinate;
    private transient double yCoordinate;
    private transient boolean dataDetached = true;
    private transient boolean unitDisplayed = false;
    private transient boolean absolutePlacement = true;
    private transient int displayedChars;
    private transient int displayedLines;
    private transient char tag = (char)32;
    private transient int pos;
    private transient Vector<String> dataLines;
    private transient String context;
    private StringBuffer sb;

    public DataSgroup(Molecule parent) {
        super(parent, 10);
        this.dataLines = new Vector();
    }

    public DataSgroup(DataSgroup sg, Molecule mol, Sgroup psg, int[] atomIndexMap) {
        super(sg, mol, psg, atomIndexMap);
        this.fieldName = sg.fieldName;
        this.fieldType = sg.fieldType;
        this.units = sg.units;
        this.queryCode = sg.queryCode;
        this.queryOp = sg.queryOp;
        this.xCoordinate = sg.xCoordinate;
        this.yCoordinate = sg.yCoordinate;
        this.dataDetached = sg.dataDetached;
        this.unitDisplayed = sg.unitDisplayed;
        this.absolutePlacement = sg.absolutePlacement;
        this.displayedChars = sg.displayedChars;
        this.displayedLines = sg.displayedLines;
        this.tag = sg.tag;
        this.pos = sg.pos;
        this.dataLines = new Vector<String>(sg.dataLines);
        this.context = sg.context;
    }

    public DataSgroup(DataSgroup sg, Molecule mol, Sgroup psg) {
        this(sg, mol, psg, null);
    }

    @Override
    protected Sgroup cloneSgroup(Molecule mol, Sgroup psg, int[] atomIndexMap) {
        return new DataSgroup(this, mol, psg, atomIndexMap);
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
        this.setContextDependentDetachMode();
    }

    public int getContextId() {
        return Arrays.asList(CONTEXTS).indexOf(this.context);
    }

    public void setContext(int id) {
        this.context = CONTEXTS[id];
        this.setContextDependentDetachMode();
    }

    private void setContextDependentDetachMode() {
        if (!"Atom".equals(this.context)) {
            this.setDataDetached(true);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String nameP) {
        this.fieldName = nameP;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int typeP) {
        this.fieldType = typeP;
    }

    public void setFieldType(String ft) {
        if (ft != null) {
            if (ft.equals("F")) {
                this.setFieldType(1);
            } else if (ft.equals("T")) {
                this.setFieldType(3);
            } else if (ft.equals("N")) {
                this.setFieldType(2);
            } else if (ft.equals("U")) {
                this.setFieldType(4);
            }
        }
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String unitsP) {
        this.units = unitsP;
    }

    public String getQueryCode() {
        return this.queryCode;
    }

    public void setQueryCode(String queryCodeP) {
        this.queryCode = queryCodeP;
    }

    public String getQueryOp() {
        return this.queryOp;
    }

    public void setQueryOp(String queryOpP) {
        this.queryOp = queryOpP;
    }

    public double getX() {
        return this.xCoordinate;
    }

    public void setX(double x) {
        this.xCoordinate = x;
    }

    public double getY() {
        return this.yCoordinate;
    }

    public void setY(double y) {
        this.yCoordinate = y;
    }

    public void setAbsoluteXY(DPoint3 p) {
        this.setAbsoluteXY(p.x, p.y);
    }

    public void setAbsoluteXY(double x, double y) {
        this.dataDetached = true;
        if (this.absolutePlacement) {
            this.xCoordinate = x;
            this.yCoordinate = y;
        } else {
            DPoint3 origin = new DPoint3();
            this.getPlacementOrigin(origin);
            this.xCoordinate = x - origin.x;
            this.yCoordinate = y - origin.y;
        }
    }

    public DPoint3 getAbsoluteXY() {
        DPoint3 p = new DPoint3();
        this.getPlacementOrigin(p);
        p.x += this.xCoordinate;
        p.y += this.yCoordinate;
        return p;
    }

    public void getPlacementOrigin(DPoint3 p) {
        p.z = 0.0;
        p.y = 0.0;
        p.x = 0.0;
        if (!this.isAbsolutePlacement()) {
            if (this.getAtomCount() != 0) {
                this.getObjectsMiddle(p);
            } else {
                Sgroup sgroup;
                Sgroup sgroup2 = sgroup = this.getParentSgroup() != null ? this.getParentSgroup() : this;
                if (sgroup.getBracketCount() != 0) {
                    DPoint3 newp = sgroup.getBrackets().get(0).getPoint(1).getLocation();
                    p.x = newp.x + 0.154;
                    p.y = newp.y - 0.308;
                    p.z = newp.z;
                }
            }
        }
    }

    public void getObjectsMiddle(DPoint3 p) {
        p.z = 0.0;
        p.y = 0.0;
        p.x = 0.0;
        int nAtoms = this.getAtomCount();
        for (int i = 0; i < nAtoms; ++i) {
            MolAtom ma = this.getAtom(i);
            p.x += ma.getX();
            p.y += ma.getY();
        }
        if (nAtoms != 0) {
            p.x /= (double)nAtoms;
            p.y /= (double)nAtoms;
        }
    }

    public boolean isDataDetached() {
        return this.dataDetached;
    }

    public void setDataDetached(boolean b) {
        this.dataDetached = b;
    }

    public boolean isUnitDisplayed() {
        return this.unitDisplayed;
    }

    public void setUnitDisplayed(boolean b) {
        this.unitDisplayed = b;
    }

    public boolean isAbsolutePlacement() {
        return this.absolutePlacement;
    }

    public void setAbsolutePlacement(boolean b) {
        this.absolutePlacement = b;
    }

    public int getDisplayedChars() {
        return this.displayedChars;
    }

    public void setDisplayedChars(int chars) {
        this.displayedChars = chars;
    }

    public int getDisplayedLines() {
        return this.displayedLines;
    }

    public void setDisplayedLines(int lines) {
        this.displayedLines = lines;
    }

    public char getTag() {
        return this.tag;
    }

    public void setTag(char c) {
        this.tag = c;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int p) {
        this.pos = p;
    }

    public String getData() {
        return this.glueData(this.dataLines);
    }

    private String glueData(Vector<String> lines) {
        if (lines.size() == 0) {
            return "";
        }
        if (lines.size() == 1) {
            return lines.elementAt(0);
        }
        StringBuilder builder = new StringBuilder(lines.size() * 50);
        for (int i = 0; i < lines.size(); ++i) {
            String s = lines.elementAt(i);
            builder.append(s);
            builder.append('\n');
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    public void setData(String s) {
        this.parseLines(s);
    }

    private void parseLines(String s) {
        if (this.dataLines == null) {
            this.dataLines = new Vector();
        }
        this.dataLines.removeAllElements();
        int bol = 0;
        int eol = s.indexOf(10, bol);
        while (eol != -1) {
            this.dataLines.addElement(s.substring(bol, eol));
            bol = eol + 1;
            eol = s.indexOf(10, bol);
        }
        eol = s.length();
        this.dataLines.addElement(s.substring(bol, eol));
    }

    public int getDataLineCount() {
        return this.dataLines.size();
    }

    public String getDataLine(int i) {
        return this.dataLines.elementAt(i);
    }

    public void setDataLine(int i, String line) {
        this.dataLines.setElementAt(line, i);
    }

    public void addDataLine(String line) {
        this.dataLines.addElement(line);
    }

    public String getLineOnScreen(int i) {
        if (this.sb == null) {
            this.sb = new StringBuffer(300);
        }
        int lineCount = this.getDataLineCount();
        int displayedLinesNum = this.getDisplayedLines();
        boolean needDots = false;
        this.sb.setLength(0);
        if (this.getDataLineCount() <= i) {
            return this.sb.toString();
        }
        this.sb.append(this.getDataLine(i));
        if (displayedLinesNum != 0 && lineCount > displayedLinesNum) {
            lineCount = displayedLinesNum;
            needDots = true;
        }
        boolean hasDots = false;
        if (this.getDisplayedChars() != 0 && this.sb.length() > this.getDisplayedChars()) {
            this.sb.setLength(Math.max(0, this.getDisplayedChars()));
            this.sb.append("...");
            hasDots = true;
        }
        if (i == 0) {
            String op;
            char t = this.getTag();
            if (t != ' ') {
                this.sb.insert(0, '=');
                this.sb.insert(0, t);
            }
            if ((op = this.getQueryOp()) != null) {
                this.sb.insert(0, ' ');
                this.sb.insert(0, op);
            }
            String u = this.getUnits();
            if (this.isUnitDisplayed() && u != null) {
                this.sb.append(' ');
                this.sb.append(u);
            }
        }
        if (i == lineCount - 1 && needDots && !hasDots) {
            this.sb.append("...");
        }
        return this.sb.toString();
    }

    @Override
    public boolean hasBrackets() {
        return this.displayedLines != -2;
    }

    @Override
    public boolean isTotalSelected(MoleculeGraph sel) {
        int i;
        if (sel == null) {
            return false;
        }
        int nAtoms = this.getAtomCount();
        for (i = 0; i < nAtoms && sel.indexOf(this.getAtom(i)) != -1; ++i) {
        }
        return i == nAtoms;
    }

    @Override
    public String getSubscript() {
        String dataLabel = this.dataLines.size() == 0 ? "n/a" : (this.dataLines.size() == 1 ? this.dataLines.elementAt(0) : this.dataLines.elementAt(0) + "...");
        if (this.queryOp != null) {
            return this.fieldName + " " + this.queryOp + " " + dataLabel;
        }
        return this.fieldName + " = " + dataLabel;
    }

    @Override
    protected void transformByParent(CTransform3D t, boolean incg) {
        DPoint3 p = new DPoint3();
        p.x = this.getX();
        p.y = this.getY();
        p.z = 0.0;
        t.transform(p);
        this.setX(p.x);
        this.setY(p.y);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(1);
        oos.writeBoolean(this.absolutePlacement);
        oos.writeObject(this.getData());
        oos.writeBoolean(this.dataDetached);
        oos.writeInt(this.displayedChars);
        oos.writeInt(this.displayedLines);
        oos.writeObject(this.fieldName);
        oos.writeInt(this.fieldType);
        oos.writeInt(this.pos);
        oos.writeObject(this.queryCode);
        oos.writeObject(this.queryOp);
        oos.writeChar(this.tag);
        oos.writeBoolean(this.unitDisplayed);
        oos.writeObject(this.units);
        oos.writeDouble(this.xCoordinate);
        oos.writeDouble(this.yCoordinate);
        oos.writeObject(this.context);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 1) {
            throw new IOException("Cannot deserialize data Sgroup with future version (" + version + ")");
        }
        this.absolutePlacement = ois.readBoolean();
        this.setData((String)ois.readObject());
        this.dataDetached = ois.readBoolean();
        this.displayedChars = ois.readInt();
        this.displayedLines = ois.readInt();
        this.fieldName = (String)ois.readObject();
        this.fieldType = ois.readInt();
        this.pos = ois.readInt();
        this.queryCode = (String)ois.readObject();
        this.queryOp = (String)ois.readObject();
        this.tag = ois.readChar();
        this.unitDisplayed = ois.readBoolean();
        this.units = (String)ois.readObject();
        this.xCoordinate = ois.readDouble();
        this.yCoordinate = ois.readDouble();
        if (version >= 1) {
            this.context = (String)ois.readObject();
        }
    }
}

