/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.sgroup;

import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MulticenterSgroup
extends Sgroup {
    private static final long serialVersionUID = -7213879722783498112L;
    private transient MolAtom centralAtom = null;

    public MulticenterSgroup(Molecule parent) {
        super(parent, 14);
    }

    protected MulticenterSgroup(MulticenterSgroup sg, Molecule m, Sgroup psg) {
        this(sg, m, psg, null);
    }

    protected MulticenterSgroup(MulticenterSgroup sg, Molecule m, Sgroup psg, int[] atomIndexMap) {
        super(sg, m, psg, atomIndexMap);
        if (sg.centralAtom != null) {
            int k = sg.getParentMolecule().indexOf(sg.centralAtom);
            if (m == null || k == -1) {
                if (psg instanceof SuperatomSgroup) {
                    if (((SuperatomSgroup)psg).isContracted()) {
                        k = sg.getParentSgroup().indexOf(sg.centralAtom);
                        this.centralAtom = psg.getAtom(k);
                    }
                } else {
                    this.centralAtom = null;
                }
            } else if (atomIndexMap == null) {
                this.centralAtom = m.getAtom(k);
            } else {
                int index;
                boolean contains = false;
                for (index = 0; index < atomIndexMap.length && !contains; contains |= atomIndexMap[index] == k, ++index) {
                }
                if (contains) {
                    this.centralAtom = m.getAtom(index - 1);
                }
            }
        } else {
            this.centralAtom = null;
        }
    }

    @Override
    protected Sgroup cloneSgroup(Molecule m, Sgroup psg, int[] atomIndexMap) {
        return new MulticenterSgroup(this, m, psg, atomIndexMap);
    }

    public void addCentralAtom() {
        Molecule parent = this.getParentMolecule();
        this.centralAtom = new MolAtom(137);
        parent.add(this.centralAtom);
        this.initCentralAtom();
    }

    public DPoint3 recalcCentralAtom() {
        if (this.centralAtom == null) {
            return null;
        }
        int n = this.getAtomCount();
        DPoint3 center = new DPoint3();
        for (int i = 0; i < n; ++i) {
            MolAtom atom = this.getAtom(i);
            if (atom == this.centralAtom) continue;
            center.x += atom.getX();
            center.y += atom.getY();
            center.z += atom.getZ();
        }
        center.x /= (double)n;
        center.y /= (double)n;
        center.z /= (double)n;
        this.centralAtom.setXYZ(center.x, center.y, center.z);
        return center;
    }

    public DPoint3 initCentralAtom() {
        if (this.centralAtom == null) {
            this.addCentralAtom();
        }
        DPoint3 center = this.recalcCentralAtom();
        return center;
    }

    @Override
    public boolean hasBrackets() {
        return false;
    }

    public boolean hasNonCoordinateBond() {
        if (this.centralAtom == null) {
            return false;
        }
        for (int i = this.centralAtom.getBondCount() - 1; i >= 0; --i) {
            if (this.centralAtom.getBond(i).getType() == 9) continue;
            return true;
        }
        return false;
    }

    public MolAtom getCentralAtom() {
        return this.centralAtom;
    }

    public void setCentralAtom(MolAtom atom) {
        if (atom != null) {
            atom.setAtno(137);
        }
        this.centralAtom = atom;
    }

    public void replaceMulticenterAtom(MolAtom atom, MolAtom atom2) {
        if (atom == this.centralAtom) {
            this.centralAtom = atom2;
            if (this.getParentSgroup() != null) {
                this.getParentSgroup().replaceAtom(atom, atom2, 0);
            }
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.writeObject(this.centralAtom);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize Multicenter Sgroup with future version (" + version + ")");
        }
        this.centralAtom = (MolAtom)ois.readObject();
    }

    @Override
    public boolean isTotalSelected(MoleculeGraph sel) {
        int i;
        if (sel == null) {
            return false;
        }
        int nAtoms = this.getAtomCount();
        for (i = 0; i < nAtoms && sel.indexOf(this.getAtom(i)) != -1; ++i) {
        }
        return i == nAtoms;
    }

    public boolean containsAllAtomsOf(MoleculeGraph molGraph) {
        int n = molGraph.getAtomCount();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            MolAtom a = molGraph.getAtom(i);
            if (a == this.centralAtom || this.indexOf(a) >= 0) continue;
            return false;
        }
        return true;
    }
}

