/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.sgroup;

import chemaxon.core.calculations.AtomBranchCoords;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.Expandable;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MultipleSgroup
extends Sgroup
implements Expandable {
    private static final long serialVersionUID = -1146464131016252826L;
    transient MolAtom[] parentAtoms = new MolAtom[0];
    private transient MolAtom[] attachAtoms = new MolAtom[0];
    private transient MolBond[] externalBonds = null;
    private transient MolAtom[] externalAttachAtomsIn = null;
    private transient MolAtom[] externalAttachAtomsOut = null;
    private transient int multiplier;
    private transient boolean expandedState = false;
    private transient int[] savedAtomIndices = null;

    public MultipleSgroup(Molecule parent, boolean expanded) {
        super(parent, 1, expanded ? 1 : 2);
        this.expandedState = expanded;
        this.multiplier = 1;
    }

    protected MultipleSgroup(MultipleSgroup sg, Molecule m, Sgroup psg) {
        super(sg, m, psg);
        int i;
        this.multiplier = sg.multiplier;
        this.parentAtoms = new MolAtom[sg.parentAtoms.length];
        for (i = 0; i < sg.parentAtoms.length; ++i) {
            MolAtom a = sg.parentAtoms[i];
            int k = sg.sgroupGraph.indexOf(a);
            this.parentAtoms[i] = this.getAtom(k);
        }
        this.attachAtoms = new MolAtom[sg.attachAtoms.length];
        block1: for (i = 0; i < sg.attachAtoms.length; ++i) {
            for (int j = 0; j < sg.parentAtoms.length; ++j) {
                if (sg.parentAtoms[j] != sg.attachAtoms[i]) continue;
                this.attachAtoms[i] = this.parentAtoms[j];
                continue block1;
            }
        }
        this.expandedState = sg.expandedState;
    }

    public final boolean isRepeatingUnitAtom(MolAtom a) {
        for (int i = 0; i < this.parentAtoms.length; ++i) {
            if (a != this.parentAtoms[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isAcceptableGraph(MoleculeGraph molGraph) {
        int crossingBondCount = 0;
        for (int i = 0; i < molGraph.getAtomCount(); ++i) {
            MolAtom a = molGraph.getAtom(i);
            for (int j = 0; j < a.getBondCount(); ++j) {
                MolBond b = a.getBond(j);
                MolAtom aa = b.getOtherAtom(a);
                if (molGraph.contains(aa)) continue;
                ++crossingBondCount;
            }
        }
        return crossingBondCount == 0 || crossingBondCount == 2;
    }

    private int getRepeatingUnitAttach(MolAtom a, List<MolBond> bv) {
        if (!this.isRepeatingUnitAtom(a)) {
            return 0;
        }
        int na = a.getAttach() == 0 ? 0 : (a.getAttach() == 3 ? 2 : 1);
        int n = 0;
        for (int i = 0; i < a.getBondCount(); ++i) {
            MolBond b = a.getBond(i);
            MolAtom aa = b.getOtherAtom(a);
            if (this.isRepeatingUnitAtom(aa)) continue;
            if (bv != null && !bv.contains(b)) {
                bv.add(b);
            }
            ++n;
        }
        return n > 1 || na == 2 ? 2 : (n == 1 || na == 1 ? 1 : 0);
    }

    private void findExternalConnections() {
        this.externalBonds = this.findCrossingBonds();
        this.externalAttachAtomsIn = this.getCrossingAtoms(this.externalBonds);
        this.externalAttachAtomsOut = new MolAtom[this.externalBonds.length];
        for (int i = 0; i < this.externalBonds.length; ++i) {
            MolBond b = this.externalBonds[i];
            MolAtom a = this.externalAttachAtomsIn[i];
            this.externalAttachAtomsOut[i] = b.getOtherAtom(a);
        }
    }

    public final int getRepeatingUnitAtomCount() {
        return this.parentAtoms.length;
    }

    public final MolAtom getRepeatingUnitAtom(int i) {
        return this.parentAtoms[i];
    }

    public final MolAtom[] getRepeatingUnitAtoms() {
        MolAtom[] tmp = new MolAtom[this.parentAtoms.length];
        System.arraycopy(this.parentAtoms, 0, tmp, 0, tmp.length);
        return tmp;
    }

    public final void addRepeatingUnitAtom(MolAtom a) {
        this.setRepeatingUnitAtom(a, true, true, false);
    }

    public final void removeRepeatingUnitAtom(MolAtom a) {
        this.setRepeatingUnitAtom(a, false, true, false);
    }

    public final void setRepeatingUnitAtom(MolAtom a, boolean set) {
        this.setRepeatingUnitAtom(a, set, true, true);
    }

    private void setRepeatingUnitAtom(MolAtom a, boolean set, boolean ensure_atom_in_graph, boolean firstSet) {
        boolean toContract;
        if (this.isRepeatingUnitAtom(a) == set) {
            return;
        }
        int oldState = this.getXState();
        boolean bl = toContract = !firstSet && (oldState == 3 || oldState == 1) && this.parentAtoms.length != 0;
        if (toContract) {
            this.setXState(2);
        }
        if (set) {
            MolAtom[] tmp = new MolAtom[this.parentAtoms.length + 1];
            System.arraycopy(this.parentAtoms, 0, tmp, 0, this.parentAtoms.length);
            tmp[this.parentAtoms.length] = a;
            this.parentAtoms = tmp;
            if (ensure_atom_in_graph && !this.sgroupGraph.contains(a)) {
                this.sgroupGraph.add(a);
            }
        } else {
            this.parentAtoms = MultipleSgroup.removeFromArray(this.parentAtoms, a);
            if (ensure_atom_in_graph && this.sgroupGraph.contains(a)) {
                this.sgroupGraph.removeAtom(a);
            }
        }
        if (toContract) {
            this.setXState(oldState);
        }
        if (this.expandedState && this.parentAtoms.length != 0) {
            this.multiplier = this.getAtomCount() / this.parentAtoms.length;
        }
    }

    @Override
    public void add(MolAtom a) {
        if (this.isExpanded()) {
            super.add(a);
            int n = this.parentAtoms.length;
            if (n != 0) {
                this.multiplier = this.getAtomCount() / n;
            }
        } else {
            this.addRepeatingUnitAtom(a);
        }
    }

    private static final MolAtom[] removeFromArray(MolAtom[] atoms, MolAtom a) {
        int n = 0;
        for (int i = 0; i < atoms.length; ++i) {
            if (atoms[i] == a) continue;
            ++n;
        }
        MolAtom[] tmp = new MolAtom[n];
        int k = 0;
        for (int i = 0; i < atoms.length; ++i) {
            if (atoms[i] == a) continue;
            tmp[k++] = atoms[i];
        }
        return tmp;
    }

    public final int getMultiplier() {
        return this.multiplier;
    }

    public final void setMultiplier(int m) {
        if (m < 1) {
            throw new IllegalArgumentException("Invalid multiple group multiplier " + m);
        }
        this.multiplier = m;
    }

    public Sgroup newInstance() {
        return new MultipleSgroup(null, this.expandedState);
    }

    @Override
    public final void setAtom(int i, MolAtom a) {
        MolAtom orig = this.sgroupGraph.getAtom(i);
        super.setAtom(i, a);
        this.sgroupGraph.setAtom(i, a);
        for (int j = 0; j < this.parentAtoms.length; ++j) {
            if (this.parentAtoms[j] != orig) continue;
            this.parentAtoms[j] = a;
        }
    }

    @Override
    protected final void removeAtom(MolAtom a, int opts) {
        int i;
        super.removeAtom(a, opts);
        if (this.attachAtoms != null) {
            ArrayList<MolAtom> newAttachList = new ArrayList<MolAtom>();
            for (i = 0; i < this.attachAtoms.length; ++i) {
                if (this.attachAtoms[i] == a) continue;
                newAttachList.add(this.attachAtoms[i]);
            }
            this.attachAtoms = new MolAtom[newAttachList.size()];
            newAttachList.toArray(this.attachAtoms);
        }
        if (this.isRepeatingUnitAtom(a)) {
            this.setRepeatingUnitAtom(a, false);
            if ((opts & 1) != 0 && a instanceof SgroupAtom) {
                SuperatomSgroup sg = ((SgroupAtom)a).getSgroup();
                for (i = 0; i < sg.getAtomCount(); ++i) {
                    MolAtom aa = sg.getAtom(i);
                    this.setRepeatingUnitAtom(aa, true, false, true);
                }
            }
        }
    }

    @Override
    public final void replaceAtom(MolAtom olda, MolAtom newa, int opts) {
        int i;
        if ((opts & 2) != 0) {
            super.removeAtom(olda, opts & 0xFFFFFFFD);
            int oldsize = this.parentAtoms.length;
            this.setRepeatingUnitAtom(olda, false);
            if (this.parentAtoms.length < oldsize && !this.isRepeatingUnitAtom(newa)) {
                this.setRepeatingUnitAtom(newa, true, false, true);
            }
            return;
        }
        if (this.parentAtoms != null) {
            for (i = 0; i < this.parentAtoms.length; ++i) {
                if (this.parentAtoms[i] != olda) continue;
                this.parentAtoms[i] = newa;
            }
        }
        if (this.attachAtoms != null) {
            for (i = 0; i < this.attachAtoms.length; ++i) {
                if (this.attachAtoms[i] != olda) continue;
                this.attachAtoms[i] = newa;
            }
        }
        if (this.externalAttachAtomsIn != null) {
            for (i = 0; i < this.externalAttachAtomsIn.length; ++i) {
                if (this.externalAttachAtomsIn[i] != olda) continue;
                this.externalAttachAtomsIn[i] = newa;
            }
        }
        super.replaceAtom(olda, newa, opts);
    }

    @Override
    protected Sgroup cloneSgroup(Molecule m, Sgroup psg, int[] atomIndexMap) {
        return new MultipleSgroup(this, m, psg);
    }

    @Override
    public void setSubscript(String s) {
        try {
            this.multiplier = Integer.parseInt(s.trim());
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Bad multiple group subscript, not an integer");
        }
    }

    @Override
    public String getSubscript() {
        return this.expandedState ? "" : String.valueOf(this.multiplier);
    }

    @Override
    public final boolean expand(int opts) {
        boolean success = false;
        if (this.multiplier == 1 || this.expandedState) {
            if ((opts & 1) != 0) {
                this.contract(0);
                if (this.multiplier == 1) {
                    this.expandedState = true;
                }
            } else {
                return false;
            }
        }
        if (!this.expandedState) {
            int i;
            int k1;
            if (!this.isVisible()) {
                throw new IllegalArgumentException("cannot expand invisible group");
            }
            Molecule parentMol = this.getParentMolecule();
            SelectionMolecule g = this.sgroupGraph;
            g.regenBonds();
            this.updateAttachAtomsForExpand();
            this.findExternalConnections();
            for (int i2 = 0; i2 < this.externalBonds.length; ++i2) {
                parentMol.removeBond(this.externalBonds[i2]);
            }
            boolean useSavedIndices = false;
            if (this.savedAtomIndices != null) {
                useSavedIndices = this.savedAtomIndices.length == g.getAtomCount() * (this.multiplier - 1);
                int na = parentMol.getAtomCount();
                for (int j = this.savedAtomIndices.length - 1; j >= 0 && useSavedIndices; --j) {
                    int k = this.savedAtomIndices[j];
                    if (k < 0 || k > na) {
                        useSavedIndices = false;
                        break;
                    }
                    ++na;
                }
            }
            MoleculeGraph[] clones = new MoleculeGraph[this.multiplier - 1];
            for (int i3 = this.multiplier - 2; i3 >= 0; --i3) {
                int j;
                SelectionMolecule m = (SelectionMolecule)g.clone();
                for (j = 0; j < m.getAtomCount(); ++j) {
                    m.getAtom(j).setAttach(0);
                }
                clones[i3] = m;
                if (useSavedIndices) {
                    for (j = 0; j < m.getAtomCount(); ++j) {
                        int k = this.savedAtomIndices[(i3 + 1) * g.getAtomCount() - j - 1];
                        parentMol.insertAtom(k, m.getAtom(j));
                    }
                    parentMol.fuse(m);
                    continue;
                }
                parentMol.fuse(m);
            }
            MoleculeGraph[] units = new MoleculeGraph[this.multiplier];
            units[0] = clones[0];
            units[1] = g;
            for (int i4 = 2; i4 < this.multiplier; ++i4) {
                units[i4] = clones[i4 - 1];
            }
            int k0 = this.attachAtoms.length > 0 ? g.indexOf(this.attachAtoms[0]) : -1;
            int n = k1 = this.attachAtoms.length > 1 ? g.indexOf(this.attachAtoms[1]) : k0;
            if (this.attachAtoms.length != 0) {
                if (parentMol.getDim() != 0 && (opts & 3) == 0) {
                    this.setCoordsForExpand(units, 1, k0, k1);
                }
                for (i = 1; i < this.multiplier; ++i) {
                    MolAtom a1 = units[i - 1].getAtom(k1);
                    MolAtom a2 = units[i].getAtom(k0);
                    MolBond b = new MolBond(a1, a2, 1);
                    parentMol.add(b);
                    g.add(b);
                }
            } else if (parentMol.getDim() != 0 && (opts & 3) == 0) {
                this.setCoordsForExpand(units, 1, -1, -1);
            }
            for (i = 0; i < this.externalBonds.length && i < 2; ++i) {
                int k = g.indexOf(this.externalAttachAtomsIn[i]);
                MolAtom aout = this.externalAttachAtomsOut[i];
                MolAtom[] ains = new MolAtom[this.externalAttachAtomsIn.length];
                ains[0] = units[0].getAtom(k0);
                if (ains.length == 2) {
                    ains[1] = units[units.length - 1].getAtom(k1);
                }
                MolAtom ain = null;
                int ainsc = 0;
                for (int j = 0; j < ains.length; ++j) {
                    if (ains[j] == null) continue;
                    ++ainsc;
                }
                if (ainsc == 1) {
                    if (parentMol.getGraphUnion().contains(aout)) {
                        ain = ains[0];
                    }
                } else if (k0 == k1) {
                    if (this.externalBonds.length == 1) {
                        double dz1;
                        double dy1;
                        double dx1;
                        double dr1sq;
                        double dz0;
                        double dy0;
                        double dx0 = aout.getX() - ains[0].getX();
                        double dr0sq = dx0 * dx0 + (dy0 = aout.getY() - ains[0].getY()) * dy0 + (dz0 = aout.getZ() - ains[0].getZ()) * dz0;
                        ain = dr0sq == (dr1sq = (dx1 = aout.getX() - ains[1].getX()) * dx1 + (dy1 = aout.getY() - ains[1].getY()) * dy1 + (dz1 = aout.getZ() - ains[1].getZ()) * dz1) ? ains[0] : (dr0sq < dr1sq ? ains[0] : ains[1]);
                    } else {
                        double drsq0 = 0.0;
                        double drsq1 = 0.0;
                        MolAtom[] aouts = this.externalAttachAtomsOut;
                        for (int j = 0; j < 2; ++j) {
                            double dx = aouts[j].getX() - ains[j].getX();
                            double dy = aouts[j].getY() - ains[j].getY();
                            double dz = aouts[j].getZ() - ains[j].getZ();
                            drsq0 += dx * dx + dy * dy + dz * dz;
                            dx = aouts[j].getX() - ains[1 - j].getX();
                            dy = aouts[j].getY() - ains[1 - j].getY();
                            dz = aouts[j].getZ() - ains[1 - j].getZ();
                            drsq1 += dx * dx + dy * dy + dz * dz;
                        }
                        ain = ains[drsq0 > drsq1 ? 1 - i : i];
                    }
                } else {
                    MolAtom molAtom = k == k0 ? ains[0] : (ain = k == k1 ? ains[1] : null);
                }
                if (ain == null) continue;
                MolBond b = new MolBond(aout, ain, 1);
                parentMol.add(b);
            }
            this.externalBonds = null;
            this.externalAttachAtomsIn = null;
            this.externalAttachAtomsOut = null;
            for (i = 0; i < this.multiplier - 1; ++i) {
                int j;
                for (j = 0; j < clones[i].getAtomCount(); ++j) {
                    MolAtom a = clones[i].getAtom(j);
                    g.add(a);
                    if (a instanceof SgroupAtom) {
                        this.addChildSgroup(((SgroupAtom)a).getSgroup());
                    }
                    for (Sgroup sg = this.getParentSgroup(); sg != null; sg = sg.getParentSgroup()) {
                        sg.add(a);
                    }
                }
                for (j = 0; j < clones[i].getBondCount(); ++j) {
                    g.add(clones[i].getBond(j));
                }
            }
            this.expandedState = true;
            if (this.getXState() != 1 && (opts & 1) != 0) {
                super.setXState0(0);
                success = true;
            } else {
                success = super.expand(opts);
            }
        }
        if ((opts & 4) == 0) {
            for (int i = 0; i < this.getChildSgroupCount(); ++i) {
                Sgroup sg = this.getChildSgroup(i);
                if (!(sg instanceof Expandable)) continue;
                success = ((Expandable)((Object)sg)).expand(opts) || success;
            }
        }
        return success;
    }

    private void updateAttachAtomsForExpand() {
        int i;
        SelectionMolecule g = this.sgroupGraph;
        ArrayList<MolAtom> av = new ArrayList<MolAtom>();
        for (i = 0; i < g.getAtomCount(); ++i) {
            int j;
            MolAtom a = g.getAtom(i);
            for (j = 0; j < this.attachAtoms.length && this.attachAtoms[j] != a; ++j) {
            }
            if (j != this.attachAtoms.length) continue;
            int n = this.getRepeatingUnitAttach(a, null);
            for (int k = 0; k < n; ++k) {
                av.add(a);
            }
        }
        for (i = 0; i < this.attachAtoms.length; ++i) {
            av.add(this.attachAtoms[i]);
        }
        this.attachAtoms = new MolAtom[av.size()];
        av.toArray(this.attachAtoms);
    }

    private void setCoordsForExpand(MoleculeGraph[] units, int ix, int k0, int k1) {
        double shiftz;
        double shifty;
        double shiftx;
        MolAtom a0 = k0 >= 0 ? units[ix].getAtom(k0) : null;
        MolAtom a1 = k1 >= 0 ? units[ix].getAtom(k1) : null;
        DPoint3 p0 = this.getAttachmentLocation(k0, units[1]);
        DPoint3 p1 = this.getAttachmentLocation(k1, units[1]);
        if (a0 == a1) {
            double w;
            double minx = Double.MAX_VALUE;
            double maxx = -1.7976931348623157E308;
            for (int i = 0; i < units[ix].getAtomCount(); ++i) {
                MolAtom a = units[ix].getAtom(i);
                double x = a.getX();
                if (x < minx) {
                    minx = x;
                }
                if (!(x > maxx)) continue;
                maxx = x;
            }
            shiftx = w = maxx - minx + 1.54;
            shifty = 0.0;
            shiftz = 0.0;
        } else {
            double r01x = p1.x - p0.x;
            double r01y = p1.y - p0.y;
            double r01z = p1.z - p0.z;
            double r01 = Math.sqrt(r01x * r01x + r01y * r01y + r01z * r01z);
            if (r01 == 0.0) {
                return;
            }
            shiftx = r01x;
            shifty = r01y;
            shiftz = r01z;
        }
        for (int i = 0; i < units.length; ++i) {
            if (i == ix) continue;
            for (int j = 0; j < units[i].getAtomCount(); ++j) {
                MolAtom ax = units[ix].getAtom(j);
                MolAtom a = units[i].getAtom(j);
                a.setXYZ(ax.getX() + shiftx * (double)(i - ix), ax.getY() + shifty * (double)(i - ix), ax.getZ() + shiftz * (double)(i - ix));
            }
        }
        if (k0 >= 0 && k1 >= 0) {
            MoleculeGraph m = this.getParentMolecule().getGraphUnion();
            int[] fragIds = m.getFragIds(1);
            ArrayList<Integer> usedFragIds = new ArrayList<Integer>();
            for (int i = 0; i < this.externalAttachAtomsOut.length; ++i) {
                int kout = m.indexOf(this.externalAttachAtomsOut[i]);
                int id = kout >= 0 ? fragIds[kout] : fragIds.length;
                Integer iid = new Integer(id);
                if (usedFragIds.contains(iid)) continue;
                usedFragIds.add(iid);
                int kin = units[ix].indexOf(this.externalAttachAtomsIn[i]);
                double dx = 0.0;
                double dy = 0.0;
                double dz = 0.0;
                boolean left = false;
                boolean right = false;
                if (k0 == k1 && this.externalAttachAtomsOut.length == 2) {
                    MolAtom ax0 = this.externalAttachAtomsOut.length > 0 ? this.externalAttachAtomsOut[0] : null;
                    MolAtom ax1 = this.externalAttachAtomsOut.length > 1 ? this.externalAttachAtomsOut[1] : null;
                    boolean back = false;
                    if (ax0 != null && ax1 != null) {
                        back = (ax1.getX() - ax0.getX()) * shiftx + (ax1.getY() - ax0.getY()) * shifty + (ax1.getZ() - ax0.getZ()) * shiftz < 0.0;
                    }
                    left = !back && i == 0 || back && i == 1;
                    right = !back && i == 1 || back && i == 0;
                } else {
                    left = kin == k0;
                    boolean bl = right = kin == k1;
                }
                if (left) {
                    dx = (double)(-ix) * shiftx;
                    dy = (double)(-ix) * shifty;
                    dz = (double)(-ix) * shiftz;
                }
                if (right) {
                    dx = (double)(units.length - ix - 1) * shiftx;
                    dy = (double)(units.length - ix - 1) * shifty;
                    dz = (double)(units.length - ix - 1) * shiftz;
                }
                MultipleSgroup.translateFrag(m, fragIds, id, dx, dy, dz, units[ix]);
            }
        }
    }

    private static void translateFrag(MoleculeGraph m, int[] fragIds, int id, double dx, double dy, double dz, MoleculeGraph unit) {
        for (int j = 0; j < m.getAtomCount(); ++j) {
            MolAtom a = m.getAtom(j);
            if (fragIds[j] != id || unit.contains(a)) continue;
            a.setXYZ(a.getX() + dx, a.getY() + dy, a.getZ() + dz);
        }
    }

    private DPoint3 getAttachmentLocation(int k, MoleculeGraph u) {
        int i;
        if (k < 0) {
            return null;
        }
        MolAtom a = u.getAtom(k);
        if (this.externalAttachAtomsIn == null || this.externalAttachAtomsIn.length == 0) {
            return this.getAttachmentLocation0(a, u);
        }
        int n = i = this.externalAttachAtomsIn[0] == a ? 0 : 1;
        if (i >= this.externalAttachAtomsIn.length) {
            return this.getAttachmentLocation0(a, u);
        }
        DPoint3 p0 = this.externalAttachAtomsIn[i].getLocation();
        DPoint3 p1 = this.externalAttachAtomsOut[i].getLocation();
        return new DPoint3((p0.x + p1.x) / 2.0, (p0.y + p1.y) / 2.0, (p0.z + p1.z) / 2.0);
    }

    private DPoint3 getAttachmentLocation0(MolAtom a, MoleculeGraph u) {
        int dim = u.getDim();
        if (dim == 2) {
            return AtomBranchCoords.branch2d(a, 0.77);
        }
        if (dim == 3) {
            return AtomBranchCoords.branch3d(a, 0.77);
        }
        return a.getLocation();
    }

    private void setCoordsForContract(List v) {
        MoleculeGraph m = this.getParentMolecule().getGraphUnion();
        int[] fragIds = m.getFragIds(1);
        ArrayList<Integer> usedFragIds = new ArrayList<Integer>();
        for (int i = 0; i < v.size(); i += 3) {
            int id;
            Integer iid;
            MolAtom aout = (MolAtom)v.get(i);
            MolAtom ain = (MolAtom)v.get(i + 1);
            DPoint3 pin0 = (DPoint3)v.get(i + 2);
            double dx = ain.getX() - pin0.x;
            double dy = ain.getY() - pin0.y;
            double dz = ain.getZ() - pin0.z;
            int kout = m.indexOf(aout);
            if (kout == -1 || usedFragIds.contains(iid = new Integer(id = fragIds[kout]))) continue;
            usedFragIds.add(iid);
            for (int j = 0; j < m.getAtomCount(); ++j) {
                MolAtom a = m.getAtom(j);
                if (fragIds[j] != id || this.sgroupGraph.contains(a)) continue;
                a.setXYZ(a.getX() + dx, a.getY() + dy, a.getZ() + dz);
            }
        }
    }

    @Override
    public final boolean isExpanded() {
        return this.expandedState;
    }

    @Override
    public final boolean contract(int opts) {
        if (!this.isVisible()) {
            throw new IllegalArgumentException("cannot contract invisible group");
        }
        boolean success = false;
        if ((opts & 4) == 0) {
            for (int i = 0; i < this.getChildSgroupCount(); ++i) {
                Sgroup sg = this.getChildSgroup(i);
                if (!(sg instanceof Expandable)) continue;
                success = ((Expandable)((Object)sg)).contract(opts) || success;
            }
        }
        Molecule parentMol = this.getParentMolecule();
        if (this.expandedState) {
            int i;
            ArrayList<MolAtom> av = new ArrayList<MolAtom>();
            ArrayList<MolBond> bv = new ArrayList<MolBond>();
            for (int i2 = this.getAtomCount() - 1; i2 >= 0; --i2) {
                MolAtom a = this.getAtom(i2);
                int n = this.getRepeatingUnitAttach(a, bv);
                for (int j = 0; j < n; ++j) {
                    av.add(a);
                }
            }
            this.attachAtoms = new MolAtom[av.size()];
            av.toArray(this.attachAtoms);
            MolBond[] xbonds = this.findCrossingBonds();
            MolAtom[] xatomsIn = this.getCrossingAtoms(xbonds);
            for (i = 0; i < bv.size(); ++i) {
                MolBond b = bv.get(i);
                parentMol.removeBond(b);
            }
            for (i = 0; i < xbonds.length; ++i) {
                parentMol.removeBond(xbonds[i]);
            }
            ArrayList<Serializable> translateVec = new ArrayList<Serializable>();
            for (int i3 = 0; i3 < xbonds.length; ++i3) {
                int kout = this.sgroupGraph.indexOf(xatomsIn[i3]) % this.parentAtoms.length;
                MolAtom aout = xbonds[i3].getOtherAtom(xatomsIn[i3]);
                MolAtom ain = null;
                for (int j = 0; j < this.attachAtoms.length; ++j) {
                    int kin = this.sgroupGraph.indexOf(this.attachAtoms[j]);
                    if (kout != kin) continue;
                    ain = this.attachAtoms[j];
                    break;
                }
                if (ain == null) continue;
                translateVec.add(aout);
                translateVec.add(ain);
                translateVec.add(xatomsIn[i3].getLocation());
            }
            int savedatcount = this.getAtomCount() - this.parentAtoms.length;
            if (this.savedAtomIndices == null || this.savedAtomIndices.length != savedatcount) {
                this.savedAtomIndices = new int[savedatcount];
            }
            int isaved = 0;
            for (int i4 = this.getAtomCount() - 1; i4 >= 0; --i4) {
                MolAtom a = this.getAtom(i4);
                if (this.isRepeatingUnitAtom(a)) continue;
                this.sgroupGraph.removeAtom(i4);
                int k = parentMol.indexOf(a);
                MultipleSgroup.removeGroupedAtom(parentMol, a, null, 8);
                this.savedAtomIndices[isaved++] = k;
                for (Sgroup sg = this.getParentSgroup(); sg != null; sg = sg.getParentSgroup()) {
                    MultipleSgroup.removeAtom(sg, a, 0);
                }
            }
            if (savedatcount != isaved) {
                int[] tmp = new int[isaved];
                System.arraycopy(this.savedAtomIndices, 0, tmp, 0, isaved);
                this.savedAtomIndices = tmp;
            }
            if (parentMol.getDim() != 0) {
                this.setCoordsForContract(translateVec);
            }
            for (int i5 = 0; i5 < translateVec.size(); i5 += 3) {
                MolAtom aout = (MolAtom)translateVec.get(i5);
                MolAtom ain = (MolAtom)translateVec.get(i5 + 1);
                parentMol.add(new MolBond(ain, aout));
            }
            this.expandedState = false;
            success = super.contract(opts);
        }
        return success;
    }

    public final boolean isContracted() {
        return !this.expandedState;
    }

    @Override
    public boolean isBracketVisible() {
        return !this.expandedState;
    }

    @Override
    public String toString(int opts) {
        StringBuffer sb = new StringBuffer(super.toString(0));
        sb.append("[" + this.getMultiplier() + "*" + this.parentAtoms.length + "a,");
        sb.append(this.isExpanded() ? (char)'X' : 'C');
        if ((opts & 1) != 0) {
            sb.append("\n" + MultipleSgroup.getAtomSymbolListAsString(this.parentAtoms));
            sb.append("\n" + MultipleSgroup.getAtomSymbolListAsString(this.sgroupGraph.getAtomArray()));
        }
        sb.append("]");
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        int i;
        oos.writeByte(0);
        oos.writeInt(this.multiplier);
        oos.writeInt(this.parentAtoms.length);
        for (i = 0; i < this.parentAtoms.length; ++i) {
            oos.writeObject(this.parentAtoms[i]);
        }
        oos.writeInt(this.attachAtoms.length);
        block1: for (i = 0; i < this.attachAtoms.length; ++i) {
            MolAtom a = this.attachAtoms[i];
            for (int j = 0; j < this.parentAtoms.length; ++j) {
                if (this.parentAtoms[j] != a) continue;
                oos.writeInt(j);
                continue block1;
            }
        }
        oos.writeBoolean(this.expandedState);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        int i;
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize multiple Sgroup with future version (" + version + ")");
        }
        this.multiplier = ois.readInt();
        int n = ois.readInt();
        this.parentAtoms = new MolAtom[n];
        for (i = 0; i < n; ++i) {
            this.parentAtoms[i] = (MolAtom)ois.readObject();
        }
        n = ois.readInt();
        this.attachAtoms = new MolAtom[n];
        for (i = 0; i < n; ++i) {
            int j = ois.readInt();
            this.attachAtoms[i] = this.parentAtoms[j];
        }
        this.expandedState = ois.readBoolean();
    }
}

