/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.sgroup;

import chemaxon.struc.CTransform3D;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SgroupAtom
extends MolAtom {
    private static final long serialVersionUID = -3185634359981637075L;
    transient SuperatomSgroup sgroup;
    private transient String leftName = null;
    private transient String rightName = null;
    public static final int LABEL_DEFAULT = 0;
    public static final int LABEL_AUTO = -1;
    private int labelCenter = 0;

    public SgroupAtom(SuperatomSgroup sg) {
        super(135);
        this.sgroup = sg;
    }

    public SuperatomSgroup getSgroup() {
        return this.sgroup;
    }

    @Override
    public String getAtomSymbol(int style, int flags, int[] lcenter, CTransform3D preTransform) {
        String l = "";
        String subscript = this.sgroup.getSubscript();
        String ln = this.leftName;
        String rn = this.rightName;
        int labelDir = preTransform != null ? this.getPreferredLabelDir(preTransform, 0) : 0;
        l = this.getBondCount() > 0 ? (labelDir == 0 ? (rn != null ? rn : subscript) : (labelDir == 1 ? (ln != null ? ln : subscript) : subscript)) : subscript;
        return l;
    }

    void removeConnection(int i) {
        super.removeBond(i);
    }

    @Override
    public Object clone() {
        SgroupAtom a = new SgroupAtom(this.sgroup);
        a.xCoordinate = this.xCoordinate;
        a.yCoordinate = this.yCoordinate;
        a.zCoordinate = this.zCoordinate;
        a.set(this);
        return a;
    }

    @Override
    public void set(MolAtom atom) {
        super.set(atom);
        if (atom instanceof SgroupAtom) {
            SgroupAtom sa = (SgroupAtom)atom;
            this.sgroup = (SuperatomSgroup)sa.sgroup.cloneSgroup(null, null);
            this.sgroup.superAtom = this;
            this.leftName = sa.leftName;
            this.rightName = sa.rightName;
            this.labelCenter = sa.labelCenter;
        }
    }

    public SgroupAtom cloneFromSgroupCopy() {
        SgroupAtom a = new SgroupAtom(this.sgroup);
        a.xCoordinate = this.xCoordinate;
        a.yCoordinate = this.yCoordinate;
        a.zCoordinate = this.zCoordinate;
        a.setFromSgroupCopy(this);
        return a;
    }

    @Override
    public void transform(CTransform3D t, boolean incg) {
        super.transform(t, incg);
        this.sgroup.getSgroupGraph().transform(t, incg);
    }

    void transformAtomOnly(CTransform3D t, boolean incg) {
        super.transform(t, incg);
    }

    @Override
    public String getSymbol() {
        return this.sgroup.getSubscript();
    }

    public String getLeftName() {
        return this.leftName;
    }

    public void setLeftName(String s) {
        this.leftName = s;
    }

    public String getRightName() {
        return this.rightName;
    }

    public void setRightName(String s) {
        this.rightName = s;
    }

    public boolean hasAlternativeName() {
        return this.leftName != null || this.rightName != null;
    }

    public int getLabelCenter() {
        return this.labelCenter;
    }

    public void setLabelCenter(int k) {
        this.labelCenter = k;
    }

    protected void setFromSgroupCopy(SgroupAtom sa) {
        super.set(sa);
        this.sgroup = sa.sgroup;
        this.leftName = sa.leftName;
        this.rightName = sa.rightName;
        this.labelCenter = sa.labelCenter;
    }

    @Override
    protected void add(MolBond edge) {
        if (this.sgroup.getAtomCount() == 0) {
            super.add(edge);
        } else if (this.indexOf(edge) < 0) {
            MolAtom[] at;
            int n = this.getBondCount();
            MolAtom[] free = this.sgroup.getFreeLegalAttachAtoms();
            if (free.length == 0 && (at = this.sgroup.getAttachAtoms()).length != 0) {
                MolAtom[] tmp = new MolAtom[at.length];
                int nfree = 0;
                for (int i = 0; i < at.length; ++i) {
                    MolAtom a = at[i];
                    if (a.isBoundTo(edge.getAtom1()) || a.isBoundTo(edge.getAtom2())) continue;
                    tmp[nfree++] = a;
                }
                free = new MolAtom[nfree];
                System.arraycopy(tmp, 0, free, 0, nfree);
            }
            if (free.length == 0) {
                throw new RuntimeException("Cannot add more than " + n + " edges to " + this);
            }
            super.add(edge);
            if (n != this.getBondCount()) {
                int atch;
                MolAtom a = edge.getOtherAtom(this);
                if (a instanceof SgroupAtom) {
                    MolAtom[] free2;
                    SgroupAtom sa2 = (SgroupAtom)a;
                    SuperatomSgroup sg2 = sa2.getSgroup();
                    atch = sa2.getAttach(edge);
                    if (atch < 0 && (free2 = sg2.getFreeLegalAttachAtoms()).length > 0) {
                        atch = free2[0].getAttach();
                    }
                } else {
                    atch = a.getAttach();
                }
                for (int i = 0; i < free.length; ++i) {
                    if (free[i].getAttach() == atch) continue;
                    this.sgroup.addAttachAtom(free[i]);
                    return;
                }
                if (free.length != 0) {
                    this.sgroup.addAttachAtom(free[0]);
                }
            }
        }
    }

    private int getAttach(MolBond edge) {
        int i = this.indexOf(edge);
        if (i >= 0) {
            MolAtom a = this.sgroup.attachAtoms[i];
            return a.getAttach();
        }
        return -1;
    }

    @Override
    protected void removeBond(int i) {
        super.removeBond(i);
        this.sgroup.removeAttachAtomFromArray(i);
    }

    void bind(MolAtom[] attachAtoms, MolBond[] v) {
        for (int i = 0; i < v.length; ++i) {
            MolBond b = v[i];
            MolAtom a1 = b.getAtom1();
            if (SgroupAtom.arrayIndexOf(a1, attachAtoms) >= 0) {
                SgroupAtom.setAtom1(b, this);
            } else {
                SgroupAtom.setAtom2(b, this);
            }
            super.add(b);
        }
    }

    MolBond[] unbind(MolAtom[] attachAtoms) {
        return this.unbind(attachAtoms, 0);
    }

    MolBond[] unbind(MolAtom[] attachAtoms, int opts) {
        MolBond[] v = new MolBond[this.getBondCount()];
        for (int j = 0; j < v.length; ++j) {
            MolBond b = this.getBond(j);
            MolAtom a1 = b.getAtom1();
            MolAtom a = attachAtoms[j];
            if (a1 == this) {
                SgroupAtom.setAtom1(b, a);
                if ((opts & 0x10) != 0) {
                    a.setLocation(a1.getLocation());
                }
            } else {
                MolAtom a2 = b.getAtom2();
                SgroupAtom.setAtom2(b, a);
                if ((opts & 0x10) != 0) {
                    a.setLocation(a2.getLocation());
                }
            }
            v[j] = b;
        }
        return v;
    }

    protected static void setAtom1(MolBond edge, MolAtom newnode) {
        MolAtom.setAtom1(edge, newnode);
    }

    protected static void setAtom2(MolBond edge, MolAtom newnode) {
        MolAtom.setAtom2(edge, newnode);
    }

    @Override
    protected void removeAllBonds() {
        super.removeAllBonds();
    }

    @Override
    protected int countAllAtoms() {
        return this.sgroup.countAllAtoms();
    }

    private static int arrayIndexOf(MolAtom a, MolAtom[] attachAtoms) {
        for (int j = 0; j < attachAtoms.length; ++j) {
            if (attachAtoms[j] != a) continue;
            return j;
        }
        return -1;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.writeObject(this.sgroup);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize Sgroup superatom with future version (" + version + ")");
        }
        this.sgroup = (SuperatomSgroup)ois.readObject();
    }
}

