/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.sgroup;

import chemaxon.core.calculations.SuperatomSgroupCoords;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.Expandable;
import chemaxon.struc.sgroup.SgroupAtom;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

public class SuperatomSgroup
extends Sgroup
implements Expandable {
    private static final long serialVersionUID = 2968529752634209305L;
    private static final double COORD_TOLERANCE = 1.0E-5;
    transient MolAtom[] attachAtoms = new MolAtom[0];
    transient SgroupAtom superAtom = new SgroupAtom(this);
    private transient boolean expandedState = false;
    private transient int[] savedAtomIndices = null;

    public SuperatomSgroup(Molecule parent) {
        this(parent, true);
    }

    public SuperatomSgroup(Molecule parent, boolean expanded) {
        super(parent, 0, expanded ? 1 : 2);
        this.expandedState = expanded;
    }

    protected SuperatomSgroup(SuperatomSgroup sg, Molecule m, Sgroup psg, int[] atomIndexMap) {
        super(sg, m, psg, atomIndexMap);
        int k;
        MolAtom[] atoms = new MolAtom[sg.attachAtoms.length];
        for (int i = 0; i < sg.attachAtoms.length; ++i) {
            MolAtom a = sg.attachAtoms[i];
            int k2 = sg.sgroupGraph.indexOf(a);
            atoms[i] = this.getAtom(k2);
        }
        this.setAttachAtoms(atoms);
        this.superAtom = null;
        if (psg != null && (k = sg.getParentSgroup().indexOf(sg.superAtom)) >= 0) {
            this.superAtom = (SgroupAtom)psg.getAtom(k);
        }
        this.expandedState = sg.expandedState;
        if (m != null) {
            Molecule p = sg.getParentMolecule();
            int k3 = p != null ? p.indexOf(sg.superAtom) : -1;
            int j = -1;
            if (k3 >= 0) {
                if (atomIndexMap != null) {
                    for (int i = 0; i < atomIndexMap.length; ++i) {
                        if (atomIndexMap[i] != k3) continue;
                        j = i;
                        break;
                    }
                } else {
                    j = k3;
                }
            }
            if (j >= 0) {
                SgroupAtom sa2 = (SgroupAtom)m.getAtom(j);
                sa2.sgroup = this;
                if (this.superAtom != null && this.superAtom != sa2) {
                    throw new RuntimeException("superatom in parent S-group is different than superatom in parent molecule");
                }
                this.superAtom = sa2;
            }
        }
        if (this.superAtom == null) {
            this.superAtom = sg.superAtom.cloneFromSgroupCopy();
        }
        this.superAtom.sgroup = this;
    }

    public final SgroupAtom getSuperAtom() {
        return this.superAtom;
    }

    public final MolAtom[] getAttachAtoms() {
        MolAtom[] tmp = new MolAtom[this.attachAtoms.length];
        System.arraycopy(this.attachAtoms, 0, tmp, 0, tmp.length);
        return tmp;
    }

    private void tryToRestoreAttachAtomInfo(MolAtom a) {
        MolAtom a1 = null;
        MolAtom a2 = null;
        for (int i = 0; i < this.sgroupGraph.getAtomCount(); ++i) {
            MolAtom aa = this.sgroupGraph.getAtom(i);
            int f = aa.getAttach();
            if (f == 1 || f == 3) {
                a1 = aa;
            }
            if (f != 2 && f != 3) continue;
            a2 = aa;
        }
        if (a1 == null) {
            a.setAttach(a != a2 ? 1 : 3);
        } else {
            a.setAttach(a != a1 ? 2 : 3);
        }
    }

    public void updateAttachmentPoints() {
        if (this.isExpanded()) {
            return;
        }
        int bondCount = this.superAtom.getBondCount();
        if (this.attachAtoms.length == bondCount) {
            return;
        }
        this.attachAtoms = new MolAtom[bondCount];
        MolAtom[] atoms = this.getLegalAttachAtoms();
        if (atoms.length == 0) {
            throw new IllegalArgumentException("No attachment points are defined in " + this);
        }
        block5: for (MolAtom a : atoms) {
            switch (a.getAttach()) {
                case 1: {
                    if (bondCount < 1) continue block5;
                    this.attachAtoms[0] = a;
                    continue block5;
                }
                case 2: {
                    if (bondCount != 2) continue block5;
                    this.attachAtoms[1] = a;
                    continue block5;
                }
                case 3: {
                    if (bondCount < 1) continue block5;
                    this.attachAtoms[0] = a;
                    if (bondCount != 2) continue block5;
                    this.attachAtoms[1] = a;
                }
            }
        }
    }

    @Override
    public SelectionMolecule getSgroupGraph() {
        SelectionMolecule smol = super.getSgroupGraph();
        int n = Math.min(this.attachAtoms.length, smol.getAtomCount());
        for (int i = 0; i < n; ++i) {
            MolAtom a = this.attachAtoms[i];
            int j = smol.indexOf(a);
            if (j < 0) {
                throw new RuntimeException("invalid SuperatomSgroup: attachment atom is not in the graph");
            }
            if (i >= j) continue;
            smol.swapAtoms(i, j);
        }
        return smol;
    }

    public SelectionMolecule getParentSgroupGraph() {
        return this.sgroupGraph;
    }

    @Override
    public void setSgroupGraph(SelectionMolecule smol) {
        super.setSgroupGraph(smol);
        if (!this.expandedState) {
            MolAtom[] atoms;
            int n = this.superAtom.getBondCount();
            MolAtom doubleapo_atom = null;
            ArrayList<MolAtom> atomList = new ArrayList<MolAtom>();
            for (int i = 0; i < smol.getAtomCount(); ++i) {
                MolAtom a = smol.getAtom(i);
                int f = a.getAttach();
                if (f == 3) {
                    doubleapo_atom = a;
                    continue;
                }
                if (f != 1 && f != 2) continue;
                atomList.add(a);
            }
            if (doubleapo_atom == null && atomList.size() != n && n == 2) {
                if (smol.getAtomCount() == 1) {
                    doubleapo_atom = smol.getAtom(0);
                } else {
                    int nsameloc = 0;
                    for (int i = 0; i < smol.getAtomCount(); ++i) {
                        MolAtom aa = smol.getAtom(i);
                        if (!(Math.abs(aa.getX() - this.superAtom.getX()) < 1.0E-5) || !(Math.abs(aa.getY() - this.superAtom.getY()) < 1.0E-5) || !(Math.abs(aa.getZ() - this.superAtom.getZ()) < 1.0E-5)) continue;
                        ++nsameloc;
                        doubleapo_atom = aa;
                    }
                    if (nsameloc != 1) {
                        doubleapo_atom = null;
                    }
                }
            }
            if (atomList.size() != 0 && atomList.size() == n) {
                atoms = new MolAtom[atomList.size()];
                atomList.toArray(atoms);
            } else if (doubleapo_atom != null) {
                atoms = new MolAtom[n];
                for (int i = 0; i < n; ++i) {
                    atoms[i] = doubleapo_atom;
                }
            } else {
                atoms = new MolAtom[n];
                for (int i = 0; i < n; ++i) {
                    atoms[i] = smol.getAtom(i);
                }
            }
            this.setAttachAtoms(atoms);
        }
    }

    @Override
    protected Sgroup cloneSgroup(Molecule m, Sgroup psg, int[] atomIndexMap) {
        return new SuperatomSgroup(this, m, psg, atomIndexMap);
    }

    @Override
    public final void setAtom(int i, MolAtom a) {
        MolAtom orig = this.sgroupGraph.getAtom(i);
        super.setAtom(i, a);
        this.sgroupGraph.setAtom(i, a);
        for (int j = 0; j < this.attachAtoms.length; ++j) {
            if (this.attachAtoms[j] != orig) continue;
            this.attachAtoms[j] = a;
        }
    }

    @Override
    protected final void removeAtom(MolAtom a, int opts) {
        super.removeAtom(a, opts);
        this.removeAttachAtomFromArray(a);
    }

    @Override
    public final void removeBond(MolBond b) {
        super.removeBond(b);
        int j = this.superAtom.indexOf(b);
        if (j >= 0) {
            this.superAtom.removeConnection(j);
            MolAtom a = this.attachAtoms[j];
            this.removeAttachAtomFromArray(j);
            if (a.getAttach() == 0) {
                this.tryToRestoreAttachAtomInfo(a);
            }
        }
    }

    @Override
    public MolBond[] findCrossingBonds() {
        MolBond[] xbonds;
        if (this.expandedState) {
            xbonds = super.findCrossingBonds();
            MolAtom[] atoms = super.getCrossingAtoms(xbonds);
            SuperatomSgroup.sortAtoms(atoms, xbonds);
        } else {
            xbonds = new MolBond[this.superAtom.getBondCount()];
            for (int i = 0; i < xbonds.length; ++i) {
                xbonds[i] = this.superAtom.getBond(i);
            }
        }
        return xbonds;
    }

    @Override
    public MolAtom[] getCrossingAtoms(MolBond[] xbonds) {
        MolAtom[] atoms;
        if (this.expandedState) {
            atoms = super.getCrossingAtoms(xbonds);
        } else {
            atoms = new MolAtom[xbonds.length];
            for (int i = 0; i < xbonds.length; ++i) {
                atoms[i] = this.superAtom;
            }
        }
        return atoms;
    }

    public MolAtom findAttachAtom() {
        MolAtom a = null;
        if (this.isContracted()) {
            a = this.attachAtoms.length > 0 ? SuperatomSgroup.findMostLikelyAttachAtom(this.attachAtoms) : SuperatomSgroup.findMostLikelyAttachAtom(this.getLegalAttachAtoms());
        } else {
            MolBond[] xbonds = this.findCrossingBonds();
            if (xbonds.length != 0) {
                MolAtom[] atoms = this.getCrossingAtoms(xbonds);
                a = SuperatomSgroup.findMostLikelyAttachAtom(atoms);
            } else {
                a = SuperatomSgroup.findMostLikelyAttachAtom(this.getLegalAttachAtoms());
            }
        }
        if (a == null) {
            MolAtom[] atoms = this.getAtomArray();
            a = SuperatomSgroup.findMostLikelyAttachAtom(atoms);
        }
        return a;
    }

    @Override
    protected void transformByParent(CTransform3D t, boolean incg) {
        if (this.expandedState) {
            this.superAtom.transformAtomOnly(t, incg);
        } else {
            this.sgroupGraph.transform(t, incg);
        }
    }

    private static MolAtom findMostLikelyAttachAtom(MolAtom[] atoms) {
        MolAtom a = null;
        for (int i = 0; i < atoms.length; ++i) {
            if (!SuperatomSgroup.isMoreLikelyAttachThan(atoms[i], a)) continue;
            a = atoms[i];
        }
        return a;
    }

    private static boolean isMoreLikelyAttachThan(MolAtom a, MolAtom a0) {
        if (a0 == null) {
            return a != null;
        }
        int o0 = a0.getAttach();
        int o = a.getAttach();
        if (o0 == 0) {
            return o != 0;
        }
        if (o0 == 2) {
            return o == 1 || o == 3;
        }
        if (o0 == 3) {
            return o == 1;
        }
        return false;
    }

    @Override
    public boolean hasBrackets() {
        return this.expandedState;
    }

    @Override
    public boolean hasAtom(MolAtom a) {
        if (super.hasAtom(a)) {
            return true;
        }
        if (a instanceof SgroupAtom) {
            SgroupAtom sa = (SgroupAtom)a;
            return sa.getSgroup() == this;
        }
        return false;
    }

    @Override
    public final boolean expand(int opts) throws IllegalArgumentException {
        boolean success = false;
        if (!this.expandedState) {
            int j;
            int j2;
            Sgroup sg;
            if (!this.isVisible()) {
                throw new IllegalArgumentException("cannot expand invisible group");
            }
            Molecule parentMol = this.getParentMolecule();
            int i = parentMol.indexOf(this.superAtom);
            MolBond[] xbonds = this.superAtom.unbind(this.attachAtoms, opts);
            int[] xbondi = new int[xbonds.length];
            int[] xbondorder = SuperatomSgroup.orderBonds(xbonds, xbondi, parentMol);
            SuperatomSgroup.removeGroupedAtom(parentMol, this.superAtom, null, 0);
            for (sg = this.getParentSgroup(); sg != null; sg = sg.getParentSgroup()) {
                SuperatomSgroup.removeAtom(sg, this.superAtom, 1);
            }
            boolean useSavedIndices = false;
            if (this.savedAtomIndices != null) {
                useSavedIndices = true;
                int na = parentMol.getAtomCount();
                int ii = i;
                for (int j3 = this.savedAtomIndices.length - 1; j3 >= 0; --j3) {
                    int k = this.savedAtomIndices[j3];
                    if (k < 0 || k > na) {
                        useSavedIndices = false;
                        break;
                    }
                    if (k < ii) {
                        ++ii;
                    }
                    ++na;
                }
                useSavedIndices &= this.savedAtomIndices.length != 0 && this.savedAtomIndices[0] == ii;
            }
            if (useSavedIndices) {
                for (j2 = this.savedAtomIndices.length - 1; j2 >= 0; --j2) {
                    int k = this.savedAtomIndices[j2];
                    parentMol.insertAtom(k, this.getAtom(j2));
                }
            } else {
                if (this.getAtomCount() != 0) {
                    parentMol.insertAtom(i, this.getAtom(0));
                }
                for (j2 = 1; j2 < this.getAtomCount(); ++j2) {
                    parentMol.add(this.getAtom(j2));
                }
            }
            for (sg = this.getParentSgroup(); sg != null; sg = sg.getParentSgroup()) {
                for (j2 = 0; j2 < this.getAtomCount(); ++j2) {
                    sg.add(this.getAtom(j2));
                }
            }
            SelectionMolecule g = this.sgroupGraph;
            if (parentMol.getDim() != 0 && (opts & 2) == 0) {
                SuperatomSgroupCoords calculator = new SuperatomSgroupCoords();
                calculator.setMolecule(parentMol);
                calculator.setSgroupBonds(xbonds);
                calculator.setSgroupGraph(g);
                calculator.setOptions(opts);
                calculator.expand(this);
            }
            for (j = 0; j < g.getBondCount(); ++j) {
                parentMol.add(g.getBond(j));
            }
            for (j = 0; j < xbondorder.length; ++j) {
                int k = xbondorder[j];
                parentMol.insertBond(xbondi[k], xbonds[k]);
            }
            for (j = 0; j < this.attachAtoms.length; ++j) {
                this.attachAtoms[j].valenceCheck();
            }
            this.setAttachAtoms(new MolAtom[0]);
            this.expandedState = true;
            success = super.expand(opts);
        }
        if ((opts & 4) == 0) {
            for (int i = 0; i < this.getChildSgroupCount(); ++i) {
                Sgroup sg = this.getChildSgroup(i);
                if (!(sg instanceof Expandable)) continue;
                success = ((Expandable)((Object)sg)).expand(opts) || success;
            }
        }
        return success;
    }

    public final boolean expandOther(int opts, Molecule moltoexpand) throws IllegalArgumentException {
        boolean success = false;
        SuperatomSgroup sgtoexpand = (SuperatomSgroup)moltoexpand.getSgroup(0);
        if (!this.expandedState && sgtoexpand != null && !sgtoexpand.expandedState) {
            int k;
            int j;
            int j2;
            Sgroup sg;
            if (!this.isVisible() && !sgtoexpand.isVisible()) {
                throw new IllegalArgumentException("cannot expand invisible group");
            }
            Molecule parentMol = this.getParentMolecule();
            Molecule oParentMol = sgtoexpand.getParentMolecule();
            int i = parentMol.indexOf(this.superAtom);
            int oi = oParentMol.indexOf(sgtoexpand.superAtom);
            MolBond[] xbonds = this.superAtom.unbind(this.attachAtoms);
            MolBond[] oxbonds = sgtoexpand.superAtom.unbind(sgtoexpand.attachAtoms);
            int[] xbondi = new int[xbonds.length];
            int[] oxbondi = new int[oxbonds.length];
            int[] xbondorder = SuperatomSgroup.orderBonds(xbonds, xbondi, parentMol);
            int[] oxbondorder = SuperatomSgroup.orderBonds(oxbonds, oxbondi, oParentMol);
            SuperatomSgroup.removeGroupedAtom(parentMol, this.superAtom, null, 0);
            SuperatomSgroup.removeGroupedAtom(oParentMol, sgtoexpand.superAtom, null, 0);
            for (sg = this.getParentSgroup(); sg != null; sg = sg.getParentSgroup()) {
                SuperatomSgroup.removeAtom(sg, this.superAtom, 1);
            }
            boolean useSavedIndices = false;
            if (this.savedAtomIndices != null) {
                useSavedIndices = true;
                int na = parentMol.getAtomCount();
                int ii = i;
                for (int j3 = this.savedAtomIndices.length - 1; j3 >= 0; --j3) {
                    int k2 = this.savedAtomIndices[j3];
                    if (k2 < 0 || k2 > na) {
                        useSavedIndices = false;
                        break;
                    }
                    if (k2 < ii) {
                        ++ii;
                    }
                    ++na;
                }
                useSavedIndices &= this.savedAtomIndices[0] == ii;
            }
            if (useSavedIndices) {
                for (j2 = this.savedAtomIndices.length - 1; j2 >= 0; --j2) {
                    int k3 = this.savedAtomIndices[j2];
                    parentMol.insertAtom(k3, this.getAtom(j2));
                }
            } else {
                parentMol.insertAtom(i, this.getAtom(0));
                for (j2 = 1; j2 < this.getAtomCount(); ++j2) {
                    parentMol.add(this.getAtom(j2));
                }
                oParentMol.insertAtom(oi, sgtoexpand.getAtom(0));
                for (j2 = 1; j2 < sgtoexpand.getAtomCount(); ++j2) {
                    oParentMol.add(sgtoexpand.getAtom(j2));
                }
            }
            for (sg = this.getParentSgroup(); sg != null; sg = sg.getParentSgroup()) {
                for (j2 = 0; j2 < this.getAtomCount(); ++j2) {
                    sg.add(this.getAtom(j2));
                }
            }
            SelectionMolecule g = this.sgroupGraph;
            if (parentMol.getDim() != 0 && (opts & 2) == 0) {
                SuperatomSgroupCoords calculator = new SuperatomSgroupCoords();
                calculator.setMolecule(parentMol);
                calculator.setSgroupBonds(xbonds);
                calculator.setSgroupGraph(g);
                calculator.setOptions(opts);
                calculator.setOtherSgroup(sgtoexpand.getSgroupGraph());
                calculator.expandSgroups(this.getSuperAtom());
            }
            for (j = 0; j < g.getBondCount(); ++j) {
                parentMol.add(g.getBond(j));
            }
            for (j = 0; j < sgtoexpand.getSgroupGraph().getBondCount(); ++j) {
                oParentMol.add(sgtoexpand.getSgroupGraph().getBond(j));
            }
            for (j = 0; j < xbondorder.length; ++j) {
                k = xbondorder[j];
                parentMol.insertBond(xbondi[k], xbonds[k]);
            }
            for (j = 0; j < oxbondorder.length; ++j) {
                k = oxbondorder[j];
                oParentMol.insertBond(oxbondi[k], oxbonds[k]);
            }
            for (j = 0; j < this.attachAtoms.length; ++j) {
                this.attachAtoms[j].valenceCheck();
            }
            for (j = 0; j < sgtoexpand.attachAtoms.length; ++j) {
                sgtoexpand.attachAtoms[j].valenceCheck();
            }
            this.setAttachAtoms(new MolAtom[0]);
            this.expandedState = true;
            success = super.expand(opts);
            sgtoexpand.setAttachAtoms(new MolAtom[0]);
            sgtoexpand.expandedState = true;
        }
        return success;
    }

    @Override
    public final boolean isExpanded() {
        return this.expandedState;
    }

    @Override
    public final boolean contract(int opts) throws IllegalArgumentException {
        if (!this.isVisible()) {
            throw new IllegalArgumentException("cannot contract invisible group");
        }
        boolean success = false;
        if ((opts & 4) == 0) {
            for (int i = 0; i < this.getChildSgroupCount(); ++i) {
                Sgroup sg = this.getChildSgroup(i);
                if (!(sg instanceof Expandable) || !sg.isVisible()) continue;
                success = ((Expandable)((Object)sg)).contract(opts) || success;
            }
        }
        if (this.expandedState) {
            Molecule parentMol = this.getParentMolecule();
            MolBond[] xbonds = this.findCrossingBonds();
            this.setAttachAtoms(this.getCrossingAtoms(xbonds));
            this.superAtom.bind(this.attachAtoms, xbonds);
            int imin = parentMol.getAtomCount();
            if (this.savedAtomIndices == null || this.savedAtomIndices.length != this.getAtomCount()) {
                this.savedAtomIndices = new int[this.getAtomCount()];
            }
            MolBond[] edgeOrder = parentMol.getBondArray();
            for (int i = 0; i < this.getAtomCount(); ++i) {
                MolAtom a = this.getAtom(i);
                int k = parentMol.indexOf(a);
                if (k >= 0 && k < imin) {
                    imin = k;
                }
                this.removeGroupedAtomInContract(a, xbonds);
                this.savedAtomIndices[i] = k;
                for (Sgroup sg = this.getParentSgroup(); sg != null; sg = sg.getParentSgroup()) {
                    sg.replaceAtom(a, this.superAtom, 2);
                }
            }
            if (parentMol.getDim() != 0 && (opts & 2) == 0) {
                SuperatomSgroupCoords calculator = new SuperatomSgroupCoords();
                calculator.setMolecule(parentMol);
                calculator.setSgroupBonds(xbonds);
                calculator.setSgroupGraph(this.sgroupGraph);
                calculator.contract(this);
            }
            parentMol.insertAtom(imin, this.superAtom);
            for (Sgroup sg = this.getParentSgroup(); sg != null; sg = sg.getParentSgroup()) {
                sg.add(this.superAtom);
            }
            for (int i = 0; i < xbonds.length; ++i) {
                parentMol.insertBondInOrder(xbonds[i], edgeOrder);
            }
            this.sgroupGraph.regenBonds();
            this.sgroupGraph.sortBondsAccordingTo(edgeOrder);
            this.expandedState = false;
            success = super.contract(opts);
        }
        return success;
    }

    private void removeGroupedAtomInContract(MolAtom a, MolBond[] xbonds) {
        Molecule parentMol = this.getParentMolecule();
        SuperatomSgroup asg = a instanceof SgroupAtom ? ((SgroupAtom)a).getSgroup() : null;
        MolAtom[] savedatch = asg != null ? asg.getAttachAtoms() : null;
        SuperatomSgroup.removeGroupedAtom(parentMol, a, xbonds, 0);
        if (savedatch != null) {
            asg.setAttachAtoms(savedatch);
        }
    }

    private static int[] orderBonds(MolBond[] xbonds, int[] xbondi, MoleculeGraph m) {
        int i;
        int[] order = new int[xbonds.length];
        for (i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        for (i = 0; i < xbonds.length; ++i) {
            xbondi[i] = m.indexOf(xbonds[i]);
        }
        for (i = 0; i < xbonds.length - 1; ++i) {
            for (int j = i + 1; j < xbonds.length; ++j) {
                int bj = xbondi[order[j]];
                if (bj >= xbondi[order[i]]) continue;
                int t = order[i];
                order[i] = order[j];
                order[j] = t;
            }
        }
        return order;
    }

    public final boolean isContracted() {
        return !this.expandedState;
    }

    @Override
    public boolean isBracketVisible() {
        return false;
    }

    @Override
    public boolean isTotalSelected(MoleculeGraph sel) {
        int i;
        if (sel == null) {
            return false;
        }
        if (!this.expandedState) {
            return sel.indexOf(this.superAtom) != -1;
        }
        int nAtoms = this.getAtomCount();
        for (i = 0; i < nAtoms && sel.indexOf(this.getAtom(i)) != -1; ++i) {
        }
        return i == nAtoms;
    }

    @Override
    public boolean areChildSgroupsVisible() {
        return this.expandedState && super.areChildSgroupsVisible();
    }

    public final MolAtom[] getLegalAttachAtoms() {
        MolAtom[] tmp = new MolAtom[4];
        int n = 0;
        for (int i = 0; i < this.sgroupGraph.getAtomCount(); ++i) {
            MolAtom a = this.sgroupGraph.getAtom(i);
            int k = a.getAttach();
            if (k == 0 || tmp[k] != null) continue;
            tmp[k] = a;
            ++n;
        }
        MolAtom[] atoms = new MolAtom[n];
        int k = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i] == null) continue;
            atoms[k++] = tmp[i];
        }
        SuperatomSgroup.sortAtoms(atoms, null);
        return atoms;
    }

    public void sortXBonds() {
        MolAtom[] atoms;
        MolBond[] xbonds = this.findCrossingBonds();
        if (this.expandedState) {
            atoms = super.getCrossingAtoms(xbonds);
        } else {
            atoms = new MolAtom[this.attachAtoms.length];
            System.arraycopy(this.attachAtoms, 0, atoms, 0, atoms.length);
        }
        SuperatomSgroup.sortAtoms(atoms, xbonds);
        SuperatomSgroup.sortBondsInMol(this.getParentMolecule(), xbonds);
    }

    private static void sortBondsInMol(MoleculeGraph m, MolBond[] xbonds) {
        int n = m.getBondCount();
        int k = 0;
        for (int i = 0; i < n && k < xbonds.length; ++i) {
            int j;
            MolBond e = m.getBond(i);
            for (j = 0; j < xbonds.length && xbonds[j] != e; ++j) {
            }
            if (j >= xbonds.length) continue;
            m.setBond(i, xbonds[k]);
            ++k;
        }
    }

    private static void sortAtoms(MolAtom[] atoms, MolBond[] xbonds) {
        int n = atoms.length;
        for (int i = 0; i < n - 1; ++i) {
            MolAtom a1 = atoms[i];
            for (int j = i + 1; j < n; ++j) {
                if (!SuperatomSgroup.isBetterAPO(atoms[j], a1)) continue;
                atoms[i] = atoms[j];
                atoms[j] = a1;
                a1 = atoms[i];
                if (xbonds == null) continue;
                SuperatomSgroup.swap(xbonds, i, j);
            }
        }
    }

    private static boolean isBetterAPO(MolAtom atom1, MolAtom atom2) {
        int a1 = atom1.getAttach();
        int a2 = atom2.getAttach();
        return a1 != 0 && a2 == 0 || a1 == 1 || a1 == 2 && a2 != 1;
    }

    private static void swap(MolBond[] bonds, int i, int j) {
        MolBond b = bonds[i];
        bonds[i] = bonds[j];
        bonds[j] = b;
    }

    public final boolean isLegalAttachment(MolAtom a) {
        MolAtom[] legal = this.getLegalAttachAtoms();
        boolean found = false;
        for (int j = 0; j < legal.length && !found; ++j) {
            if (!legal[j].isBoundTo(a)) continue;
            return true;
        }
        return false;
    }

    public final boolean isFreeLegalAttachAtom(MolAtom a) {
        int k = a.getAttach();
        if (k == 0) {
            return false;
        }
        int nx = this.getExternalConnections(a);
        if (nx > 1 || nx == 1 && k != 3) {
            return false;
        }
        int na = 0;
        for (int j = 0; j < this.attachAtoms.length; ++j) {
            if (this.attachAtoms[j] != a) continue;
            ++na;
        }
        return k == 3 && na == 1 || na == 0;
    }

    public int getExternalConnections(MolAtom a) {
        int nx = 0;
        for (int j = 0; j < a.getBondCount(); ++j) {
            MolAtom aa = a.getLigand(j);
            if (this.indexOf(aa) >= 0) continue;
            ++nx;
        }
        return nx;
    }

    public final MolAtom[] getFreeLegalAttachAtoms() {
        MolAtom[] tmp = this.getLegalAttachAtoms();
        int n = tmp.length;
        for (int i = 0; i < tmp.length; ++i) {
            MolAtom a = tmp[i];
            if (this.isFreeLegalAttachAtom(a)) continue;
            tmp[i] = null;
            --n;
        }
        MolAtom[] atoms = new MolAtom[n];
        int j = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i] == null) continue;
            atoms[j++] = tmp[i];
        }
        return atoms;
    }

    @Override
    public Molecule createMolecule() {
        int i;
        Molecule m = new Molecule();
        SuperatomSgroup sg = (SuperatomSgroup)super.createMolecule(m);
        MolBond[] xbonds = this.findCrossingBonds();
        MolAtom[] xatoms = this.getCrossingAtoms(xbonds);
        boolean[] visited = new boolean[xatoms.length];
        boolean[] used = new boolean[4];
        for (int i2 = 0; i2 < this.sgroupGraph.getAtomCount(); ++i2) {
            MolAtom a = this.sgroupGraph.getAtom(i2);
            used[a.getAttach()] = true;
        }
        int k = used[1] ? (used[2] ? 3 : 2) : 1;
        for (i = 0; i < xatoms.length; ++i) {
            xatoms[i] = sg.getAtom(this.indexOf(xatoms[i]));
        }
        block2: for (i = 0; i < xatoms.length; ++i) {
            int j;
            MolAtom a = xatoms[i];
            if (visited[i]) continue;
            visited[i] = true;
            int n = 1;
            for (j = 0; j < xatoms.length; ++j) {
                if (visited[j] || xatoms[j] != a) continue;
                visited[j] = true;
                ++n;
            }
            if (a.getAttach() != 0) continue;
            if (n > 1) {
                a.setAttach(3, sg);
            } else if (k <= 2) {
                a.setAttach(k, sg);
                if (used[++k]) {
                    k = 3;
                }
            }
            if (this.expandedState || a.getAttach() == 0) continue;
            for (j = 0; j < sg.attachAtoms.length; ++j) {
                if (sg.attachAtoms[j] == a) continue block2;
            }
            sg.addAttachAtom(a);
        }
        return m;
    }

    protected void addAttachAtom(MolAtom a) {
        MolAtom[] tmp = new MolAtom[this.attachAtoms.length + 1];
        System.arraycopy(this.attachAtoms, 0, tmp, 0, this.attachAtoms.length);
        tmp[this.attachAtoms.length] = a;
        this.setAttachAtoms(tmp);
    }

    private void setAttachAtoms(MolAtom[] a) {
        this.attachAtoms = a;
    }

    private void removeAttachAtomFromArray(MolAtom a) {
        int n = this.attachAtoms.length;
        for (int i = n - 1; i >= 0; --i) {
            if (this.attachAtoms[i] != a) continue;
            this.removeAttachAtomFromArray(i);
        }
    }

    void removeAttachAtomFromArray(int i) {
        int n = this.attachAtoms.length;
        if (i < n - 1) {
            System.arraycopy(this.attachAtoms, i + 1, this.attachAtoms, i, n - 1 - i);
        }
        MolAtom[] tmp = new MolAtom[--n];
        System.arraycopy(this.attachAtoms, 0, tmp, 0, n);
        this.setAttachAtoms(tmp);
    }

    @Override
    public final void replaceAtom(MolAtom olda, MolAtom newa, int opts) {
        super.replaceAtom(olda, newa, opts);
        if (this.attachAtoms != null && (opts & 2) == 0) {
            for (int i = 0; i < this.attachAtoms.length; ++i) {
                if (this.attachAtoms[i] != olda) continue;
                this.attachAtoms[i] = newa;
            }
        }
    }

    public final MolBond[] updateSgroupCrossings() {
        MolBond[] crossingBonds = this.findCrossingBonds();
        this.setAttachAtoms(this.getCrossingAtoms(crossingBonds));
        return crossingBonds;
    }

    @Override
    public String toString(int opts) {
        String s = super.toString(0);
        if ((opts & 1) != 0) {
            return s + "[" + this.getSubscript() + (this.isExpanded() ? ",X:" : ",C:") + ":" + SuperatomSgroup.getAtomSymbolListAsString(this.sgroupGraph.getAtomArray()) + "]";
        }
        return s + "[" + this.getSubscript() + (this.isExpanded() ? ",X]" : ",C]");
    }

    @Override
    public final boolean setGUIStateRecursively(boolean v) throws IllegalArgumentException {
        Sgroup parent;
        boolean changed = super.setGUIStateRecursively(v);
        if (v && this.isContracted() && parent != null) {
            for (parent = this.getParentSgroup(); parent != null; parent = parent.getParentSgroup()) {
                if (parent.indexOf(this.superAtom) != -1) continue;
                parent.add(this.superAtom);
            }
        }
        return changed;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(1);
        oos.writeInt(this.attachAtoms.length);
        for (int i = 0; i < this.attachAtoms.length; ++i) {
            oos.writeObject(this.attachAtoms[i]);
        }
        oos.writeObject(this.superAtom);
        oos.writeBoolean(this.expandedState);
        int nsavi = this.savedAtomIndices != null ? this.savedAtomIndices.length : 0;
        oos.writeInt(nsavi);
        for (int i = 0; i < nsavi; ++i) {
            oos.writeInt(this.savedAtomIndices[i]);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        int nsavi;
        byte version = ois.readByte();
        if (version > 1) {
            throw new IOException("Cannot deserialize superatom Sgroup with future version (" + version + ")");
        }
        int n = ois.readInt();
        this.attachAtoms = new MolAtom[n];
        for (int i = 0; i < n; ++i) {
            this.attachAtoms[i] = (MolAtom)ois.readObject();
        }
        this.superAtom = (SgroupAtom)ois.readObject();
        this.expandedState = ois.readBoolean();
        if (version > 0 && (nsavi = ois.readInt()) > 0) {
            this.savedAtomIndices = new int[nsavi];
            for (int i = 0; i < nsavi; ++i) {
                this.savedAtomIndices[i] = ois.readInt();
            }
        }
    }
}

