/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.toxic;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.util.ChemaxonException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ToxicRiskCalculator {
    public static final int ALL_HYDROGENS = 0;
    public static final int NONE_HYDROGENS = 1;
    public static final int HETERO_HYDROGENS = 2;
    public static final String PROPERTY_KEY_TOXICOPHORES = "TOXICOPHORES";
    public static final String SMILES_OUTPUT_FORMAT = "smiles:qTTOXIC_PERCENTAGE:TOXICOPHORES";
    private int hydrogenMode = 0;

    public List<Molecule> calculateToxicRiskList(InputStream toxicophoreInput, InputStream metabolicInput) throws IOException, ChemaxonException {
        ArrayList<Molecule> toxicRiskList = new ArrayList<Molecule>();
        HashMap<String, Molecule> toxicophores = new HashMap<String, Molecule>();
        this.createToxicophoreMap(toxicophoreInput, toxicophores);
        this.calculateToxicRiskList(metabolicInput, toxicRiskList, toxicophores);
        return toxicRiskList;
    }

    public List calculateToxicRiskList(List toxicophoreList, InputStream metabolicInput) throws IOException, ChemaxonException {
        ArrayList<Molecule> toxicRiskList = new ArrayList<Molecule>();
        HashMap<String, Molecule> toxicophores = new HashMap<String, Molecule>();
        this.createToxicophoreMap(toxicophoreList, toxicophores);
        this.calculateToxicRiskList(metabolicInput, toxicRiskList, toxicophores);
        return toxicRiskList;
    }

    private void calculateToxicRiskList(InputStream metabolicInput, List<Molecule> toxicRiskList, Map toxicophores) throws IOException, MolFormatException, SearchException {
        Molecule tempMol;
        MolImporter importer = new MolImporter(metabolicInput);
        while ((tempMol = importer.read()) != null) {
            ByteArrayOutputStream toxicFragments = new ByteArrayOutputStream();
            MolExporter exporter = new MolExporter(toxicFragments, "mrv");
            MolSearch search = new MolSearch();
            search.setTarget(tempMol);
            float toxicRisk = 0.0f;
            for (String key : toxicophores.keySet()) {
                Molecule query = (Molecule)toxicophores.get(key);
                search.setQuery(query);
                if (search.findFirst() == null) continue;
                String risk = query.getProperty("TOXIC_PERCENTAGE");
                float newRisk = Float.parseFloat(risk);
                toxicRisk = toxicRisk < newRisk ? newRisk : toxicRisk;
                exporter.write(query);
            }
            exporter.close();
            tempMol.setProperty(PROPERTY_KEY_TOXICOPHORES, toxicFragments.toString());
            tempMol.setProperty("TOXIC_PERCENTAGE", String.valueOf(toxicRisk));
            toxicRiskList.add(tempMol);
        }
    }

    private void createToxicophoreMap(List toxicophoreList, Map<String, Molecule> toxicophores) {
        for (Molecule tempMol : toxicophoreList) {
            this.putMoleculeIntoToxicophoreMap(toxicophores, tempMol);
        }
    }

    private void createToxicophoreMap(InputStream toxicophoreInput, Map<String, Molecule> toxicophores) throws IOException, MolFormatException {
        Molecule tempMol;
        MolImporter importer = new MolImporter(toxicophoreInput);
        while ((tempMol = importer.read()) != null) {
            this.putMoleculeIntoToxicophoreMap(toxicophores, tempMol);
        }
        importer.close();
    }

    private void putMoleculeIntoToxicophoreMap(Map<String, Molecule> toxicophores, Molecule tempMol) {
        if (this.hydrogenMode == 1) {
            tempMol.implicitizeHydrogens(2047);
        } else if (this.hydrogenMode == 2) {
            MolBond[] bonds = tempMol.getBondArray();
            for (int i = 0; i < bonds.length; ++i) {
                if (bonds[i].getAtom1().getAtno() == 6 && bonds[i].getAtom2().getAtno() == 1) {
                    tempMol.removeBond(bonds[i]);
                    tempMol.removeAtom(bonds[i].getAtom2());
                    continue;
                }
                if (bonds[i].getAtom1().getAtno() != 1 || bonds[i].getAtom2().getAtno() != 6) continue;
                tempMol.removeBond(bonds[i]);
                tempMol.removeAtom(bonds[i].getAtom1());
            }
        }
        toxicophores.put(tempMol.toFormat("smiles:q"), tempMol);
    }

    public Molecule[] calculateToxicRisk(InputStream toxicophoreInput, InputStream metabolicInput) throws IOException, ChemaxonException {
        List<Molecule> fragments = this.calculateToxicRiskList(toxicophoreInput, metabolicInput);
        return fragments.toArray(new Molecule[fragments.size()]);
    }

    public int getHydrogenMode() {
        return this.hydrogenMode;
    }

    public void setHydrogenMode(int mode) {
        this.hydrogenMode = mode;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            ToxicRiskCalculator.printHelp();
            return;
        }
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) continue;
            if (!ToxicRiskCalculator.isSwitchCorrect(args[i])) {
                ToxicRiskCalculator.printHelp();
                return;
            }
            set.add(args[i]);
        }
        if (args.length > 0 && !ToxicRiskCalculator.containsAllNeededSwitch(set)) {
            ToxicRiskCalculator.printHelp();
            return;
        }
        InputStream metabolicInput = System.in;
        FileInputStream toxicophoreInput = null;
        OutputStream output = System.out;
        OutputStream logStream = System.err;
        int hydrogenMode = 0;
        String outputFormat = SMILES_OUTPUT_FORMAT;
        for (int i = 0; i < args.length; ++i) {
            File inputFile;
            if (args[i].equals("-t")) {
                inputFile = new File(args[i + 1]);
                if (!inputFile.exists()) {
                    System.err.println("Error: toxicophore library file does not exists");
                } else {
                    try {
                        toxicophoreInput = new FileInputStream(inputFile);
                    }
                    catch (IOException exception) {
                        System.err.println("Error: can't read toxicophore library");
                        exception.printStackTrace(System.err);
                        return;
                    }
                }
                ++i;
                continue;
            }
            if (args[i].equals("-i")) {
                if (args[i + 1].equals("all")) {
                    hydrogenMode = 0;
                } else if (args[i + 1].equals("none")) {
                    hydrogenMode = 1;
                } else if (args[i + 1].equals("hetero")) {
                    hydrogenMode = 2;
                }
                ++i;
                continue;
            }
            if (args[i].equals("-f")) {
                outputFormat = args[i + 1].equals("smiles") ? SMILES_OUTPUT_FORMAT : args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-o")) {
                File outputFile = new File(args[i + 1]);
                try {
                    output = new FileOutputStream(outputFile);
                }
                catch (FileNotFoundException exception) {
                    System.err.println("Warning: can't open output file");
                    exception.printStackTrace(System.err);
                    output = System.out;
                }
                ++i;
                continue;
            }
            if (args[i].equals("-l")) {
                File logFile = new File(args[i + 1]);
                try {
                    logStream = new FileOutputStream(logFile, logFile.exists());
                }
                catch (FileNotFoundException exception) {
                    System.err.println("Warning: can't open log file");
                    exception.printStackTrace(System.err);
                    logStream = System.err;
                }
                ++i;
                continue;
            }
            inputFile = new File(args[i]);
            if (!inputFile.exists()) continue;
            try {
                metabolicInput = new FileInputStream(inputFile);
                continue;
            }
            catch (FileNotFoundException exception) {
                System.err.println("Warning: can't open input file");
                exception.printStackTrace(System.err);
                metabolicInput = System.in;
            }
        }
        PrintWriter logWriter = new PrintWriter(logStream);
        PrintWriter outputWriter = new PrintWriter(output);
        ToxicRiskCalculator riskCalculator = new ToxicRiskCalculator();
        riskCalculator.setHydrogenMode(hydrogenMode);
        try {
            Molecule[] molecules = riskCalculator.calculateToxicRisk(toxicophoreInput, metabolicInput);
            MolExporter exporter = new MolExporter(output, outputFormat);
            for (int i = 0; i < molecules.length; ++i) {
                exporter.write(molecules[i]);
            }
            exporter.close();
        }
        catch (IOException exception) {
            exception.printStackTrace(logWriter);
            return;
        }
        catch (ChemaxonException chemaxonException) {
            chemaxonException.printStackTrace(logWriter);
            return;
        }
        outputWriter.flush();
        outputWriter.close();
        logWriter.flush();
        logWriter.close();
        try {
            ((InputStream)toxicophoreInput).close();
            metabolicInput.close();
            output.close();
            logStream.close();
        }
        catch (IOException exception) {
            // empty catch block
        }
    }

    private static boolean isSwitchCorrect(String switchString) {
        return switchString.equals("-t") || switchString.equals("-o") || switchString.equals("-l") || switchString.equals("-f") || switchString.equals("-i");
    }

    private static boolean containsAllNeededSwitch(Set set) {
        return set.contains("-t");
    }

    private static void printHelp() {
        System.out.println("ToxicRiskCalculator");
        System.out.println("Usage:");
        System.out.println("[substrate <smiles/file>] -t <toxicophores> [-i <all/none/hetero>] [-f format] [-o outputfile] [-l logfile]");
    }
}

