/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class BackTrack
implements Enumeration,
Cloneable {
    private int[] domainLengths;
    private int[] currentIdx;
    private int[] ret;
    private boolean end = false;

    public BackTrack(int[][] domain) {
        this.domainLengths = new int[domain.length];
        for (int i = 0; i < domain.length; ++i) {
            this.domainLengths[i] = domain[i].length;
        }
        this.init();
    }

    public BackTrack(int[] domainLengths) {
        this.domainLengths = domainLengths;
        this.init();
    }

    private void init() {
        if (this.domainLengths == null || this.domainLengths.length == 0) {
            this.end = true;
            return;
        }
        this.end = false;
        for (int i = 0; i < this.domainLengths.length; ++i) {
            if (this.domainLengths[i] != 0) continue;
            this.end = true;
            return;
        }
        this.currentIdx = new int[this.domainLengths.length];
        this.ret = new int[this.domainLengths.length];
    }

    private boolean step() {
        int last;
        if (this.end) {
            return false;
        }
        int n = last = this.domainLengths.length - 1;
        this.currentIdx[n] = this.currentIdx[n] + 1;
        int i = last;
        while (i >= 0 && this.currentIdx[i] >= this.domainLengths[i]) {
            this.currentIdx[i] = 0;
            if (--i < 0) continue;
            int n2 = i;
            this.currentIdx[n2] = this.currentIdx[n2] + 1;
        }
        if (i < 0) {
            this.end = true;
        }
        return !this.end;
    }

    @Override
    public boolean hasMoreElements() {
        return !this.end;
    }

    public Object nextElement() {
        if (this.end) {
            throw new NoSuchElementException();
        }
        System.arraycopy(this.currentIdx, 0, this.ret, 0, this.currentIdx.length);
        this.step();
        return this.ret;
    }

    public Object clone() throws CloneNotSupportedException {
        BackTrack other = (BackTrack)super.clone();
        other.init();
        return other;
    }
}

