/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

public class BinarySearch {
    private BinarySearch() {
    }

    public static synchronized int intSearch(int[] v, int size, int toBeFound) {
        if (v == null) {
            throw new IllegalArgumentException("null arg");
        }
        int low = 0;
        int high = size - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int c = toBeFound - v[mid];
            if (c < 0) {
                high = mid - 1;
                continue;
            }
            if (c > 0) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public static synchronized int intSearchInInterval(int[] v, int low, int high, int toBeFound) {
        if (low >= high) {
            return low;
        }
        if (v == null) {
            throw new IllegalArgumentException("null arg");
        }
        if (low < 0 || low >= v.length) {
            throw new IllegalArgumentException("low: index out of range.");
        }
        if (high < 0 || high > v.length) {
            throw new IllegalArgumentException("high: index out of range.");
        }
        int low1 = low;
        int high1 = high - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int c = toBeFound - v[mid];
            if (c < 0) {
                high = mid - 1;
                continue;
            }
            if (c > 0) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return low;
    }
}

