/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.util.BadExpressionException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class BooleanParser {
    private static boolean isTrue(String s) throws BadExpressionException {
        if ((s = s.trim().toUpperCase()).equals("TRUE")) {
            return true;
        }
        if (s.equals("FALSE")) {
            return false;
        }
        throw new BadExpressionException();
    }

    private static String notSt(String t1) throws BadExpressionException {
        if (!BooleanParser.isTrue(t1)) {
            return "true";
        }
        return "false";
    }

    private static String andSt(String t1, String t2) throws BadExpressionException {
        if (BooleanParser.isTrue(t1) && BooleanParser.isTrue(t2)) {
            return "true";
        }
        return "false";
    }

    private static String orSt(String t1, String t2) throws BadExpressionException {
        if (BooleanParser.isTrue(t1) || BooleanParser.isTrue(t2)) {
            return "true";
        }
        return "false";
    }

    private static String xorSt(String t1, String t2) throws BadExpressionException {
        if (BooleanParser.isTrue(t1) == BooleanParser.isTrue(t2)) {
            return "true";
        }
        return "false";
    }

    public static int opNum(String s) {
        if (s == null) {
            return -1;
        }
        if (s.length() == 0) {
            return -1;
        }
        if ((s = s.toUpperCase()).equals("NOT")) {
            return 0;
        }
        if (s.equals("AND")) {
            return 1;
        }
        if (s.equals("OR")) {
            return 2;
        }
        if (s.equals("XOR")) {
            return 3;
        }
        return -1;
    }

    private static String solve(String s) throws BadExpressionException {
        String newSt;
        String prev;
        String next;
        String curr;
        int x;
        ArrayList ref = new ArrayList();
        String statement = new String();
        int p = 0;
        int l = 0;
        while ((l = s.indexOf(40, p)) >= p) {
            int lnum = 1;
            int rnum = 0;
            int r = l;
            do {
                if (s.charAt(++r) == '(') {
                    ++lnum;
                }
                if (s.charAt(r) == ')') {
                    ++rnum;
                }
                if (r != s.length() - 1 || lnum == rnum) continue;
                throw new BadExpressionException();
            } while (lnum != rnum && r < s.length());
            if (r == l + 1) {
                throw new BadExpressionException();
            }
            String oldPart = s.substring(l + 1, r);
            String s1 = s.substring(0, l);
            String s2 = s.substring(r + 1);
            s = s1 + BooleanParser.solve(oldPart);
            p = s.length();
            s = s + " " + s2;
        }
        ArrayList<String> words = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            words.add(token);
        }
        for (x = words.size() - 1; x >= 0; --x) {
            curr = (String)words.get(x);
            if (BooleanParser.opNum(curr) != 0) continue;
            if (x == words.size() - 1) {
                throw new BadExpressionException();
            }
            next = (String)words.get(x + 1);
            if (BooleanParser.opNum(next) >= 0) {
                throw new BadExpressionException();
            }
            String newSt2 = BooleanParser.notSt(next);
            words.set(x, newSt2);
            words.remove(x + 1);
        }
        for (x = words.size() - 1; x >= 0; --x) {
            curr = (String)words.get(x);
            if (BooleanParser.opNum(curr) != 1) continue;
            if (x == words.size() - 1) {
                throw new BadExpressionException();
            }
            if (x == 0) {
                throw new BadExpressionException();
            }
            next = (String)words.get(x + 1);
            prev = (String)words.get(x - 1);
            if (BooleanParser.opNum(next) >= 0) {
                throw new BadExpressionException();
            }
            if (BooleanParser.opNum(next) >= 0) {
                throw new BadExpressionException();
            }
            newSt = BooleanParser.andSt(prev, next);
            words.set(x - 1, newSt);
            words.remove(x + 1);
            words.remove(x);
        }
        for (x = words.size() - 1; x >= 0; --x) {
            curr = (String)words.get(x);
            if (BooleanParser.opNum(curr) != 2 && BooleanParser.opNum(curr) != 3) continue;
            if (x == words.size() - 1) {
                throw new BadExpressionException();
            }
            if (x == 0) {
                throw new BadExpressionException();
            }
            next = (String)words.get(x + 1);
            prev = (String)words.get(x - 1);
            if (BooleanParser.opNum(next) >= 0) {
                throw new BadExpressionException();
            }
            if (BooleanParser.opNum(next) >= 0) {
                throw new BadExpressionException();
            }
            newSt = null;
            newSt = BooleanParser.opNum(curr) == 2 ? BooleanParser.orSt(prev, next) : BooleanParser.xorSt(prev, next);
            words.set(x - 1, newSt);
            words.remove(x + 1);
            words.remove(x);
        }
        if (words.size() != 1) {
            throw new BadExpressionException();
        }
        statement = " " + (String)words.get(0) + " ";
        return statement;
    }

    public static boolean booleanValue(String expression) throws BadExpressionException {
        String result = BooleanParser.solve(expression);
        return BooleanParser.isTrue(result);
    }

    public static void main(String[] args) {
        if (args.length > 1) {
            System.err.println("Too many arguments");
            System.exit(1);
        }
        String expression = args.length == 1 ? args[0] : "not(true and (false or true) )";
        String result = null;
        System.out.println("The expression to solve: " + expression);
        try {
            result = BooleanParser.solve(expression);
        }
        catch (BadExpressionException ex) {
            System.err.println("Please check your expression.");
            System.exit(1);
        }
        System.out.println("The result: " + result);
    }
}

