/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import java.io.Serializable;
import java.util.NoSuchElementException;

public class BooleanVector
implements Cloneable,
Serializable {
    public boolean[] elementData;
    protected int elementCount;
    protected int capacityIncrement;

    public BooleanVector(int initialCapacity, int capacityIncrement) {
        this.elementData = new boolean[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public BooleanVector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public BooleanVector() {
        this(10);
    }

    public final synchronized void copyInto(boolean[] anArray) {
        int i = this.elementCount;
        while (i-- > 0) {
            anArray[i] = this.elementData[i];
        }
    }

    public final boolean[] toArray() {
        boolean[] anArray = new boolean[this.elementCount];
        this.copyInto(anArray);
        return anArray;
    }

    public final synchronized void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.elementCount < oldCapacity) {
            boolean[] oldData = this.elementData;
            this.elementData = new boolean[this.elementCount];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int minCapacity) {
        if (minCapacity > this.elementData.length) {
            this.ensureCapacityHelper(minCapacity);
        }
    }

    private void ensureCapacityHelper(int minCapacity) {
        int newCapacity;
        int oldCapacity = this.elementData.length;
        boolean[] oldData = this.elementData;
        int n = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 2;
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this.elementData = new boolean[newCapacity];
        System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
    }

    public final synchronized void setSize(int newSize) {
        if (newSize > this.elementCount && newSize > this.elementData.length) {
            this.ensureCapacityHelper(newSize);
        } else {
            for (int i = newSize; i < this.elementCount; ++i) {
                this.elementData[i] = false;
            }
        }
        this.elementCount = newSize;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final boolean contains(boolean elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public final int indexOf(boolean elem) {
        return this.indexOf(elem, 0);
    }

    public final synchronized int indexOf(boolean elem, int index) {
        for (int i = index; i < this.elementCount; ++i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(boolean elem) {
        return this.lastIndexOf(elem, this.elementCount - 1);
    }

    public final synchronized int lastIndexOf(boolean elem, int index) {
        for (int i = index; i >= 0; --i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final synchronized boolean elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        try {
            return this.elementData[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
    }

    public final synchronized boolean firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final synchronized boolean lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final synchronized void setElementAt(boolean obj, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        this.elementData[index] = obj;
    }

    public final synchronized void removeElementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
    }

    public final synchronized void insertElementAt(boolean obj, int index) {
        int newcount = this.elementCount + 1;
        if (index >= newcount) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.elementCount);
        }
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    public final synchronized void addElement(boolean obj) {
        int newcount = this.elementCount + 1;
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        this.elementData[this.elementCount++] = obj;
    }

    public final synchronized boolean removeElement(boolean obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        this.elementCount = 0;
    }

    public synchronized Object clone() {
        try {
            BooleanVector v = (BooleanVector)super.clone();
            v.elementData = new boolean[this.elementCount];
            System.arraycopy(this.elementData, 0, v.elementData, 0, this.elementCount);
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

