/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

public class CmdLine {
    private String[] args = null;
    private int[] paramCount = null;
    private int[] blockBegin = null;
    private int[] blockEnd = null;
    private int lockPointer = 0;

    public CmdLine(String[] args) {
        this.args = args;
        this.paramCount = new int[args.length];
        for (int i = 0; i < args.length; ++i) {
            this.paramCount[i] = -1;
        }
        this.blockBegin = new int[5];
        this.blockEnd = new int[5];
        this.blockBegin[this.lockPointer] = 0;
        this.blockEnd[this.lockPointer] = args.length;
    }

    public boolean isEmpty() {
        return this.args.length == 0;
    }

    public boolean lockDynamicBlock(char shortForm, String longForm) {
        int first = this.findFirst(shortForm, longForm);
        if (first != -1) {
            int next = this.findBehind(shortForm, longForm, first + 1);
            this.blockBegin[++this.lockPointer] = first;
            this.blockEnd[this.lockPointer] = next != -1 ? next : this.blockEnd[this.lockPointer - 1];
        }
        return first != -1;
    }

    public void unlockDynamicBlock() {
        --this.lockPointer;
    }

    public String getFileName(int pos) throws CmdLineException {
        if (pos >= this.args.length) {
            throw new CmdLineException("Position out of range");
        }
        if (!this.isParam(pos)) {
            return null;
        }
        this.paramCount[pos] = 0;
        return this.args[pos];
    }

    public String getCommand(int pos) throws CmdLineException {
        if (pos >= this.args.length) {
            throw new CmdLineException("Position out of range");
        }
        if (!this.isParam(pos)) {
            return null;
        }
        int pc = 0;
        while (pos + pc + 1 < this.args.length && this.isParam(pos + pc + 1)) {
            ++pc;
        }
        this.paramCount[pos] = pc;
        return this.args[pos];
    }

    public String getString(int pos) throws CmdLineException {
        if (pos >= this.args.length) {
            throw new CmdLineException("Position out of range");
        }
        this.paramCount[pos] = 0;
        return this.args[pos];
    }

    public int getInt(int pos) throws CmdLineException {
        if (pos >= this.args.length) {
            throw new CmdLineException("Position out of range");
        }
        this.paramCount[pos] = 0;
        try {
            return Integer.parseInt(this.args[pos]);
        }
        catch (NumberFormatException nfe) {
            throw new CmdLineException("Incorrect value " + this.args[pos] + " in argument " + (pos + 1) + ", should be integer");
        }
    }

    public double getDouble(int pos) throws CmdLineException {
        if (pos >= this.args.length) {
            throw new CmdLineException("Position out of range");
        }
        this.paramCount[pos] = 0;
        try {
            return Double.parseDouble(this.args[pos]);
        }
        catch (NumberFormatException nfe) {
            throw new CmdLineException("Incorrect value " + this.args[pos] + " in argument " + (pos + 1) + ", should be double");
        }
    }

    public float getFloat(int pos) throws CmdLineException {
        if (pos >= this.args.length) {
            throw new CmdLineException("Position out of range");
        }
        this.paramCount[pos] = 0;
        try {
            return Float.parseFloat(this.args[pos]);
        }
        catch (NumberFormatException nfe) {
            throw new CmdLineException("Incorrect value " + this.args[pos] + " in argument " + (pos + 1) + ", should be float");
        }
    }

    public String getParamString(char shortForm, String longForm) {
        int p = this.find(shortForm, longForm, 1, 1);
        if (p == -1) {
            return null;
        }
        return this.args[p + 1];
    }

    public String getUnused() {
        this.lockPointer = 0;
        for (int i = this.blockBegin[this.lockPointer]; i < this.blockEnd[this.lockPointer]; ++i) {
            if (this.paramCount[i] != -1) continue;
            this.paramCount[i] = 0;
            return this.args[i];
        }
        return null;
    }

    public int countFlag(char shortForm, String longForm) {
        int counter = 0;
        int pos = this.findFirst(shortForm, longForm);
        while (pos != -1) {
            ++counter;
            pos = this.findBehind(shortForm, longForm, pos + 1);
        }
        return counter;
    }

    public int getParamCount(int pos) {
        if (pos >= this.args.length) {
            throw new CmdLineException("Position out of range");
        }
        return this.paramCount[pos];
    }

    public int find(char shortForm, String longForm) {
        int pos = this.findFirst(shortForm, longForm);
        if (pos != -1) {
            this.paramCount[pos] = 0;
        }
        return pos;
    }

    public int find(char shortForm, String longForm, int minParamCount, int maxParamCount) {
        if (maxParamCount == -1) {
            maxParamCount = this.args.length;
        }
        int pos = this.findFirst(shortForm, longForm);
        while (pos != -1) {
            int pc;
            for (pc = 0; pc < maxParamCount && this.isParam(pos + 1 + pc); ++pc) {
            }
            if (minParamCount <= pc && pc <= maxParamCount) {
                this.paramCount[pos] = pc;
                for (int pi = 0; pi < pc; ++pi) {
                    this.paramCount[pos + 1 + pi] = 0;
                }
                break;
            }
            pos = this.findBehind(shortForm, longForm, pos + 1);
        }
        return pos;
    }

    public int find(char shortForm, String longForm, int paramCount) {
        return this.find(shortForm, longForm, paramCount, paramCount);
    }

    public boolean exists(char shortForm, String longForm) {
        return this.findFirst(shortForm, longForm) != -1;
    }

    public boolean flagEqual(int pos, char shortForm, String longForm) {
        if (pos >= this.args.length) {
            throw new CmdLineException("Position out of range");
        }
        if (this.args[pos].charAt(0) != '-' || this.args[pos].length() < 2) {
            return false;
        }
        if (this.args[pos].charAt(1) == shortForm && this.args[pos].length() == 2) {
            return true;
        }
        return this.args[pos].charAt(1) == '-' && this.args[pos].length() == longForm.length() + 2 && this.args[pos].regionMatches(2, longForm, 0, longForm.length());
    }

    private boolean isParam(int pos) {
        if (pos >= this.args.length) {
            return false;
        }
        return this.args[pos].charAt(0) != '-';
    }

    private int findFirst(char shortForm, String longForm) {
        for (int i = this.blockBegin[this.lockPointer]; i < this.blockEnd[this.lockPointer]; ++i) {
            if (this.paramCount[i] != -1 || !this.flagEqual(i, shortForm, longForm)) continue;
            return i;
        }
        return -1;
    }

    private int findBehind(char shortForm, String longForm, int behind) {
        for (int i = behind; i < this.blockEnd[this.lockPointer]; ++i) {
            if (this.paramCount[i] != -1 || !this.flagEqual(i, shortForm, longForm)) continue;
            return i;
        }
        return -1;
    }

    public class CmdLineException
    extends RuntimeException {
        public CmdLineException() {
            super("An error occured in CmdLine");
        }

        public CmdLineException(String msg) {
            super(msg);
        }
    }
}

