/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.common.util.ByteVector;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Compression {
    public static byte[] compress(byte[] data) {
        return Compression.compress(data, 0, data.length);
    }

    public static byte[] compress(byte[] data, int offset, int length) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gos = null;
        try {
            gos = new GZIPOutputStream(baos);
            gos.write(data, offset, Math.min(length, data.length - offset));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error: could not compress data", e);
        }
        finally {
            if (gos != null) {
                try {
                    gos.close();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Error: could not compress data", e);
                }
            }
        }
        return baos.toByteArray();
    }

    public static byte[] decompress(byte[] data) {
        return Compression.decompress(data, 0, data.length);
    }

    public static byte[] decompress(byte[] data, int offset, int length) {
        return Compression.decompressWithListOfArrays(data, offset, length);
    }

    public static byte[] decompressIfNeeded(byte[] data) {
        if (data.length <= 2) {
            return data;
        }
        int signature = data[0] & 0xFF | data[1] << 8 & 0xFF00;
        if (35615 != signature) {
            return data;
        }
        return Compression.decompress(data);
    }

    public static InputStream decompressIfNeeded(InputStream input) throws IOException {
        int signature;
        BufferedInputStream bufferedInput = new BufferedInputStream(input);
        bufferedInput.mark(2);
        byte[] signBytes = new byte[2];
        int count = bufferedInput.read(signBytes);
        bufferedInput.reset();
        if (count == 2 && 35615 == (signature = signBytes[0] & 0xFF | signBytes[1] << 8 & 0xFF00)) {
            return new GZIPInputStream(bufferedInput);
        }
        return bufferedInput;
    }

    private static byte[] decompressWithVector(byte[] data, int offset, int length) {
        int BLOCK_SIZE = 8192;
        ByteArrayInputStream bais = new ByteArrayInputStream(data, offset, Math.min(length, data.length - offset));
        GZIPInputStream is = null;
        ByteVector vec = new ByteVector();
        try {
            is = new GZIPInputStream(bais);
            byte[] buffer = new byte[8192];
            int readCount = 0;
            while ((readCount = ((InputStream)is).read(buffer)) > 0) {
                vec.addElements(buffer, 0, readCount);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error: could not decompress data", e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Error: could not decompress data", e);
                }
            }
        }
        return vec.elementData;
    }

    private static byte[] decompressWithListOfArrays(byte[] data, int offset, int length) {
        int BLOCK_SIZE = 8192;
        ByteArrayInputStream bais = new ByteArrayInputStream(data, offset, Math.min(length, data.length - offset));
        GZIPInputStream is = null;
        ArrayList<byte[]> blocks = new ArrayList<byte[]>();
        int totalSize = 0;
        try {
            is = new GZIPInputStream(bais);
            byte[] buffer = new byte[8192];
            int readCount = 0;
            while ((readCount = ((InputStream)is).read(buffer)) > 0) {
                if (readCount == buffer.length) {
                    blocks.add(buffer);
                    buffer = new byte[8192];
                } else {
                    byte[] tmp = new byte[readCount];
                    System.arraycopy(buffer, 0, tmp, 0, readCount);
                    blocks.add(tmp);
                }
                totalSize += readCount;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error: could not decompress data", e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Error: could not decompress data", e);
                }
            }
        }
        byte[] result = new byte[totalSize];
        int pos = 0;
        for (byte[] b : blocks) {
            System.arraycopy(b, 0, result, pos, b.length);
            pos += b.length;
        }
        return result;
    }
}

