/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.util.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class ConfidenceMap<K, V> {
    private MultiMap<K, Value<V>> allEntries = new MultiMap<K, Value<V>>(){

        @Override
        protected void addValue(Value<V> value, List<Value<V>> values) {
            int index = Collections.binarySearch(values, value, new Comparator<Value<V>>(){

                @Override
                public int compare(Value<V> v1, Value<V> v2) {
                    double res = v2.score - v1.score;
                    if (res < 0.0) {
                        return -1;
                    }
                    if (res > 0.0) {
                        return 1;
                    }
                    return ConfidenceMap.this.compare(v1.value, v2.value);
                }
            });
            if (index < 0) {
                index = -index - 1;
            }
            values.add(index, value);
        }
    };

    public double bonus(K key, V value) {
        return 0.0;
    }

    protected int compare(V value1, V value2) {
        return 0;
    }

    public void put(K key, V value, Source source) {
        Value<V> v = this.existingEntry(key, value);
        if (v == null) {
            this.allEntries.put(key, new Value<V>(value, source, this.bonus(key, value)));
            return;
        }
        if (v.sources.contains(source)) {
            return;
        }
        this.allEntries.delete(key, v);
        v.addSource(source);
        this.allEntries.put(key, v);
    }

    private Value<V> existingEntry(K key, V value) {
        List<Value<V>> values = this.getAll(key);
        if (values == null) {
            return null;
        }
        for (Value<V> v : values) {
            if (!v.value.equals(value)) continue;
            return v;
        }
        return null;
    }

    public List<Value<V>> getAll(K key) {
        return this.allEntries.get(key);
    }

    public V getBest(K key) {
        List<Value<V>> all = this.getAll(key);
        if (all == null) {
            return null;
        }
        return all.get((int)0).value;
    }

    public Value<V> getBestMapping(K key) {
        List<Value<V>> all = this.getAll(key);
        if (all == null) {
            return null;
        }
        return all.get(0);
    }

    public Set<K> keySet() {
        return this.allEntries.keySet();
    }

    public static class Value<V> {
        public final V value;
        public final List<Source> sources;
        private double score;

        public Value(V value, Source source, double bonus) {
            this.value = value;
            this.sources = new ArrayList<Source>();
            this.score = bonus;
            this.addSource(source);
        }

        public void addSource(Source source) {
            int prevScore = Integer.MIN_VALUE;
            boolean hadPrevious = false;
            for (Source other : this.sources) {
                if (!other.getUniqueSourceID().equals(source.getUniqueSourceID())) continue;
                hadPrevious = true;
                prevScore = Math.max(prevScore, other.confidence);
            }
            this.sources.add(source);
            if (hadPrevious) {
                if (source.confidence > prevScore) {
                    this.score += (double)(-prevScore + source.confidence);
                }
            } else {
                this.score += (double)source.confidence;
            }
        }

        public String toString() {
            if (this.sources.size() == 1) {
                return this.value + " (source=" + this.sources.get(0) + " \u03a3=" + this.score + ")";
            }
            return this.value + " (sources=" + this.sources + " \u03a3=" + this.score + ")";
        }
    }

    public static class Source {
        public final Object id;
        public final Object variant;
        public final int confidence;

        public Source(Object id, int confidence) {
            this(id, null, confidence);
        }

        public Source(Object id, Object variant, int confidence) {
            this.id = id;
            this.variant = variant;
            this.confidence = confidence;
        }

        public String toString() {
            if (this.variant == null) {
                return String.valueOf(this.id);
            }
            return String.valueOf(this.id) + "/" + this.variant;
        }

        public Object getUniqueSourceID() {
            return this.id;
        }
    }
}

