/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import chemaxon.util.ConfigUtils;
import chemaxon.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class ConfigTools
extends ConfigUtils {
    public static boolean isXML(String str) {
        return ConfigTools.isXML(str, null);
    }

    public static boolean isXML(String str, String root) {
        return (str = str.trim()).startsWith("<?xml") || root != null && str.startsWith("<" + root);
    }

    public static String[] getItems(String str, String delim) {
        StringTokenizer st = new StringTokenizer(str, delim);
        String[] items = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            items[i++] = st.nextToken();
        }
        return items;
    }

    public static String[] getItems(String str) {
        ArrayList<String> v = new ArrayList<String>();
        int i = 0;
        int k = 0;
        while ((i = str.indexOf("..", k)) != -1) {
            v.add(str.substring(k, i));
            k = i + ITEM_SEPARATOR_LENGTH;
        }
        v.add(str.substring(k));
        String[] res = new String[v.size()];
        v.toArray(res);
        return res;
    }

    public static String extractSection(Reader reader, String path) throws DocumentException, IOException {
        Document doc = new SAXReader().read(reader);
        Element root = doc.getRootElement();
        XPath xpath = DocumentHelper.createXPath((String)path);
        Element element = (Element)xpath.selectSingleNode((Object)root);
        if (element == null) {
            return null;
        }
        StringWriter strwriter = new StringWriter();
        XMLWriter xmlwriter = new XMLWriter((Writer)strwriter);
        xmlwriter.write(element);
        xmlwriter.flush();
        xmlwriter.close();
        return strwriter.toString();
    }

    public static String convertStructures(File file) throws IOException {
        return ConfigTools.convertStructures(file, null);
    }

    public static String convertStructures(File file, String format2) throws IOException {
        Element root = null;
        try {
            Document doc = new SAXReader().read(file);
            root = doc.getRootElement();
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
        ConfigTools.convertStructures(root, file.getParent(), format2);
        StringWriter strwriter = new StringWriter();
        XMLWriter xmlwriter = new XMLWriter((Writer)strwriter, OutputFormat.createPrettyPrint());
        xmlwriter.write(root);
        xmlwriter.flush();
        xmlwriter.close();
        return strwriter.toString();
    }

    public static void convertStructures(Element root, String dir) throws IOException {
        ConfigTools.convertStructures(root, dir, null);
    }

    public static void convertStructures(Element root, String dir, String format2) throws IOException {
        XPath path = DocumentHelper.createXPath((String)"//*[@Structure]");
        List list = path.selectNodes((Object)root);
        for (Element element : list) {
            ConfigTools.convertStructure(element, dir, format2);
        }
    }

    public static void convertStructure(Element element, String dir) throws IOException {
        ConfigTools.convertStructure(element, dir, null);
    }

    public static void convertStructure(Element element, String dir, String format2) throws IOException {
        String structure = element.attributeValue("Structure");
        if (structure != null) {
            String path = ConfigTools.getPath(structure, dir);
            String type = element.attributeValue("Type");
            if ("path".equalsIgnoreCase(type) || MFileFormatUtil.isURLOrFileName(path) && new File(path).canRead()) {
                element.addAttribute("Type", "string");
                if (format2 == null) {
                    element.addAttribute("Structure", ConfigTools.convertFileContent(path));
                } else {
                    Molecule mol = ConfigTools.getMolecule(structure, "path", dir, false);
                    structure = mol.exportToFormat(format2);
                    element.addAttribute("Structure", ConfigTools.convertString(structure));
                }
            } else {
                try {
                    MolImporter.importMol(structure);
                }
                catch (IOException e) {
                    throw new IOException("Could not read structure: " + structure + lineSep + e.getMessage());
                }
            }
        }
    }

    private static String convertFileContent(String path) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(path));
        return ConfigTools.convertString(ConfigTools.getContent(br));
    }

    private static String convertString(String inputString) {
        String s = inputString;
        s = StringUtil.replaceString(s, "\\n", "\\N");
        s = StringUtil.convertToUNIXStyle(s);
        s = StringUtil.replaceString(s, "\n", "\\n");
        return s;
    }

    public static ArrayList readChemicalTermFilters(InputStream stream) throws DocumentException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        SAXReader reader = new SAXReader();
        Document doc = reader.read(stream);
        Element root = doc.getRootElement();
        List filters = root.selectNodes("Filters | Filter");
        for (int x = 0; x < filters.size(); ++x) {
            Element node = (Element)filters.get(x);
            String name = node.attributeValue("name");
            String value = node.getText();
            value = value.trim();
            value = StringUtil.convertToUNIXStyle(value);
            StringTokenizer st = new StringTokenizer(value, "\n");
            StringBuffer sb = new StringBuffer();
            boolean firstLine = true;
            while (st.hasMoreElements()) {
                if (!firstLine) {
                    sb.append("\n");
                }
                sb.append(st.nextToken().trim());
                firstLine = false;
            }
            value = sb.toString();
            result.add(new String[]{name, value});
        }
        return result;
    }
}

