/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Vector;

public class ConsoleUtil {
    public static final String DEFAULT_WAIT_MESSAGE = "[Press any key to continue]";
    public static final int DEFAULT_SCREEN_SIZE_X = 80;
    public static final int DEFAULT_SCREEN_SIZE_Y = 25;
    private static final String text = "1asdfasdfasd\n1asdfasdfasdfasdfasdfasdfasdfdsadsfasdfasdfasdfasdfasdfasdfasdfasdfasdfasdfasdfasdfasdfasdfasdf\n1sdfg\n1sdfgsdfgsdfgsdfgsdfgjhsldfkjglskdjskjdljdhfldfkhgkgkjgkgkjgjhgkjhgk\n1sdg\n1fg\n1sdf\n1dsf\n1sdfg\n1sdfg\n1sdfg\n1sdf\n1sdfg\n1sdfg\n1sdfg\n1sdfg\n1sdf\n1sdf\n1df\n1sdf\n1sg\n1sdfs\n1sgssg\n1sgsdfg\n1sdf\n1sdf\n1sdfg";

    public static void printStatusLine(String msg, int length) {
        System.out.print("\r");
        System.out.print(msg);
        for (int i = msg.length(); i < length; ++i) {
            System.err.print(" ");
        }
    }

    public static void printHelpText(String text) {
        ConsoleUtil.printHelpText(text, null, 0, 0);
    }

    public static void printHelpText(String text, String waitText, int screenSizeX, int screenSizeY) {
        if (waitText == null) {
            waitText = DEFAULT_WAIT_MESSAGE;
        }
        if (screenSizeX == 0) {
            screenSizeX = 80;
        }
        if (screenSizeY == 0) {
            screenSizeY = 25;
        }
        BufferedReader br = new BufferedReader(new StringReader(text));
        Vector lines = new Vector();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                Vector lineParts = ConsoleUtil.breakLine(line, screenSizeX);
                for (int x = 0; x < lineParts.size(); ++x) {
                    lines.add(lineParts.get(x));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int x = 0; x < lines.size(); ++x) {
            System.out.println(lines.get(x));
            if ((x + 1) % (screenSizeY - 1) != 0) continue;
            ConsoleUtil.pause(waitText, screenSizeX);
        }
    }

    private static void pause(String text, int screenSizeX) {
        String msg = text;
        ConsoleUtil.printStatusLine(msg, screenSizeX - 1);
        try {
            new InputStreamReader(System.in).read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ConsoleUtil.printStatusLine("", screenSizeX - 1);
    }

    private static Vector breakLine(String line, int screenSizeX) {
        Vector<String> result = new Vector<String>();
        int p = 0;
        int length = line.length();
        while (true) {
            int p2;
            if ((p2 = p + screenSizeX - 1) > length) {
                p2 = length;
            }
            if (p2 <= p) break;
            result.add(line.substring(p, p2));
            if (p2 == length) break;
            p = p2;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        ConsoleUtil.printHelpText(text);
    }
}

