/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

public class DDistanceMatrix {
    private double[] values;
    private int length;

    public DDistanceMatrix(int n) {
        this.length = n;
        this.values = new double[n * (n - 1) / 2];
    }

    public void setDistance(int row, int col, double distance) {
        if (row != 0 && row > col) {
            this.values[row * (row - 1) / 2 + col] = distance;
        } else if (col != 0 && row < col) {
            this.setDistance(col, row, distance);
        }
    }

    public double getDistance(int row, int col) {
        if (row == col) {
            return 0.0;
        }
        if (row > col) {
            return this.values[row * (row - 1) / 2 + col];
        }
        return this.getDistance(col, row);
    }

    public int length() {
        return this.length;
    }

    public double getMaxDistance() {
        double max = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            if (!(max < this.values[i])) continue;
            max = this.values[i];
        }
        return max;
    }

    public int[] getMaxDistancePos() {
        double max = 0.0;
        int maxDistanceRow = 0;
        int maxDistanceCol = 0;
        for (int row = 1; row < this.length - 1; ++row) {
            for (int col = 0; col < row; ++col) {
                if (!(max < this.getDistance(row, col))) continue;
                max = this.getDistance(row, col);
                maxDistanceRow = row;
                maxDistanceCol = col;
            }
        }
        int[] maxDistancePos = new int[]{maxDistanceRow, maxDistanceCol};
        return maxDistancePos;
    }
}

