/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.struc.MoleculeGraph;
import chemaxon.util.DFSVisitor;
import java.util.ArrayList;

public class DFS {
    protected MoleculeGraph cgraph = null;
    protected int[][] ctab = null;
    protected int[] path = null;
    protected int[] visited = null;
    protected int[] dfs = null;
    protected int[] root = null;
    protected int dfsindex = 0;
    protected int dfsroot = 0;
    protected int pathlen = 0;
    protected ArrayList visitors = null;
    private static final int INITIAL_CAPACITY = 64;
    protected boolean allPathMode = false;

    public DFS() {
        this.alloc(64);
    }

    public int getAtomCount() {
        return this.dfsindex;
    }

    public int getAtomIndex(int i) {
        return this.dfs[i];
    }

    public int getRootDFS(int i) {
        return this.root[i];
    }

    public MoleculeGraph getCgraph() {
        return this.cgraph;
    }

    public void setCgraph(MoleculeGraph cg) {
        this.cgraph = cg;
        this.ctab = cg.getCtab();
        this.alloc(this.ctab.length);
    }

    public boolean isAllPathMode() {
        return this.allPathMode;
    }

    public void setAllPathMode(boolean mode) {
        this.allPathMode = mode;
    }

    public ArrayList getVisitors() {
        return this.visitors;
    }

    public void addVisitor(DFSVisitor visitor) {
        if (this.visitors == null) {
            this.visitors = new ArrayList();
        }
        this.visitors.add(visitor);
    }

    public void traverseAll() {
        for (int index = 0; index < this.ctab.length; ++index) {
            if (this.visited[index] != 0) continue;
            this.dfsroot = this.dfsindex;
            this.traverse(index);
        }
    }

    public void traverse(int index) {
        if (this.visited[index] == 2 && !this.allPathMode) {
            return;
        }
        if (this.visited[index] == 1) {
            this.foundRing(index);
            return;
        }
        this.visit(index);
        this.visited[index] = 1;
        this.root[index] = this.dfsroot;
        if (!this.allPathMode) {
            this.dfs[this.dfsindex++] = index;
        }
        this.path[this.pathlen++] = index;
        int prev = this.pathlen >= 2 ? this.path[this.pathlen - 2] : -1;
        int deg = this.ctab[index].length;
        for (int j = 0; j < deg; ++j) {
            int next = this.ctab[index][j];
            if (prev == next) continue;
            this.traverse(next);
        }
        this.visited[index] = 2;
        --this.pathlen;
        this.finishProcessing(index);
    }

    private void finishProcessing(int index) {
        for (int i = 0; i < this.visitors.size(); ++i) {
            DFSVisitor v = (DFSVisitor)this.visitors.get(i);
            v.finishProcessing(index);
        }
    }

    private void foundRing(int index) {
        for (int i = 0; i < this.visitors.size(); ++i) {
            DFSVisitor v = (DFSVisitor)this.visitors.get(i);
            v.foundRing(index);
        }
    }

    private void visit(int index) {
        for (int i = 0; i < this.visitors.size(); ++i) {
            DFSVisitor v = (DFSVisitor)this.visitors.get(i);
            v.visit(index);
        }
    }

    protected void alloc(int capacity) {
        int n = this.getPreferredSize(capacity);
        if (this.visited == null || n > this.visited.length) {
            this.visited = new int[n];
            this.path = new int[n];
            this.dfs = new int[n];
            this.root = new int[n];
        }
        if (this.visitors != null) {
            for (int i = 0; i < this.visitors.size(); ++i) {
                DFSVisitor visitor = (DFSVisitor)this.visitors.get(i);
                visitor.allocate(capacity);
            }
        }
        this.init();
    }

    protected int getPreferredSize(int capacity) {
        int n;
        int n2 = n = this.visited != null ? this.visited.length : 1;
        while (n < capacity) {
            n <<= 1;
        }
        return n;
    }

    public void init() {
        int i;
        for (i = 0; i < this.visited.length; ++i) {
            this.visited[i] = 0;
        }
        for (i = 0; i < this.dfs.length; ++i) {
            this.dfs[i] = -1;
        }
        this.dfsindex = 0;
        this.pathlen = 0;
        if (this.visitors != null) {
            for (i = 0; i < this.visitors.size(); ++i) {
                DFSVisitor visitor = (DFSVisitor)this.visitors.get(i);
                visitor.init();
            }
        }
    }
}

