/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

public class DoubleIntQuickSort {
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    private static int nSwaps = 0;
    private static int nCompares = 0;
    private static int nTabs = 0;
    double[] fa;
    int[] ia;
    int order;

    public DoubleIntQuickSort(int order, double[] fa, int[] ia) {
        this.order = order;
        this.fa = fa;
        this.ia = ia;
    }

    public void qsort() {
        this.qsort(0, this.fa.length - 1);
    }

    public void qsort(int left, int right) {
        if (left >= right) {
            return;
        }
        this.swap(left, (left + right) / 2);
        int last = left;
        for (int i = left + 1; i <= right; ++i) {
            if (!this.compare(left, i)) continue;
            if (last + 1 == i) {
                ++last;
                continue;
            }
            this.swap(++last, i);
        }
        if (left != last) {
            this.swap(left, last);
        }
        this.qsort(left, last - 1);
        --nTabs;
        this.qsort(last + 1, right);
        --nTabs;
    }

    private boolean compare(int i1, int i2) {
        ++nCompares;
        return this.order == 1 ? this.fa[i1] > this.fa[i2] : this.fa[i1] < this.fa[i2];
    }

    private void swap(int i1, int i2) {
        ++nSwaps;
        double ftmp = this.fa[i1];
        this.fa[i1] = this.fa[i2];
        this.fa[i2] = ftmp;
        int itmp = this.ia[i1];
        this.ia[i1] = this.ia[i2];
        this.ia[i2] = itmp;
    }
}

