/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.StereoConstants;

public class EnhStereoConverter
implements StereoConstants {
    public static void convert(Molecule m, boolean isAlwaysAbsStereo) {
        EnhStereoConverter.convert(m, isAlwaysAbsStereo, 3);
    }

    public static void convert(Molecule m, boolean isAlwaysAbsStereo, int newNonABSGroupType) {
        if (m instanceof RgMolecule) {
            RgMolecule rg = (RgMolecule)m;
            int minANDGroup = 0;
            minANDGroup = Math.max(minANDGroup, EnhStereoConverter.convert(rg.getRoot(), isAlwaysAbsStereo, newNonABSGroupType, minANDGroup));
            for (int i = 0; i < rg.getRgroupCount(); ++i) {
                for (int j = 0; j < rg.getRgroupMemberCount(i); ++j) {
                    minANDGroup = Math.max(minANDGroup, EnhStereoConverter.convert(rg.getRgroupMember(i, j), isAlwaysAbsStereo, newNonABSGroupType, minANDGroup));
                }
            }
        } else {
            EnhStereoConverter.convert(m, isAlwaysAbsStereo, newNonABSGroupType, 0);
        }
    }

    private static int convert(Molecule m, boolean isAlwaysAbsStereo, int newNonABSGroupType, int minANDGroupNo) {
        int parity;
        int enhType;
        MolAtom atom;
        int i;
        boolean hasEnhStereo = false;
        boolean hasUnlabeledStereo = false;
        int maxANDGroupNumber = Math.max(minANDGroupNo, 0);
        int newGroupType = 1;
        int newGroupNumber = -1;
        for (i = 0; i < m.getAtomCount(); ++i) {
            atom = m.getAtom(i);
            enhType = atom.getStereoGroupType();
            parity = m.getLocalParity(i);
            if (enhType != 0) {
                hasEnhStereo = true;
                int stGroupNumber = atom.getStereoGroupNumber();
                if (enhType != 3 || maxANDGroupNumber >= stGroupNumber) continue;
                maxANDGroupNumber = stGroupNumber;
                continue;
            }
            if (parity != 1 && parity != 2) continue;
            hasUnlabeledStereo = true;
        }
        if (!hasUnlabeledStereo) {
            return -1;
        }
        if (!hasEnhStereo && (isAlwaysAbsStereo || m.isAbsStereo())) {
            newGroupType = 1;
        } else {
            newGroupType = newNonABSGroupType;
            newGroupNumber = maxANDGroupNumber + 1;
        }
        for (i = 0; i < m.getAtomCount(); ++i) {
            atom = m.getAtom(i);
            enhType = atom.getStereoGroupType();
            parity = m.getLocalParity(i);
            if (enhType != 0 || parity != 1 && parity != 2) continue;
            atom.setStereoGroupType(newGroupType);
            if (newGroupNumber == -1) continue;
            atom.setStereoGroupNumber(newGroupNumber);
        }
        return newGroupNumber;
    }
}

