/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.jchem.db.MaxSearchFrequencyExceededException;
import chemaxon.jchem.db.PropertyNotSetException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;

public abstract class ErrorHandler
implements Serializable {
    public static final int NO_ERROR = 0;
    public static final int UNIDENTIFIED_ERROR = 1;
    public static final int MAX_SEARCH_FREQUENCY_EXCEEDED_ERROR = 2;
    public static final int DATABASE_SEARCH_ERROR = 3;
    public static final int MOL_FORMAT_ERROR = 4;
    public static final int IO_ERROR = 5;
    public static final int PROPERTY_NOT_SET_ERROR = 6;
    public static final int CLASS_NOT_FOUND_ERROR = 7;
    public static final int INSTANTIATION_ERROR = 8;
    public static final int ILLEGAL_ACCESS_ERROR = 9;
    public static final int SQL_ERROR = 10;
    protected Throwable exception = null;

    public Throwable getException() {
        return this.exception;
    }

    public int getError() {
        Throwable e = this.getException();
        if (e == null) {
            return 0;
        }
        if (e instanceof MaxSearchFrequencyExceededException) {
            return 2;
        }
        if (e instanceof DatabaseSearchException) {
            return 3;
        }
        if (e.getClass().getName().indexOf("MolFormatException") != -1) {
            return 4;
        }
        if (e instanceof IOException) {
            return 5;
        }
        if (e instanceof PropertyNotSetException) {
            return 6;
        }
        if (e instanceof ClassNotFoundException) {
            return 7;
        }
        if (e instanceof InstantiationException) {
            return 8;
        }
        if (e instanceof IllegalAccessException) {
            return 9;
        }
        if (e instanceof SQLException) {
            return 10;
        }
        return 1;
    }

    public String getErrorMessage() {
        Throwable e = this.getException();
        if (e != null) {
            return e.getMessage();
        }
        return null;
    }

    public String getStackTrace() {
        String s = null;
        Throwable e = this.getException();
        if (e != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(os);
            e.printStackTrace(pw);
            pw.write("");
            try {
                pw.close();
                os.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            s = new String(os.toByteArray());
        }
        return s;
    }

    public void checkError() throws Throwable {
        Throwable e = this.getException();
        if (e != null) {
            throw e;
        }
    }

    public void checkException() throws Exception {
        Throwable e = this.getException();
        if (e != null) {
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            e.printStackTrace();
            throw new Exception((e.getMessage() == null ? "Unknown error" : e.getMessage()) + " (" + e.getClass().getName() + ")");
        }
    }
}

