/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.marvin.util.Environment;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;

public class FindCodeBase {
    private static String classfile = "/chemaxon/util/FindCodeBase.class";

    private static String getEncodedAbsolutPath(String filename) {
        URL url = FindCodeBase.class.getResource(filename);
        if (url == null) {
            return null;
        }
        String path = url.getPath();
        if (Environment.JAVAWEBSTART && url.getProtocol().equals("jar") && !path.endsWith(filename)) {
            path = FindCodeBase.getJwsCodeBase() + "lib/";
        }
        return path;
    }

    public static URL getResource(Class cl, String filename) {
        URL result = cl.getResource(filename);
        if (Environment.JAVAWEBSTART && result != null && "jar".equals(result.getProtocol())) {
            String fullname = filename.startsWith("/") ? filename : cl.getPackage().getName().replace('.', '/') + filename;
            URL classSourceLocationURL = cl.getProtectionDomain().getCodeSource().getLocation();
            String urlString = "jar:" + classSourceLocationURL.toExternalForm() + "!" + fullname;
            try {
                result = new URL(urlString);
            }
            catch (MalformedURLException muex) {
                muex.printStackTrace();
                result = null;
            }
        }
        return result;
    }

    public static String getCodeBaseDir() {
        return FindCodeBase.getCodeBaseDir(classfile);
    }

    public static String getCodeBaseDir(String clfile) {
        String path = FindCodeBase.getEncodedAbsolutPath(clfile);
        if (path == null) {
            System.err.println("The code base can not be determined.");
            return null;
        }
        int index = path.lastIndexOf(clfile);
        String codebase = null;
        if (index == -1) {
            return path;
        }
        codebase = path.substring(0, index);
        if (codebase.startsWith("file:")) {
            codebase = codebase.substring("file:".length());
        }
        if (codebase.endsWith("!")) {
            codebase = codebase.substring(0, codebase.length() - 1);
            index = codebase.lastIndexOf("/");
            codebase = codebase.substring(0, index + 1);
        }
        if (codebase.startsWith("http://") || codebase.startsWith("https://")) {
            return codebase;
        }
        String decoded = URLDecoder.decode(codebase);
        File f = new File(decoded);
        try {
            String path1 = f.getCanonicalPath();
            return path1;
        }
        catch (IOException ioe) {
            System.err.println("Incorrect code base syntax:" + decoded);
            return null;
        }
    }

    public static boolean isURL(String path) {
        return path != null && (path.startsWith("http:") || path.startsWith("https:"));
    }

    public static String getJwsCodeBase() {
        if (!Environment.JAVAWEBSTART) {
            return null;
        }
        try {
            Class<?> srvmanClass = Class.forName("javax.jnlp.ServiceManager");
            Method lookupMethod = srvmanClass.getMethod("lookup", String.class);
            Object bs = lookupMethod.invoke(null, "javax.jnlp.BasicService");
            Method getCodeBaseMethod = bs.getClass().getMethod("getCodeBase", null);
            Object urlObj = getCodeBaseMethod.invoke(bs, (Object[])null);
            return urlObj.toString();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String getJarName(String classname) {
        String clsfile = "/" + classname + ".class";
        String path = FindCodeBase.getEncodedAbsolutPath(clsfile);
        String tail = "!" + clsfile;
        if (path != null && path.endsWith(tail)) {
            String jarpath = path.substring(0, path.length() - tail.length());
            return new File(jarpath).getName();
        }
        return null;
    }
}

