/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

public class Heap {
    public static final int MIN_HEAP = 1;
    public static final int MAX_HEAP = 2;
    private int type = 1;
    private Node[] heap = null;
    private int size = 0;

    public Heap(int maxCapacity) {
        this.heap = new Node[maxCapacity];
    }

    public Heap(int maxCapacity, int type) {
        this.heap = new Node[maxCapacity];
        this.type = type;
    }

    public Heap(float[] weights) {
        this.heap = new Node[weights.length];
        this.build(weights, null);
    }

    public Heap(float[] weights, Object[] data) {
        this.heap = new Node[weights.length];
        this.build(weights, data);
    }

    public Heap(float[] weights, Object[] data, int type) {
        this.heap = new Node[weights.length];
        this.type = type;
        this.build(weights, data);
    }

    public void insert(float weight, Object data) throws HeapException {
        int ip;
        if (this.size == this.heap.length && !this.ordered(weight, this.size - 1)) {
            return;
        }
        if (this.size < this.heap.length) {
            ip = this.size;
            this.heap[ip] = new Node(weight, data);
        } else {
            ip = this.size - 1;
            this.heap[ip].set(weight, data);
        }
        this.up(ip);
        if (this.size < this.heap.length) {
            ++this.size;
        }
    }

    public void insert(float weight) throws HeapException {
        this.insert(weight, null);
    }

    public float findMin() throws HeapException {
        if (this.size == 0) {
            throw new HeapException("Empty heap");
        }
        return this.heap[0].weight;
    }

    public Object getMinData() throws HeapException {
        if (this.size == 0) {
            throw new HeapException("Empty heap");
        }
        return this.heap[0].data;
    }

    public Object getData(int index) {
        if (this.size == 0) {
            throw new HeapException("Empty heap");
        }
        return this.heap[index].data;
    }

    public void deleteMin() throws HeapException {
        if (this.size == 0) {
            throw new HeapException("Empty heap");
        }
        this.heap[0] = this.heap[--this.size];
        this.down(0);
    }

    public void decreaseKey(int i, float newValue) throws HeapException {
        if (i > this.size) {
            throw new HeapException("Index out of range");
        }
        if (this.type == 2 && newValue > this.heap[i].weight) {
            this.heap[i].weight = newValue;
            this.up(i);
            return;
        }
        this.heap[i].weight = newValue;
        this.down(i);
    }

    public void delete(int i) throws HeapException {
        if (i > this.size) {
            throw new HeapException("Index out of range");
        }
        this.heap[i] = this.heap[--this.size];
        if (this.size == 0) {
            return;
        }
        if (this.type == 2) {
            this.down(i);
        } else {
            this.up(i);
        }
    }

    public void deleteNoSort(int i) {
        if (this.size > 0) {
            this.heap[i] = this.heap[--this.size];
        }
    }

    public void heapify() {
        this.build();
    }

    public int size() {
        return this.size;
    }

    public int getMaxCapacity() {
        return this.heap.length;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.heap[i] = null;
        }
        this.size = 0;
    }

    private void build(float[] weights, Object[] data) {
        for (int i = 0; i < this.heap.length; ++i) {
            this.heap[i] = new Node(weights[i], data != null ? data[i] : null);
        }
        this.size = this.heap.length;
        this.build();
    }

    private void build() {
        for (int i = this.size / 2; i >= 0; --i) {
            this.down(i);
        }
    }

    private void down(int i) {
        int left = 2 * i;
        if (left >= this.size) {
            return;
        }
        int m = this.min(i);
        if (m != i) {
            this.swap(i, m);
            this.down(m);
        }
    }

    private int min(int parent) {
        int left = 2 * parent;
        if (left >= this.size) {
            return parent;
        }
        int right = left + 1;
        if (right >= this.size) {
            return !this.ordered(parent, left) ? left : parent;
        }
        int m = !this.ordered(left, right) ? right : left;
        return !this.ordered(parent, m) ? m : parent;
    }

    private void up(int i) {
        if (i == 0) {
            return;
        }
        int parent = i / 2;
        if (!this.ordered(parent, i)) {
            this.swap(parent, i);
            this.up(parent);
        }
    }

    private boolean ordered(int parent, int child) {
        float pw = this.heap[parent].weight;
        float cw = this.heap[child].weight;
        return this.type == 1 ? pw <= cw : pw >= cw;
    }

    private boolean ordered(float weigth, int index) {
        float w = this.heap[index].weight;
        return this.type == 1 ? weigth <= w : weigth >= w;
    }

    private void swap(int parent, int child) {
        Node w = this.heap[parent];
        this.heap[parent] = this.heap[child];
        this.heap[child] = w;
    }

    public void dump() {
        System.out.print("Heap::dump");
        System.out.print(" size = " + this.size + " ");
        for (int i = 0; i < this.size; ++i) {
            System.out.print(this.heap[i] + ", ");
        }
        System.out.println();
    }

    private class Node {
        public float weight;
        public Object data;

        public Node(float weight, Object data) {
            this.weight = weight;
            this.data = data;
        }

        public void set(float weight, Object data) {
            this.weight = weight;
            this.data = data;
        }

        public String toString() {
            return "(" + this.weight + "," + this.data + ")";
        }
    }

    public class HeapException
    extends RuntimeException {
        public HeapException(String msg) {
            super(msg);
        }
    }
}

