/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.common.util.IntVector;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.SimilarityException;
import chemaxon.enumeration.AromUtil;
import chemaxon.enumeration.SearchEnumerator;
import chemaxon.enumeration.homology.HomologyConversionUtil;
import chemaxon.enumeration.supergraph.MarkushAromata;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.enumeration.supergraph.SupergraphException;
import chemaxon.formats.MolFormatException;
import chemaxon.jchem.db.cdmarkush.CDMarkushFromDB;
import chemaxon.jchem.db.cdmarkush.CDMarkushHandlerCache;
import chemaxon.license.Licensable;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.reaction.Standardizer;
import chemaxon.sss.SearchConstants;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchHit;
import chemaxon.sss.search.SearchOptions;
import chemaxon.sss.search.SearchUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.util.HitColoringAndAlignmentOptions;
import chemaxon.util.HitDisplayUtil;
import chemaxon.util.HomologyExpansionUtil;
import chemaxon.util.MolAligner;
import chemaxon.util.SimilaritySearchDisplay;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ServiceConfigurationError;

public class HitDisplayTool
implements SearchConstants,
Licensable {
    public static final int HIT_ATOM_SET = 1;
    public static final int NON_HIT_ATOM_SET = 0;
    public static final int HIT_BOND_SET = 0;
    public static final int NON_HIT_BOND_SET = 1;
    private String licenseEnvironment = "";
    private HitColoringAndAlignmentOptions options = null;
    private MolSearchOptions searchOptions = null;
    private MolSearch searcher = null;
    private int searchType = 0;
    private Standardizer standardizer = null;
    private int enumeratedFeatures = 0;
    private boolean rotate = false;
    private boolean partialClean = false;
    private Molecule query = null;
    private Molecule target;
    private Supergraph markushSupergraph;
    private boolean initialized = false;
    private boolean graphSearchNeeded = false;
    private ArrayList<int[]> hitIndexes = null;
    private int maxHitCount;
    private int commingSearchInd = 0;
    private Molecule targetForDisplayOrig;
    private SearchEnumerator enumerator;
    private Molecule targetForGraphSearch;
    private Molecule queryForGraphSearch;
    private int[] standOrder;
    private boolean doEnumerateMarkush;
    private boolean isMarkush;
    private boolean bestFit;
    private boolean getNextEnumeration = true;
    private CDMarkushHandlerCache markushHandlerCache = null;

    public HitDisplayTool(HitColoringAndAlignmentOptions options, MolSearchOptions searchOptions, Standardizer standardizer, Molecule query) {
        this.options = options;
        this.searchOptions = searchOptions;
        this.standardizer = standardizer;
        this.query = query;
    }

    public Molecule getHit(Molecule targetMol) throws SearchException, SupergraphException {
        this.setTarget(targetMol);
        Molecule[] hits = this.getHits(-1);
        if (hits.length == 0) {
            return null;
        }
        return hits[0];
    }

    public Molecule[] getHits(Molecule targetMol, byte[] markushSource, int maxHitCount) throws MolFormatException, SupergraphException, SearchException {
        this.setMoleculeMarkushSourceTarget(targetMol, markushSource);
        return this.getHits(maxHitCount);
    }

    public Molecule[] getHits(Molecule targetMol, Molecule markush, int maxHitCount) throws SupergraphException, SearchException {
        this.setMoleculeMarkushTarget(targetMol, markush);
        return this.getHits(maxHitCount);
    }

    public void setTarget(Molecule targetMol) {
        this.setMoleculeSupergraphTarget(targetMol, null);
    }

    private CDMarkushHandlerCache getMarkushHandlerCache() {
        if (this.markushHandlerCache == null) {
            this.markushHandlerCache = new CDMarkushHandlerCache(CDMarkushHandlerCache.ThreadSafety.NOTSYNCHRONIZED, CDMarkushHandlerCache.CacheBehavior.CACHELAST);
        }
        return this.markushHandlerCache;
    }

    public void setMoleculeMarkushSourceTarget(Molecule targetMol, byte[] markushSource) throws MolFormatException, ServiceConfigurationError {
        if (markushSource != null) {
            try {
                CDMarkushFromDB markush = this.getMarkushHandlerCache().parseWithCompatibleHandler(markushSource);
                this.setMoleculeSupergraphTarget(targetMol, markush.getSupergraph());
            }
            catch (IllegalArgumentException e) {
                throw new MolFormatException("Could not read markush from byte array.", e);
            }
        } else {
            this.setMoleculeSupergraphTarget(targetMol, null);
        }
    }

    private void setMoleculeMarkushTarget(Molecule targetMol, Molecule markush) throws SupergraphException {
        Supergraph supergraph;
        if (markush == null || !Supergraph.isMarkushMolecule(markush)) {
            supergraph = null;
        } else {
            supergraph = new Supergraph();
            supergraph.setMoleculeWithAromatization(markush);
        }
        this.setMoleculeSupergraphTarget(targetMol, supergraph);
    }

    private void setMoleculeSupergraphTarget(Molecule targetMol, Supergraph supergraph) {
        this.target = targetMol;
        this.markushSupergraph = supergraph;
        this.commingSearchInd = -1;
    }

    public Molecule[] getHits(int maxHitCountIn) throws SearchException, SupergraphException {
        this.maxHitCount = maxHitCountIn;
        Molecule hit = null;
        ArrayList<Molecule> displayStructures = new ArrayList<Molecule>();
        do {
            if ((hit = this.getNextHit()) == null) continue;
            displayStructures.add(hit);
        } while (displayStructures.size() < this.maxHitCount && hit != null);
        return displayStructures.toArray(new Molecule[0]);
    }

    public Molecule getNextHit() throws SearchException, SupergraphException {
        if (this.target == null) {
            throw new IllegalArgumentException("No target specified for hit display.");
        }
        if (!this.initialized) {
            this.init();
        }
        this.initSearch();
        if (!this.graphSearchNeeded) {
            Molecule targetForDisplay;
            Object sgdata = this.target.getPropertyObject("SG_STRUCTURE");
            this.target.setPropertyObject("SG_STRUCTURE", null);
            Molecule molecule = targetForDisplay = this.commingSearchInd < 1 ? this.target.cloneMolecule() : null;
            if (targetForDisplay != null) {
                HitDisplayTool.clearProperties(targetForDisplay);
            }
            this.target.setPropertyObject("SG_STRUCTURE", sgdata);
            return targetForDisplay;
        }
        if (this.searchOptions != null && this.searchOptions.getSearchType() == 3) {
            return this.commingSearchInd < 1 ? this.getSimilaritySearchHit(this.target) : null;
        }
        SearchHit hit = null;
        Molecule targetForDisplay = this.targetForDisplayOrig.cloneMolecule();
        Molecule[] expandedTarget = new Molecule[1];
        while (hit == null) {
            if (this.getNextEnumeration) {
                this.queryForGraphSearch = this.getAndSetNextEnumerate();
                if (this.queryForGraphSearch == null) {
                    return null;
                }
            }
            int[] extendedHit = null;
            if (this.rotate) {
                hit = this.getHitAndRotate(this.searcher, this.queryForGraphSearch, targetForDisplay, this.standOrder, this.isMarkush, this.doEnumerateMarkush, expandedTarget, this.targetForGraphSearch, this.bestFit);
                if (hit != null) {
                    extendedHit = !this.doEnumerateMarkush ? this.add2DHitIndexes(hit) : hit.getSingleHit();
                }
            } else {
                hit = this.searcher.findNextHit();
                if (hit != null) {
                    extendedHit = this.add2DHitIndexes(hit);
                    if (this.doEnumerateMarkush) {
                        expandedTarget[0] = this.expandMarkush(this.targetForGraphSearch, this.searcher.getMatchingQuery(), extendedHit);
                    }
                    hit.setSingleHit(extendedHit);
                    hit.setGroupHit(null);
                    HitDisplayTool.rearrangeHitIfNeeded(hit, this.standOrder, this.isMarkush);
                    extendedHit = hit.getSingleHit();
                }
            }
            if (expandedTarget[0] != null) {
                targetForDisplay = expandedTarget[0];
            }
            if (hit == null) {
                this.getNextEnumeration = true;
                continue;
            }
            this.hitIndexes.add(extendedHit);
            if (this.partialClean) {
                targetForDisplay.partialClean(this.queryForGraphSearch, extendedHit, null);
            }
            HitDisplayUtil.color(this.queryForGraphSearch, targetForDisplay, extendedHit, this.options);
            if (!this.options.isRemoveUnusedDefitions()) continue;
            this.removeUnusedDefinitions(targetForDisplay, hit);
        }
        if (targetForDisplay != null) {
            HitDisplayTool.clearProperties(targetForDisplay);
        }
        return targetForDisplay;
    }

    private static void clearProperties(Molecule targetForDisplay) {
        targetForDisplay.setPropertyObject("SG_STRUCTURE", null);
        AromUtil.clearAmbigAromRingMarkers(targetForDisplay);
    }

    private Molecule getAndSetNextEnumerate() throws SearchException {
        this.getNextEnumeration = false;
        if (!this.enumerator.hasMoreElements()) {
            return null;
        }
        Molecule queryForGraphSearch = this.enumerator.nextElement();
        this.standardizeQuery(queryForGraphSearch);
        if (this.searchType != 6) {
            this.searcher.setQuery(queryForGraphSearch);
        } else {
            this.searcher.setTarget(queryForGraphSearch);
        }
        return queryForGraphSearch;
    }

    private void initSearch() throws SupergraphException, SearchException {
        boolean markushReduction;
        if (++this.commingSearchInd > 0) {
            return;
        }
        boolean bl = markushReduction = this.options.markushDisplayMode != 0 || this.options.enumerateMarkush;
        if (!markushReduction) {
            HomologyConversionUtil.deconvertHomologies(this.target, true);
        }
        if (!this.graphSearchNeeded || this.searchOptions != null && this.searchOptions.getSearchType() == 3) {
            this.maxHitCount = 1;
            return;
        }
        this.initMaxHitCount();
        this.hitIndexes = new ArrayList();
        Molecule originalTarget = this.target.cloneMolecule();
        if (this.markushSupergraph != null) {
            this.target = this.markushSupergraph;
        }
        this.isMarkush = this.searchOptions.isMarkushEnabled() && Supergraph.isMarkushMolecule(this.target);
        this.doEnumerateMarkush = markushReduction && this.isMarkush;
        MolSearchOptions mso = this.searcher.getSearchOptions();
        mso.setHitIndexType(this.doEnumerateMarkush ? 1 : 0);
        this.searcher.setSearchOptions(mso);
        this.targetForGraphSearch = null;
        if (this.searchType != 6) {
            this.targetForGraphSearch = this.target;
            this.queryForGraphSearch = this.query != null ? (Molecule)this.query.clone() : new Molecule();
        } else {
            this.targetForGraphSearch = this.query != null ? (Molecule)this.query.clone() : new Molecule();
            this.queryForGraphSearch = this.target;
        }
        this.standOrder = null;
        if (this.markushSupergraph == null) {
            if (this.isMarkush) {
                this.targetForGraphSearch = this.buildSupergraph(this.targetForGraphSearch);
            } else {
                this.standOrder = this.standardizeTarget(this.targetForGraphSearch);
            }
        }
        if (this.searchType != 6) {
            this.searcher.setTarget(this.targetForGraphSearch);
        } else {
            this.searcher.setQuery(this.targetForGraphSearch);
        }
        Molecule targetForDisplay = null;
        if (this.searchType != 6) {
            targetForDisplay = originalTarget;
            targetForDisplay.clearProperties();
            Supergraph.clearMarkers(targetForDisplay);
        } else {
            targetForDisplay = this.query;
        }
        this.enumerator = new SearchEnumerator(this.enumeratedFeatures, this.queryForGraphSearch);
        this.queryForGraphSearch = this.getAndSetNextEnumerate();
        this.targetForDisplayOrig = targetForDisplay.cloneMolecule();
    }

    private void initMaxHitCount() {
        this.bestFit = false;
        if (this.maxHitCount == -1) {
            this.bestFit = true;
            this.searchOptions.setOrderSensitiveSearch(true);
            this.maxHitCount = 1;
        }
        if (this.maxHitCount == 0) {
            this.maxHitCount = Integer.MAX_VALUE;
        }
    }

    private Supergraph buildSupergraph(Molecule mol) throws SupergraphException {
        MarkushAromata ma = new MarkushAromata();
        ma.aromatize(mol);
        return new Supergraph(mol);
    }

    private Molecule getSimilaritySearchHit(Molecule target) throws SearchException {
        try {
            Molecule result;
            String prop = target.getProperty("dissimilarity");
            if (prop != null) {
                float dissim = Float.valueOf(prop).floatValue();
                result = new SimilaritySearchDisplay().getTargetWithQuery(this.query, target, this.options, this.standardizer, dissim);
            } else {
                result = new SimilaritySearchDisplay().getTargetWithQuery(this.query, target, this.options, this.standardizer);
            }
            return result;
        }
        catch (SimilarityException e) {
            throw new RuntimeException("Failed to compute similarity score!");
        }
        catch (MDGeneratorException e) {
            throw new RuntimeException("Failed to compute similarity score!");
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Bad similarity format in molecule property.", e);
        }
    }

    private int[] add2DHitIndexes(SearchHit hit) {
        int[][] hit2D = hit.getGroupHit();
        int maxLen = 0;
        for (int i = 0; i < hit2D.length; ++i) {
            maxLen = hit2D[i].length < maxLen ? maxLen : hit2D[i].length;
        }
        IntVector hitV = new IntVector();
        for (int i = 0; i < maxLen; ++i) {
            for (int j = 0; j < hit2D.length; ++j) {
                if (hit2D[j].length > i) {
                    hitV.add(hit2D[j][i]);
                    continue;
                }
                if (hit2D[j].length <= 0) continue;
                hitV.add(hit2D[j][hit2D[j].length - 1]);
            }
        }
        return hitV.toArray();
    }

    public ArrayList<int[]> getHitIndexes() {
        return this.hitIndexes;
    }

    private void init() throws SearchException {
        this.graphSearchNeeded = HitDisplayTool.isGraphSearchNeeded(this.searchOptions, this.options);
        if (!this.graphSearchNeeded) {
            this.initialized = true;
            return;
        }
        if (this.standardizer == null) {
            this.standardizer = new Standardizer("aromatize");
        }
        this.searchType = this.searchOptions.getSearchType();
        if (this.options.alignmentMode != 0 && this.searchType != 6) {
            int alignmentMode = this.options.alignmentMode;
            if (alignmentMode == 2 && this.query.getDim() == 0) {
                alignmentMode = 1;
            }
            boolean bl = this.rotate = alignmentMode == 1;
            if (this.query.getAtomCount() < 2) {
                this.rotate = false;
            }
            this.partialClean = alignmentMode == 2;
        }
        this.enumeratedFeatures = SearchUtil.getEnumerationOption(this.searchOptions.isExactQueryAtomMatching(), this.searchOptions.isExactBondMatching(), this.searchOptions.getTautomerSearch() == 1, this.searchOptions.getVagueBondLevel());
        this.searcher = new MolSearch();
        if (this.licenseEnvironment.equalsIgnoreCase("InstantJChemLicenseEnvironment")) {
            this.searcher.setLicenseEnvironment("StructureSearchForInternalMolSearchLicenseEnvironment");
        }
        this.searchOptions.setTautomerSearch(0);
        this.searcher.setSearchOptions(this.searchOptions);
        this.searcher.setFilter(null);
        this.initialized = true;
    }

    private SearchHit getHitAndRotate(MolSearch searcher, Molecule template, Molecule targetForDisplay, int[] standOrder, boolean isMarkush, boolean doEnumerateMarkush, Molecule[] expandedMarkush, Molecule targetForGraphSearch, boolean bestFit) throws SearchException, SupergraphException {
        SearchHit hit;
        double lowestError = Double.MAX_VALUE;
        SearchHit bestHit = null;
        int hitsToTry = 20;
        MolAligner bestAligner = null;
        if (isMarkush) {
            hitsToTry = 1;
        }
        if (!bestFit) {
            hitsToTry = 1;
        }
        for (int x = 0; x < hitsToTry && (hit = searcher.findNextHit()) != null; ++x) {
            MolAligner aligner;
            double error = 0.0;
            if (doEnumerateMarkush) {
                expandedMarkush[0] = this.expandMarkush(targetForGraphSearch, searcher.getMatchingQuery(), hit.getSingleHit());
                aligner = new MolAligner(template, expandedMarkush[0]);
                aligner.calculate(hit.getSingleHit());
                error = aligner.getError();
            } else {
                aligner = new MolAligner(template, targetForDisplay);
                aligner.calculate(hit.getSingleHit());
                error = aligner.getError();
            }
            HitDisplayTool.rearrangeHitIfNeeded(hit, standOrder, isMarkush);
            if (!(error <= lowestError)) continue;
            lowestError = error;
            bestHit = hit;
            bestAligner = aligner;
        }
        if (bestAligner != null) {
            bestAligner.align();
        }
        return bestHit;
    }

    private static void rearrangeHitIfNeeded(SearchHit hit, int[] standOrder, boolean isMarkush) {
        if (!isMarkush) {
            int[] shit = hit.getSingleHit();
            int[][] ghit = hit.getGroupHit();
            int[] shitForOriginal = new int[shit.length];
            int[][] ghitForOriginal = new int[shit.length][];
            for (int y = 0; y < shit.length; ++y) {
                int index = shit[y];
                if (index < 0) {
                    shitForOriginal[y] = index;
                    ghitForOriginal[y] = ghit[y];
                    continue;
                }
                shitForOriginal[y] = standOrder[index];
                ghitForOriginal[y] = new int[ghit[y].length];
                for (int x = 0; x < ghit[y].length; ++x) {
                    int g = ghit[y][x];
                    ghitForOriginal[y][x] = g < 0 ? g : standOrder[g];
                }
            }
            hit.setSingleHit(shitForOriginal);
            hit.setGroupHit(ghitForOriginal);
        }
    }

    private void removeUnusedDefinitions(Molecule mol, SearchHit hit) {
        if (mol instanceof RgMolecule) {
            int[][] groupHit;
            RgMolecule rgmol = (RgMolecule)mol;
            HashSet<Integer> ind = new HashSet<Integer>();
            int[][] arr$ = groupHit = hit.getGroupHit();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int[] line;
                for (int index : line = arr$[i$]) {
                    ind.add(index);
                }
            }
            MolAtom[] atoms = rgmol.getAtomArray();
            HashMap<MolAtom, Integer> atomIndexes = new HashMap<MolAtom, Integer>(atoms.length * 2);
            for (int atomIndex = 0; atomIndex < atoms.length; ++atomIndex) {
                atomIndexes.put(atoms[atomIndex], atomIndex);
            }
            for (int rgIndex = rgmol.getRgroupCount() - 1; rgIndex >= 0; --rgIndex) {
                for (int rmIndex = rgmol.getRgroupMemberCount(rgIndex) - 1; rmIndex >= 0; --rmIndex) {
                    int atomIndex;
                    Molecule rmmol = rgmol.getRgroupMember(rgIndex, rmIndex);
                    boolean unused = true;
                    atoms = rmmol.getAtomArray();
                    for (atomIndex = 0; atomIndex < atoms.length; ++atomIndex) {
                        if (!ind.contains(atomIndexes.get(atoms[atomIndex]))) continue;
                        unused = false;
                    }
                    if (!unused) continue;
                    for (atomIndex = rmmol.getAtomCount() - 1; atomIndex > 0; --atomIndex) {
                        rmmol.removeAtom(atomIndex);
                    }
                    rgmol.removeAtom(rmmol.getAtom(0));
                }
            }
            CleanUtil.arrangeComponents(mol);
        }
    }

    private Molecule expandMarkush(Molecule mol, Molecule queryForGraphSearch, int[] hit) throws SupergraphException {
        boolean expandHomology = this.options.markushDisplayMode == 2;
        boolean deconvertHomologies = true;
        Molecule expanded = ((Supergraph)mol).expand(null, hit, null, expandHomology, deconvertHomologies);
        if (expandHomology) {
            hit = HomologyExpansionUtil.expand(expanded, queryForGraphSearch, hit);
        }
        expanded.clean(2, null);
        return expanded;
    }

    private static boolean isGraphSearchNeeded(SearchOptions searchOptions, HitColoringAndAlignmentOptions options) {
        int searchType = searchOptions.getSearchType();
        boolean searchModeAllowsIt = searchType == 2 || searchType == 6 || searchType == 4 || searchType == 7 || searchType == 8 || searchType == 3;
        boolean alignment = searchType != 6 && options.alignmentMode != 0;
        boolean needed = options.coloring || alignment || options.isRemoveUnusedDefitions() || options.markushDisplayMode != 0;
        return searchModeAllowsIt && needed;
    }

    private void standardizeQuery(Molecule mol) throws SearchException {
        this.standardizer.setActiveGroup("query");
        this.standardizer.setInactiveTasks("removeexplicith");
        this.standardizer.standardize(mol);
    }

    private int[] standardizeTarget(Molecule mol) throws SearchException {
        this.standardizer.setActiveGroup("target");
        this.standardizer.clearInactiveTasks();
        this.standardizer.setAtomIndexQuery(true);
        this.standardizer.standardize(mol);
        return this.standardizer.getNewToOld();
    }

    @Override
    public boolean isLicensed() {
        return true;
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }
}

