/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.common.util.ArrayTools;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.SuperatomSgroup;
import chemaxon.util.HitColoringAndAlignmentOptions;
import chemaxon.util.MolAligner;
import java.util.ArrayList;

public class HitDisplayUtil {
    public static final int SEQ_RESTORE = 63;
    public static final String PROP_ALIGNHIT = "alignHit";
    private static final int HIT_NUM = 1;
    private static final int NON_HIT_NUM = 0;
    private static final int MULTIATOM_HIT_NUM = 2;

    public static Molecule getScaffoldOrientatedHit(Molecule scaffold, Molecule molToAlign) {
        if (scaffold == null) {
            return molToAlign;
        }
        return HitDisplayUtil.getScaffoldOrientatedHit(scaffold, molToAlign, HitDisplayUtil.createHitList(scaffold, molToAlign));
    }

    private static int[] createHitList(Molecule query, Molecule target) {
        int[] hit = new int[query.getAtomCount()];
        for (int i = target.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = target.getAtom(i);
            if (!atom.containsPropertyKey(PROP_ALIGNHIT)) continue;
            int n = (Integer)target.getAtom(i).getProperty(PROP_ALIGNHIT);
            hit[n] = i;
        }
        return hit;
    }

    public static Molecule getScaffoldOrientatedHit(Molecule query, Molecule target, int[] hit) {
        if (hit != null) {
            MolAligner aligner = new MolAligner(query, target);
            aligner.calculate(hit);
            aligner.align();
        }
        return target;
    }

    public static void color(Molecule substructure, Molecule molToColor, HitColoringAndAlignmentOptions options) {
        if (substructure != null) {
            HitDisplayUtil.color(substructure, molToColor, HitDisplayUtil.createHitList(substructure, molToColor), options);
        }
    }

    public static void color(Molecule substructure, Molecule molToColor, int[] hit, HitColoringAndAlignmentOptions options) {
        int atomCount;
        if (!options.coloring) {
            return;
        }
        int sgCount = molToColor.getSgroupCount();
        int[] sgStates = new int[sgCount];
        for (int x = 0; x < sgCount; ++x) {
            Sgroup sg = molToColor.getSgroup(x);
            sgStates[x] = sg.getXState();
        }
        molToColor.expandSgroups();
        MDocument doc = new MDocument(molToColor);
        doc.setAtomSetRGB(0, options.nonHitColor.getRGB());
        doc.setAtomSetRGB(1, options.hitColor.getRGB());
        doc.setAtomSetRGB(2, options.hitHomologyColor.getRGB());
        if (molToColor.getDim() == 3) {
            doc.setBondSetRGB(1, options.nonHitColor3D.getRGB());
        } else {
            doc.setBondSetRGB(1, options.nonHitColor.getRGB());
        }
        for (int y = 0; y < hit.length; ++y) {
            if (hit[y] < 0) continue;
            MolAtom atom = molToColor.getAtom(hit[y]);
            atom.setSetSeq(1);
            for (int x = 0; x < sgCount; ++x) {
                Sgroup sg = molToColor.getSgroup(x);
                if (!(sg instanceof SuperatomSgroup) || !sg.hasAtom(atom)) continue;
                ((SuperatomSgroup)sg).getSuperAtom().setSetSeq(1);
            }
        }
        for (int y = atomCount = substructure.getAtomCount(); y < hit.length; ++y) {
            MolAtom atom;
            if (hit[y] == hit[y - atomCount] || hit[y] < 0 || (atom = molToColor.getAtom(hit[y])).getAtno() != 134) continue;
            for (MolAtom ligAtom : atom.getLigands()) {
                if (ligAtom.getSetSeq() != 1) continue;
                int order = atom.getLigandOrder(ligAtom);
                MolAtom rmAtom = molToColor.getAtom(hit[y - atomCount]);
                for (MolAtom lig : rmAtom.getLigands()) {
                    if (lig.getRgroupAttachmentPointOrder() != order) continue;
                    lig.setSetSeq(1);
                }
            }
        }
        ArrayList<MolBond> nhb = HitDisplayUtil.getNonHitBonds(substructure, molToColor, hit);
        for (MolBond bond : nhb) {
            if (bond.getSetSeq() != 0) continue;
            bond.setSetSeq(1);
        }
        HitDisplayUtil.setMultiAtomHitColor(substructure, molToColor, hit);
        for (int i = 0; i < molToColor.getBondCount(); ++i) {
            MolBond bond;
            bond = molToColor.getBond(i);
            if (bond.getSetSeq() != 63) continue;
            bond.setSetSeq(0);
        }
        for (int x = 0; x < sgCount; ++x) {
            molToColor.getSgroup(x).setXState(sgStates[x]);
        }
    }

    private static void setMultiAtomHitColor(Molecule substructure, Molecule molToColor, int[] hit) {
        int qNum = substructure.getAtomCount();
        if (hit.length == qNum) {
            return;
        }
        int n = molToColor.getBondCount();
        for (int k = 0; k < n; ++k) {
            MolBond b = molToColor.getBond(k);
            int a1 = molToColor.indexOf(b.getAtom1());
            int a2 = molToColor.indexOf(b.getAtom2());
            int qa1 = ArrayTools.indexInArray(hit, a1);
            qa1 = qa1 < 0 ? qa1 : qa1 % qNum;
            int qa2 = ArrayTools.indexInArray(hit, a2);
            int n2 = qa2 = qa2 < 0 ? qa2 : qa2 % qNum;
            if (qa1 == -1 || qa2 == -1 || qa1 != qa2) continue;
            b.getAtom1().setSetSeq(2);
            b.getAtom2().setSetSeq(2);
        }
    }

    protected static ArrayList<MolBond> getNonHitBonds(Molecule query, Molecule target, int[] hit) {
        ArrayList<MolBond> result = new ArrayList<MolBond>();
        int n = target.getBondCount();
        int qNum = query.getAtomCount();
        for (int k = 0; k < n; ++k) {
            MolBond b = target.getBond(k);
            if (qNum != 0) {
                int a1 = target.indexOf(b.getAtom1());
                int a2 = target.indexOf(b.getAtom2());
                int qa1 = ArrayTools.indexInArray(hit, a1);
                int qa3 = ArrayTools.indexInArray(hit, a2);
                int qa4 = qa3;
                if (qa4 != -1) {
                    while (qa4 < hit.length && hit[qa4] == a2) {
                        ++qa4;
                    }
                    --qa4;
                }
                if (((qa1 %= qNum) != -1 || (qa3 %= qNum) != -1 || (qa4 %= qNum) != -1) && (qa1 != -1 && qa3 != -1 && query.getBondTable().getBondIndex(qa1, qa3) != -1 || qa1 == qa3 || qa1 != -1 && !HitDisplayUtil.hasNeighbourInHit(query, qa1, hit) || qa3 != -1 && !HitDisplayUtil.hasNeighbourInHit(query, qa3, hit) || qa1 != -1 && qa4 != -1 && query.getBondTable().getBondIndex(qa1, qa4) != -1 || qa1 == qa4 || qa1 != -1 && !HitDisplayUtil.hasNeighbourInHit(query, qa1, hit) || qa4 != -1 && !HitDisplayUtil.hasNeighbourInHit(query, qa4, hit))) continue;
            }
            result.add(b);
        }
        return result;
    }

    private static boolean hasNeighbourInHit(Molecule mol, int index, int[] hit) {
        MolAtom atom = mol.getAtom(index);
        int bondCount = atom.getBondCount();
        for (int x = 0; x < bondCount; ++x) {
            MolAtom neighbour = atom.getLigand(x);
            int idx = mol.indexOf(neighbour);
            if (hit[idx] < 0) continue;
            return true;
        }
        return false;
    }
}

