/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.util.HttpStreamToFileHandler;
import chemaxon.util.SavedFile;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;

public class HttpStreamToFile {
    private InputStream req;
    private File dir;
    private String serverFileName;
    private String fileContent;
    private String contentType;
    private int contentLength;
    private Hashtable parameters = new Hashtable();
    private Hashtable files = new Hashtable();
    private Hashtable filenames = new Hashtable();
    private int savedData;
    private boolean finished = false;

    public HttpStreamToFile(String requestType, int requestSize, InputStream requestInputStream) {
        this(requestType, requestSize, requestInputStream, null, null);
    }

    public HttpStreamToFile(String requestType, int requestSize, InputStream requestInputStream, String savedDir) {
        this(requestType, requestSize, requestInputStream, savedDir, null);
    }

    public HttpStreamToFile(String requestType, int requestSize, InputStream requestInputStream, String savedDir, String savedFileName) {
        if (requestInputStream == null) {
            throw new IllegalArgumentException(" inputstream of request cant be null");
        }
        if (requestType == null) {
            throw new IllegalArgumentException(" type of request cant be null");
        }
        if (requestSize == 0) {
            throw new IllegalArgumentException("size of request cant be null");
        }
        this.req = requestInputStream;
        this.dir = savedDir == null ? null : new File(savedDir);
        this.serverFileName = savedFileName;
        this.contentType = requestType;
        this.contentLength = requestSize;
        this.savedData = 0;
        if (this.dir != null) {
            if (!this.dir.isDirectory()) {
                throw new IllegalArgumentException("not a directory: " + savedDir);
            }
            if (!this.dir.canWrite()) {
                throw new IllegalArgumentException("not writable:" + savedDir);
            }
        }
    }

    public String getFileContent() {
        return this.fileContent;
    }

    public int getSavedData() {
        return this.savedData;
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public Enumeration getFileParamNames() {
        return this.files.keys();
    }

    public Enumeration getFileNames() {
        return this.filenames.keys();
    }

    public String getParameter(String name) {
        try {
            String pname = (String)this.parameters.get(name);
            if (pname.equals("")) {
                return null;
            }
            return pname;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getFileNameByParam(String name) {
        try {
            SavedFile file = (SavedFile)this.files.get(name);
            return file.getFileName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getFileName() {
        try {
            return (String)this.filenames.keys().nextElement();
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getFileSize() {
        try {
            SavedFile file = (SavedFile)this.filenames.get(this.filenames.keys().nextElement());
            return file.getFileSize();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int getFileSize(String name) {
        try {
            SavedFile file = (SavedFile)this.files.get(name);
            return file.getFileSize();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public String getOldFileName() {
        try {
            SavedFile file = (SavedFile)this.files.get(this.files.keys().nextElement());
            return file.getOldFileName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getOldFileName(String name) {
        try {
            SavedFile file = (SavedFile)this.files.get(name);
            return file.getOldFileName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getContentType(String name) {
        try {
            SavedFile file = (SavedFile)this.files.get(name);
            return file.getContentType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public File getFile() {
        try {
            SavedFile file = (SavedFile)this.filenames.get(this.filenames.keys().nextElement());
            return file.getFile();
        }
        catch (Exception e) {
            return null;
        }
    }

    public File getFile(String name) {
        try {
            SavedFile file = (SavedFile)this.files.get(name);
            return file.getFile();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setFinished(boolean f) {
        this.finished = true;
    }

    public void readAndSaveRequest() throws IOException {
        this.finished = false;
        if (this.contentType == null || !this.contentType.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("posted content type isn't multipart/form-data");
        }
        String boundary = this.extractBoundary(this.contentType);
        if (boundary == null) {
            throw new IOException("seperation boundary was not specified");
        }
        HttpStreamToFileHandler in = new HttpStreamToFileHandler(this.req, boundary, this.contentLength);
        String line = in.readLine();
        this.savedData = in.getTotalRead();
        if (line == null) {
            throw new IOException("corrupt form data: premature ending");
        }
        if (!line.startsWith(boundary)) {
            throw new IOException("corrupt form data: no leading boundary");
        }
        boolean done = false;
        while (!done && !this.finished) {
            done = this.readRequestNextPart(in, boundary);
        }
    }

    protected boolean readRequestNextPart(HttpStreamToFileHandler isHandler, String boundary) throws IOException {
        String line = isHandler.readLine();
        this.savedData = isHandler.getTotalRead();
        if (line == null) {
            return true;
        }
        String[] dispInfo = this.extractDispositionInfo(line);
        String name = dispInfo[1];
        String filename = dispInfo[2];
        line = isHandler.readLine();
        this.savedData = isHandler.getTotalRead();
        if (line == null) {
            return true;
        }
        String contentType = this.extractContentType(line);
        if (contentType != null) {
            line = isHandler.readLine();
            this.savedData = isHandler.getTotalRead();
            if (line == null || line.length() > 0) {
                throw new IOException("malformed line after content type: " + line);
            }
        } else {
            contentType = "application/octet-stream";
        }
        if (filename == null) {
            String value = this.readParameter(isHandler, boundary);
            this.parameters.put(name, value);
        } else {
            int size = isHandler.getTotalRead();
            if (this.serverFileName == null && this.dir != null) {
                this.serverFileName = filename;
            }
            this.readAndSaveFile(isHandler, boundary, this.serverFileName);
            size = isHandler.getTotalRead() - size - boundary.length() - 4;
            if (filename.equals("unknown")) {
                this.filenames.put(this.serverFileName, new SavedFile(null, null, null, null, -1));
                this.files.put(name, new SavedFile(null, null, null, null, -1));
            } else {
                if (this.serverFileName != null) {
                    this.filenames.put(this.serverFileName, new SavedFile(this.dir == null ? null : this.dir.toString(), this.serverFileName, contentType, filename, size));
                }
                this.files.put(name, new SavedFile(this.dir == null ? null : this.dir.toString(), this.serverFileName, contentType, filename, size));
            }
        }
        return false;
    }

    protected String readParameter(HttpStreamToFileHandler isHandler, String boundary) throws IOException {
        String line;
        StringBuffer sbuf = new StringBuffer();
        while ((line = isHandler.readLine()) != null && !this.finished && !line.startsWith(boundary)) {
            sbuf.append(line + "\r\n");
            this.savedData = isHandler.getTotalRead();
        }
        if (sbuf.length() == 0) {
            return null;
        }
        sbuf.setLength(sbuf.length() - 2);
        return sbuf.toString();
    }

    protected void readAndSaveFile(HttpStreamToFileHandler isHandler, String boundary, String filename) throws IOException {
        int result;
        Object ow = null;
        if (filename != null) {
            File f = new File(this.dir + File.separator + filename);
            FileOutputStream fos = new FileOutputStream(f);
            ow = new BufferedOutputStream(fos, 8192);
        } else {
            ow = new StringBuffer();
        }
        byte[] bbuf = new byte[8192];
        char[] cbuf = new char[8192];
        boolean rnflag = false;
        while ((result = isHandler.readLine(bbuf, 0, bbuf.length)) != -1 && !this.finished) {
            InputStreamReader ir;
            String line;
            this.savedData = isHandler.getTotalRead();
            if (result > 2 && bbuf[0] == 45 && bbuf[1] == 45 && (line = new String(bbuf, 0, result, "ISO-8859-1")).startsWith(boundary)) break;
            if (rnflag) {
                if (ow instanceof StringBuffer) {
                    ((StringBuffer)ow).append('\r');
                    ((StringBuffer)ow).append('\n');
                } else {
                    ((BufferedOutputStream)ow).write(13);
                    ((BufferedOutputStream)ow).write(10);
                }
                rnflag = false;
            }
            if (result >= 2 && bbuf[result - 2] == 13 && bbuf[result - 1] == 10) {
                if (ow instanceof StringBuffer) {
                    ir = new InputStreamReader((InputStream)new ByteArrayInputStream(bbuf), "US-ASCII");
                    ir.read(cbuf);
                    ((StringBuffer)ow).append(cbuf, 0, result - 2);
                } else {
                    ((BufferedOutputStream)ow).write(bbuf, 0, result - 2);
                }
                rnflag = true;
                continue;
            }
            if (ow instanceof StringBuffer) {
                ir = new InputStreamReader((InputStream)new ByteArrayInputStream(bbuf), "US-ASCII");
                ir.read(cbuf);
                ((StringBuffer)ow).append(cbuf, 0, result);
                continue;
            }
            ((BufferedOutputStream)ow).write(bbuf, 0, result);
        }
        if (ow instanceof BufferedOutputStream) {
            ((BufferedOutputStream)ow).flush();
            ((BufferedOutputStream)ow).close();
        } else {
            this.fileContent = ((StringBuffer)ow).toString();
        }
    }

    private String extractBoundary(String line) {
        int index = line.indexOf("boundary=");
        if (index == -1) {
            return null;
        }
        String boundary = line.substring(index + 9);
        boundary = "--" + boundary;
        return boundary;
    }

    private String[] extractDispositionInfo(String line) throws IOException {
        String[] retval = new String[3];
        String origline = line;
        line = origline.toLowerCase();
        int start = line.indexOf("content-disposition");
        int end = line.indexOf(";");
        if (start == -1 || end == -1) {
            throw new IOException("cont disposition corrupt" + origline);
        }
        String disposition = line.substring(start + 21, end);
        if (!disposition.equals("form-data")) {
            throw new IOException("invalid content disposition" + disposition);
        }
        start = line.indexOf("name=\"", end);
        end = line.indexOf("\"", start + 7);
        if (start == -1 || end == -1) {
            throw new IOException("content dispostion corrupt" + origline);
        }
        String name = origline.substring(start + 6, end);
        String filename = null;
        start = line.indexOf("filename=\"", end + 2);
        end = line.indexOf("\"", start + 10);
        if (start != -1 && end != -1) {
            filename = origline.substring(start + 10, end);
            int slash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
            if (slash > -1) {
                filename = filename.substring(slash + 1);
            }
            if (filename.equals("")) {
                filename = "unknown";
            }
        }
        retval[0] = disposition;
        retval[1] = name;
        retval[2] = filename;
        return retval;
    }

    private String extractContentType(String line) throws IOException {
        String contentType = null;
        String origline = line;
        if ((line = origline.toLowerCase()).startsWith("content-type")) {
            int start = line.indexOf(" ");
            if (start == -1) {
                throw new IOException("content type corrupt: " + origline);
            }
            contentType = line.substring(start + 1);
        } else if (line.length() != 0) {
            throw new IOException("malformed line after disposition:" + origline);
        }
        return contentType;
    }
}

