/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import java.io.IOException;
import java.io.InputStream;

public class HttpStreamToFileHandler {
    InputStream in;
    String boundary;
    int totalExpected;
    int totalRead = 0;
    byte[] buf = new byte[8192];

    public HttpStreamToFileHandler(InputStream in, String boundary, int totalExpected) {
        this.in = in;
        this.boundary = boundary;
        this.totalExpected = totalExpected;
    }

    public int getTotalRead() {
        return this.totalRead;
    }

    public String readLine() throws IOException {
        int result;
        StringBuffer sbuf = new StringBuffer();
        do {
            if ((result = this.readLine(this.buf, 0, this.buf.length)) == -1) continue;
            sbuf.append(new String(this.buf, 0, result, "ISO-8859-1"));
        } while (result == this.buf.length);
        if (sbuf.length() == 0) {
            return null;
        }
        sbuf.setLength(sbuf.length() - 2);
        return sbuf.toString();
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        if (this.totalRead >= this.totalExpected) {
            return -1;
        }
        int result = 0;
        if (len > 0) {
            int c;
            while ((c = this.in.read()) != -1) {
                b[off++] = (byte)c;
                if (c != 10 && ++result != len) continue;
            }
            if (result <= 0) {
                result = -1;
            }
        }
        if (result > 0) {
            this.totalRead += result;
        }
        return result;
    }
}

