/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.common.util.ByteVector;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;

public class IO {
    public static final Charset ASCII = Charset.forName("US-ASCII");
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static InputStream fileInputStream(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        if (file.getName().toLowerCase().endsWith(".gz")) {
            return new GZIPInputStream(in);
        }
        return in;
    }

    public static BufferedReader bufferedFileReader(File file, Charset charset) throws IOException {
        return new BufferedReader(new InputStreamReader(IO.fileInputStream(file), charset));
    }

    public static BufferedWriter bufferedFileWriter(File file, Charset charset) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        int read;
        int step = 1024;
        ByteVector data = new ByteVector(1024);
        while ((read = in.read(data.elementData, data.size(), 1024)) != -1) {
            data.changeSize(data.size() + read);
            data.ensureCapacity(data.size() + 1024);
        }
        return data.toArray();
    }
}

