/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.common.util.ColorParser;
import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.modules.datatransfer.ClipboardHandler;
import chemaxon.marvin.modules.win.Jacob;
import chemaxon.marvin.modules.win.emf.EMFExporter;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPropertyContainer;
import java.awt.Rectangle;
import java.util.Properties;
import java.util.logging.Logger;

public class ImageExportUtil {
    private static boolean newEMFGeneratorEnabled = true;
    private static EMFExporter emfExporter;
    private static boolean emfExporterStarted;
    private static Thread loader;
    private static Logger log;

    private ImageExportUtil() {
    }

    public static String createImageExporterParameter(Properties settings, String format2, MDocument doc) {
        StringBuffer sb = new StringBuffer();
        String fmt = format2.lastIndexOf(",") == format2.length() && settings == null ? format2.substring(0, format2.length() - 1) : format2;
        sb.append(fmt);
        if (settings != null) {
            if (!fmt.contains(":")) {
                sb.append(":");
            }
            if (settings.get("width") != null) {
                sb.append("w");
                sb.append(settings.get("width"));
                sb.append(",");
                settings.remove("imageScale");
            }
            if (settings.get("height") != null) {
                sb.append("h");
                sb.append(settings.get("height"));
                sb.append(",");
                settings.remove("imageScale");
            }
            if ("true".equals(settings.get("setColoringEnabled")) && doc != null) {
                int i;
                sb.append("setcolors");
                if (doc.getAtomSetSize() > 0 || doc.getBondSetSize() > 0 || doc.getExtraLabelSetSize() > 0) {
                    sb.append(":");
                }
                for (i = 0; i < doc.getAtomSetSize(); ++i) {
                    if (doc.getAtomSetRGB(i) == -1) continue;
                    sb.append("a" + i + ":" + ColorParser.toString(doc.getAtomSetRGB(i)) + ":");
                }
                for (i = 0; i < doc.getBondSetSize(); ++i) {
                    if (doc.getBondSetRGB(i) == -1) continue;
                    sb.append("b" + i + ":" + ColorParser.toString(doc.getBondSetRGB(i)) + ":");
                }
                for (i = 0; i < doc.getExtraLabelSetSize(); ++i) {
                    if (doc.getExtraLabelSetRGBs(i) == -1L) continue;
                    sb.append("l" + i + ":" + ColorParser.toString((int)doc.getExtraLabelSetRGBs(i)) + ":");
                }
                if (sb.lastIndexOf(":") == sb.length() - 1) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                sb.append(",");
            }
            try {
                switch (Integer.parseInt((String)settings.get("chiralitySupport"))) {
                    case 2: {
                        sb.append("chiral_all,");
                        break;
                    }
                    case 0: {
                        sb.append("chiral_off,");
                        break;
                    }
                    case 1: {
                        sb.append("chiral_selected,");
                    }
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (settings.get("imageScale") != null) {
                sb.append("scale" + settings.get("imageScale") + ",");
            }
            if (settings.get("maxScale") != null) {
                sb.append("maxscale" + settings.get("maxScale") + ",");
            }
            if (settings.get("atomsize") != null) {
                sb.append("atsiz" + settings.get("atomsize") + ",");
            }
            if (settings.get("atomFont") != null) {
                sb.append("atomFont:" + settings.get("atomFont") + ",");
            }
            if (settings.get("bondSpacing") != null) {
                sb.append("bondw" + settings.get("bondSpacing") + ",");
            }
            if (settings.get("wireThickness") != null) {
                sb.append("wireThickness" + settings.get("wireThickness") + ",");
            }
            if (settings.get("stickThickness") != null) {
                sb.append("stickThickness" + settings.get("stickThickness") + ",");
            }
            if (settings.get("ballRadius") != null) {
                sb.append("ballRadius" + settings.get("ballRadius") + ",");
            }
            if ("false".equals(settings.get("rgroupsVisible"))) {
                sb.append("noRGroups,");
            }
            if (Boolean.valueOf((String)settings.get("isSketcher")).booleanValue()) {
                if (settings.get("sketchImplicitH") != null) {
                    sb.append("H_" + settings.get("sketchImplicitH") + ",");
                }
                if (settings.get("sketchAnyBond") != null) {
                    sb.append("anybond_" + settings.get("sketchAnyBond") + ",");
                }
                if (settings.get("sketchCarbonVisibility") != null) {
                    sb.append("cv_" + settings.get("sketchCarbonVisibility") + ",");
                }
                if (settings.get("dimension") != null && Integer.parseInt((String)settings.get("dimension")) < 3) {
                    if (settings.get("sketchMolbg2d") != null && !settings.get("sketchMolbg2d").equals("#ffffff")) {
                        sb.append(settings.get("sketchMolbg2d") + ",");
                    }
                } else if (settings.get("sketchMolbg3d") != null && !settings.get("sketchMolbg3d").equals("#000000")) {
                    sb.append(settings.get("sketchMolbg3d") + ",");
                }
                if ("true".equals(settings.get("valenceErrorVisible"))) {
                    sb.append("valenceErrorVisible,");
                }
                if (settings.get("sketchLigandOrderVisibility") != null) {
                    String val = settings.getProperty("sketchLigandOrderVisibility");
                    if (val.equals("showOnlyWithDefinition")) {
                        val = "withDef";
                    }
                    sb.append("ligandOrderVisibility_" + val + ",");
                }
                if (settings.get("sketchColorScheme") != null) {
                    sb.append(settings.get("sketchColorScheme") + ",");
                }
            } else {
                if (settings.get("viewImplicitH") != null) {
                    sb.append("H_" + settings.get("viewImplicitH") + ",");
                }
                if (settings.get("viewAnyBond") != null) {
                    sb.append("anybond_" + settings.get("viewAnyBond") + ",");
                }
                if (settings.get("viewCarbonVisibility") != null) {
                    sb.append("cv_" + settings.get("viewCarbonVisibility") + ",");
                }
                if (settings.get("dimension") != null && Integer.parseInt((String)settings.get("dimension")) < 3) {
                    if (settings.get("viewMolbg2d") != null && !settings.get("viewMolbg2d").equals("#ffffff")) {
                        sb.append(settings.get("viewMolbg2d") + ",");
                    }
                } else if (settings.get("viewMolbg3d") != null && !settings.get("viewMolbg3d").equals("#000000")) {
                    sb.append(settings.get("viewMolbg3d") + ",");
                }
                if ("true".equals(settings.get("valenceErrorVisibleInView"))) {
                    sb.append("valenceErrorVisible,");
                }
                if (settings.get("viewLigandOrderVisibility") != null) {
                    String val = settings.getProperty("viewLigandOrderVisibility");
                    if (val.equals("showOnlyWithDefinition")) {
                        val = "withDef";
                    }
                    sb.append("ligandOrderVisibility_" + val + ",");
                }
                if (settings.get("viewColorScheme") != null) {
                    sb.append(settings.get("viewColorScheme") + ",");
                }
            }
            if (Boolean.valueOf((String)settings.get("noAntialias")).booleanValue()) {
                sb.append("noantialias,");
            }
            if (Boolean.valueOf((String)settings.get("atomMappingVisible")).booleanValue()) {
                sb.append("amap,");
            }
            if (Boolean.valueOf((String)settings.get("atomNumbersVisible")).booleanValue()) {
                sb.append("anum,");
            }
            if (Boolean.valueOf((String)settings.get("atomPropertiesVisible")).booleanValue()) {
                sb.append("aprop,");
            }
            if (Boolean.valueOf((String)settings.get("valencePropertyVisible")).booleanValue()) {
                sb.append("valprop,");
            }
            if (Boolean.valueOf((String)settings.get("ligandErrorVisible")).booleanValue()) {
                sb.append("liganderr,");
            }
            if (Boolean.valueOf((String)settings.get("lonePairsVisible")).booleanValue()) {
                if (!Boolean.valueOf((String)settings.get("lonePairsAutoCalc")).booleanValue()) {
                    sb.append("lpexpl,");
                } else {
                    sb.append("lp,");
                }
            }
            if (settings.get("dimension") != null && Integer.parseInt((String)settings.get("dimension")) > 2 && Boolean.valueOf((String)settings.get("noAtomSymbols3D")).booleanValue()) {
                sb.append("noatsym,");
            }
            if (Boolean.valueOf((String)settings.get("EZVisible")).booleanValue()) {
                sb.append("ez,");
            }
            if (settings.get("downWedge") != null) {
                sb.append("downwedge_" + settings.get("downWedge") + ",");
            }
            if (settings.get("coordinateBondStyle") != null) {
                sb.append("coordBondStyle_" + settings.get("coordinateBondStyle") + ",");
            }
            if (settings.get("coordinateBondStyleAtMulticenter") != null) {
                sb.append("coordBondStyleAtMulticenter_" + settings.get("coordinateBondStyleAtMulticenter") + ",");
            }
            if ("true".equals(settings.get("grinvVisible"))) {
                sb.append("grinvVisible,");
            }
            if ("true".equals(settings.get("bondLengthVisible"))) {
                sb.append("bondLengthVisible,");
            }
            if ("true".equals(settings.get("absLabelVisible"))) {
                sb.append("absLabelVisible,");
            }
            if ("true".equals(settings.get("transbg"))) {
                sb.append("transbg,");
            }
            if (newEMFGeneratorEnabled && settings.get("rendering") != null) {
                sb.append(settings.get("rendering"));
            } else {
                sb.append("wireframe");
            }
        }
        return sb.toString();
    }

    public static Properties mergeProperties(UserSettings settings, MPropertyContainer guiprops, Rectangle r) {
        Properties props = new Properties();
        props.putAll(settings.getPropertyMap());
        if (guiprops != null) {
            String[] gpkeys = guiprops.getKeys();
            for (int i = 0; i < gpkeys.length; ++i) {
                props.setProperty(gpkeys[i], guiprops.getString(gpkeys[i]));
            }
        }
        if (r != null) {
            props.setProperty("width", Integer.toString(r.width));
            props.setProperty("height", Integer.toString(r.height));
        }
        return props;
    }

    public static synchronized void startEMFGenerator() {
        log.entering("ExportUtil", "startEMFGenerator");
        if (emfExporterStarted) {
            log.info("EmfExporter has already started.");
            log.exiting("ImageExportUtil", "startEMFGenerator");
            return;
        }
        if (!Jacob.getInstance().isSupported()) {
            newEMFGeneratorEnabled = false;
        }
        if (!newEMFGeneratorEnabled) {
            log.fine("New EMF generator failed and disabled, returning.");
            return;
        }
        loader = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    log.fine("Starting new EMF Exporter.");
                    emfExporter = Jacob.getInstance().getEMFExporter();
                    emfExporter.setFormat("mrv");
                    emfExporter.setMolecule("<?xml version=\"1.0\" ?><cml><MDocument></MDocument></cml>");
                    emfExporter.setParams("emf");
                    log.fine("Starting export empty molecule to binary format.");
                    emfExporter.exportToEMFBinary();
                    log.fine("Success.");
                    return;
                }
                catch (Throwable ex) {
                    log.throwing("ExportUtil", "startEMFGenerator", ex);
                    newEMFGeneratorEnabled = false;
                    log.fine("Failure.");
                    return;
                }
            }
        });
        loader.setPriority(1);
        loader.start();
        log.fine("Initialization has been enqueued for processing.");
        emfExporterStarted = true;
    }

    public static void disableNewEmfGenerator() {
        log.entering("ExportUtil", "disableNewEmfGenerator");
        ImageExportUtil.releaseNewEMFGenerator();
        newEMFGeneratorEnabled = false;
        log.exiting("ExportUtil", "disableNewEmfGenerator");
    }

    public static byte[] createEMF(String mrvSource, String exporterParamStr) {
        log.entering("ExportUtil", "createEMF");
        log.fine("Ensure that new EMF generator architecture is started.");
        ImageExportUtil.ensureGeneratorState();
        if (newEMFGeneratorEnabled) {
            try {
                log.fine("creating EMF");
                emfExporter.setFormat("mrv");
                emfExporter.setMolecule(mrvSource);
                emfExporter.setParams(exporterParamStr);
                return emfExporter.exportToEMFBinary();
            }
            catch (Throwable ex) {
                log.throwing("ExportUtil", "createEMF", ex);
                newEMFGeneratorEnabled = false;
            }
        }
        log.fine("Generator could not be initialized.");
        return null;
    }

    public static boolean generateEMFToFile(String mrvSource, String exporterParamStr, String fileName) {
        ImageExportUtil.ensureGeneratorState();
        if (newEMFGeneratorEnabled) {
            try {
                emfExporter.setFormat("mrv");
                emfExporter.setMolecule(mrvSource);
                emfExporter.setParams(exporterParamStr);
                emfExporter.exportToFile(fileName);
                return true;
            }
            catch (Throwable ex) {
                newEMFGeneratorEnabled = false;
            }
        }
        return false;
    }

    private static void ensureGeneratorState() {
        log.entering("ExportUtil", "ensureGeneratorState");
        if (!Jacob.getInstance().isSupported()) {
            ImageExportUtil.disableNewEmfGenerator();
        }
        if (!emfExporterStarted) {
            log.fine("New EMF generator has not been started yet, starting it.");
            ImageExportUtil.startEMFGenerator();
        }
        try {
            log.fine("Waiting EMF generator initialization finish.");
            if (loader != null) {
                loader.join();
            }
            if (emfExporter == null) {
                newEMFGeneratorEnabled = false;
            }
            log.fine("EMF generator started.");
        }
        catch (InterruptedException e) {
            log.throwing("ExportUtil", "ensureGeneratorState", e);
            log.fine("Starting of new EMF generator has been cancelled.");
            newEMFGeneratorEnabled = false;
        }
        log.exiting("ExportUtil", "ensureGeneratorState");
    }

    public static void releaseNewEMFGenerator() {
        log.entering("ImageExportUtil", "releaseNewEMFGenerator");
        if (loader != null) {
            try {
                loader.join();
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
        }
        if (emfExporter != null) {
            log.fine("EMFExporter not null, dispose and release.");
            try {
                emfExporter.release();
                log.fine("Disposed and released the new emf exporter.");
            }
            catch (Throwable e) {
                log.throwing("ImageExportUtil", "releasePermanentResources", e);
            }
        }
        emfExporter = null;
        emfExporterStarted = false;
        log.fine("EmfExport reference set to null.");
        log.exiting("ImageExportUtil", "releaseNewEMFGenerator");
    }

    static {
        emfExporterStarted = false;
        loader = null;
        log = ClipboardHandler.getLog();
    }
}

