/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import java.util.LinkedList;
import java.util.NoSuchElementException;

public class LinearBuffer {
    public final Object slotLock = new Object();
    public final Object readerLock = new Object();
    private int maxSize = 0;
    LinkedList slots = new LinkedList();

    public LinearBuffer(int maxSize) {
        this.maxSize = maxSize;
    }

    public synchronized Slot getSlot() {
        if (this.slots.size() < this.maxSize) {
            Slot slot = new Slot();
            this.slots.addLast(slot);
            return slot;
        }
        return null;
    }

    public synchronized Object getNextObject() {
        Slot firstSlot = null;
        try {
            firstSlot = (Slot)this.slots.getFirst();
        }
        catch (NoSuchElementException e) {
            return null;
        }
        Object data = firstSlot.data;
        if (data != null) {
            this.slots.removeFirst();
            return data;
        }
        return null;
    }

    public synchronized void cancelSlot(Slot slot) {
        this.slots.remove(slot);
    }

    public class Slot {
        private volatile Object data = null;

        public void setData(Object data) {
            this.data = data;
        }
    }
}

