/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.common.util.ArrayTools;
import chemaxon.formats.MFileFormat;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.PositionedInputStream;
import chemaxon.sss.screen.ScreenMol;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.util.BinaryDataUtil;
import chemaxon.util.ErrorHandler;
import chemaxon.util.HitDisplayUtil;
import chemaxon.util.MolAligner;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class MolHandler
extends ErrorHandler {
    Molecule mol = null;
    MolAligner molAligner = null;
    boolean molAlignerSet = false;
    boolean queryMode = false;
    private static String[] daylightFormats = new String[]{"smiles", "smarts", "smirks", "chuckles", "chortles", "charts"};

    public MolHandler() {
        this.mol = null;
    }

    public MolHandler(Molecule mol) {
        this.mol = mol;
    }

    public MolHandler(String molecule) throws MolFormatException {
        this.setMolecule(molecule);
    }

    public MolHandler(String molecule, boolean queryMode) throws MolFormatException {
        this.setQueryMode(queryMode);
        this.setMolecule(molecule);
    }

    public MolHandler(byte[] molecule) throws MolFormatException {
        this.setMolecule(molecule);
    }

    public MolHandler(byte[] molecule, boolean queryMode) throws MolFormatException {
        this.setQueryMode(queryMode);
        this.setMolecule(molecule);
    }

    public void setMolecule(Molecule molecule) {
        this.mol = molecule;
        this.molAlignerSet = false;
    }

    public void setMolecule(String molecule) throws MolFormatException {
        this.mol = this.importMol(molecule.getBytes());
        this.molAlignerSet = false;
    }

    public void setMolecule_SNE(String molecule) {
        try {
            this.setMolecule(molecule);
        }
        catch (Throwable e) {
            this.exception = e;
        }
    }

    public void setMolecule(byte[] molecule) throws MolFormatException {
        this.mol = this.importMol(molecule);
        this.molAlignerSet = false;
    }

    public void setMolecule_BNE(byte[] molecule) {
        try {
            this.setMolecule(molecule);
        }
        catch (Throwable e) {
            this.exception = e;
        }
    }

    public Molecule getMolecule() {
        return this.mol;
    }

    public int getAtomCount() {
        return this.mol.getAtomCount();
    }

    public int getHeavyAtomCount() {
        int count = this.mol.getAtomCount();
        int atCount = 0;
        for (int i = 0; i < count; ++i) {
            MolAtom atom = this.mol.getAtom(i);
            if (atom.getAtno() == 1) continue;
            ++atCount;
        }
        return atCount;
    }

    public void addHydrogens() {
        this.mol.hydrogenize(true);
        this.molAlignerSet = false;
    }

    public void addHydrogensToAromaticHeteroAtoms() {
        int count = this.mol.getAtomCount();
        for (int i = 0; i < count; ++i) {
            MolAtom atom = this.mol.getAtom(i);
            if (atom.getAtno() == 1 || atom.getAtno() == 6 || atom.getBondCount() <= 0 || atom.getBond(0).getType() != 4) continue;
            int implicitH = atom.getImplicitHcount();
            for (int j = 0; j < implicitH; ++j) {
                MolAtom h = new MolAtom(1);
                this.mol.add(h);
                MolBond bond = new MolBond(atom, h);
                this.mol.add(bond);
            }
            if (implicitH <= 0) continue;
            atom.valenceCheck();
        }
        this.molAlignerSet = false;
    }

    public void removeHydrogens() {
        this.mol.hydrogenize(false);
        this.molAlignerSet = false;
    }

    public void removeHydrogensFromCarbons() {
        MolAtom atom;
        int i;
        int count = this.mol.getAtomCount();
        MolAtom[] a = new MolAtom[count];
        for (i = 0; i < count; ++i) {
            a[i] = atom = this.mol.getAtom(i);
        }
        for (i = 0; i < count; ++i) {
            MolAtom neighbor;
            atom = a[i];
            if (atom.getAtno() != 1 || atom.getBondCount() != 1 || (neighbor = atom.getLigand(0)).getAtno() != 6) continue;
            this.mol.removeAtom(atom);
            neighbor.valenceCheck();
        }
        this.molAlignerSet = false;
    }

    public boolean containsHydrogens() {
        int count = this.mol.getAtomCount();
        for (int i = 0; i < count; ++i) {
            MolAtom atom = this.mol.getAtom(i);
            if (atom.getAtno() != 1) continue;
            return true;
        }
        return false;
    }

    public void aromatize() {
        this.mol.aromatize();
    }

    public void aromatize(int method) {
        this.mol.aromatize(method);
    }

    public float calcMolWeight() {
        return (float)this.calcMolWeightInDouble();
    }

    public double calcMolWeightInDouble() {
        return this.mol.getMass();
    }

    public String calcMolFormula() {
        return this.mol.getFormula();
    }

    public void clean(boolean always, String options) {
        if (always || this.mol.getDim() == 0) {
            this.mol.clean(2, options);
        }
        this.molAlignerSet = false;
    }

    public String toFormat(String format2) {
        return this.getMolecule().toFormat(format2);
    }

    public byte[] toBinFormat(String format2) {
        return this.getMolecule().toBinFormat(format2);
    }

    public byte[] getFingerprintInBytes(int numberOfBits, int numberOfOnes, int numberOfBonds) {
        this.aromatize();
        return this.generateFingerprintInBytes(numberOfBits / 32, numberOfOnes, numberOfBonds);
    }

    public int[] getFingerprintInInts(int numberOfBits, int numberOfOnes, int numberOfBonds) {
        this.aromatize();
        byte[] fpb = this.generateFingerprintInBytes(numberOfBits / 32, numberOfOnes, numberOfBonds);
        int numberOfInts = BinaryDataUtil.translateBitCountToIntCount(numberOfBits);
        int[] fingerprint = new int[numberOfInts];
        for (int i = 0; i < numberOfInts; ++i) {
            fingerprint[i] = BinaryDataUtil.getFingerprintInInt(fpb, i);
        }
        return fingerprint;
    }

    public int[] generateFingerprintInInts(int numberOfInts, int numberOfOnes, int numberOfBonds) {
        byte[] fpb = this.generateFingerprintInBytes(numberOfInts, numberOfOnes, numberOfBonds);
        int[] fingerprint = new int[numberOfInts];
        for (int i = 0; i < numberOfInts; ++i) {
            fingerprint[i] = BinaryDataUtil.getFingerprintInInt(fpb, i);
        }
        return fingerprint;
    }

    public byte[] generateFingerprintInBytes(int numberOfInts, int numberOfOnes, int numberOfBonds) {
        return ScreenMol.fingerprint(this.mol, numberOfInts * 4, numberOfBonds, numberOfOnes, -1, true);
    }

    public int getImplicitHCount() {
        int ac = this.mol.getAtomCount();
        int count = 0;
        for (int i = 0; i < ac; ++i) {
            MolAtom atom = this.mol.getAtom(i);
            count += atom.getImplicitHcount();
        }
        return count;
    }

    public double align(Molecule mol, int[] indexes) throws IllegalArgumentException {
        if (this.molAligner == null) {
            this.molAligner = new MolAligner();
        }
        if (!this.molAlignerSet) {
            this.molAligner.setPatternMolecule(this.mol);
            this.molAlignerSet = true;
        }
        this.molAligner.setTargetMolecule(mol);
        this.molAligner.align(indexes);
        return this.molAligner.getError();
    }

    public static ArrayList getNonHitBondEndpoints(Molecule query, Molecule target, int[] hit) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        int n = target.getBondCount();
        for (int k = 0; k < n; ++k) {
            MolBond b = target.getBond(k);
            int a1 = target.indexOf(b.getAtom1());
            int a2 = target.indexOf(b.getAtom2());
            int qa1 = ArrayTools.indexInArray(hit, a1);
            int qa2 = ArrayTools.indexInArray(hit, a2);
            if (qa1 != -1 && qa2 != -1 && query.getBondTable().getBondIndex(qa1, qa2) != -1 || qa1 != -1 && query.getAtom(qa1).getBondCount() == 0 || qa2 != -1 && query.getAtom(qa2).getBondCount() == 0) continue;
            int[] bond = new int[]{a1, a2};
            result.add(bond);
        }
        return result;
    }

    public static ArrayList getNonHitBonds(Molecule query, Molecule target, int[] hit) {
        return HitDisplayUtil.getNonHitBonds(query, target, hit);
    }

    public boolean getQueryMode() {
        return this.queryMode;
    }

    public void setQueryMode(boolean q) {
        this.queryMode = q;
    }

    private Molecule importMol(byte[] b) throws MolFormatException {
        if (b == null) {
            return null;
        }
        if (b.length == 0) {
            return new Molecule();
        }
        PositionedInputStream mis = null;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(b);
            mis = new MolInputStream(is);
            MolImporter mi = new MolImporter(mis);
            mi.setQueryMode(this.queryMode);
            return mi.read();
        }
        catch (MolFormatException ex) {
            throw ex;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            int l = mis != null ? mis.getLineCount() : 0;
            throw MolHandler.toMolFormatException(ex, l);
        }
    }

    private static MolFormatException toMolFormatException(Exception ex, int l) {
        StringBuffer msg = new StringBuffer();
        if (l > 0) {
            msg.append("Line " + l);
            msg.append(": ");
        }
        msg.append(ex.toString());
        return new MolFormatException(msg.toString());
    }

    public static Molecule readFromVMN(MRecord rec) throws IOException {
        MolImportModule importMod = MFileFormat.VMN.createImportModule();
        importMod.initMolImport(rec, null);
        Molecule mol = importMod.createMol();
        mol.clearProperties();
        mol.setInputFormat(rec.getInputFormat());
        if (!importMod.readMol(mol)) {
            throw new MolFormatException("Molecule cannot be imported");
        }
        return mol;
    }

    public static boolean isDaylightFormat(String format2) {
        String s;
        int i;
        if (format2 == null) {
            return false;
        }
        for (i = 0; i < daylightFormats.length; ++i) {
            s = daylightFormats[i];
            if (!format2.equalsIgnoreCase(s)) continue;
            return true;
        }
        if (format2.startsWith("cx")) {
            for (i = 0; i < daylightFormats.length; ++i) {
                s = daylightFormats[i];
                if (!format2.endsWith(s) || format2.length() != s.length() + 2) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPlainH(MolAtom atom) {
        return atom.getAtno() == 1 && atom.getMassno() == 0 && atom.getCharge() == 0;
    }

    public static void main(String[] args) throws MolFormatException, IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(" ".getBytes());
        MolInputStream mis = new MolInputStream(is);
        MolImporter mi = new MolImporter(mis);
        mi.setQueryMode(false);
        System.err.println(mi.read().toFormat("mrv"));
    }
}

