/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import java.util.Arrays;

public class NumberUtil {
    public static final int MAX_DENOMINATOR_DEF = 10;
    private int n = 0;
    private double epsilon1 = 0.0;
    private double epsilon2 = 0.0;
    private double[] fraction2double = null;

    public NumberUtil() {
        this(10);
    }

    public NumberUtil(int n) {
        this.n = n;
        this.fraction2double = new double[n * (n - 1) / 2];
        Arrays.fill(this.fraction2double, Double.NaN);
        this.epsilon1 = 1.0 / (double)n * 0.5;
        this.epsilon2 = 1.0 / ((double)n * (double)n) * 0.5;
    }

    public int[] findFraction(double x) {
        int k;
        int sign = 1;
        if (x < 0.0) {
            sign = -1;
            x = -x;
        }
        if ((x -= (double)(k = (int)Math.floor(x))) < this.epsilon1) {
            return new int[]{sign * k, 1};
        }
        if (x > 1.0 - this.epsilon1) {
            return new int[]{sign * (k + 1), 1};
        }
        double mindiff = 1.0;
        int a = -1;
        int b = -1;
        int i = 0;
        for (int d = 1; d <= this.n; ++d) {
            int b0 = d + 1;
            for (int a0 = 1; a0 <= d; ++a0) {
                double diff;
                if (Double.isNaN(this.fraction2double[i])) {
                    this.fraction2double[i] = (double)a0 / (double)b0;
                }
                if ((diff = Math.abs(this.fraction2double[i] - x)) < mindiff) {
                    a = a0;
                    b = b0;
                    if (diff < this.epsilon2) {
                        return new int[]{sign * (a + k * b), b};
                    }
                    mindiff = diff;
                }
                ++i;
            }
        }
        return new int[]{sign * (a + k * b), b};
    }

    public static int findGreatestCommonDivisor(int[] x) {
        if (x.length == 0) {
            return 0;
        }
        if (x.length == 1) {
            return Math.abs(x[0]);
        }
        int d = NumberUtil.findGreatestCommonDivisor(x[0], x[1]);
        for (int i = 2; i < x.length; ++i) {
            d = NumberUtil.findGreatestCommonDivisor(d, x[i]);
        }
        return d;
    }

    public static int findGreatestCommonDivisor(int x1, int x2) {
        if (x1 < 0) {
            x1 = -x1;
        }
        if (x2 < 0) {
            x2 = -x2;
        }
        if (x1 > x2) {
            int tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        return NumberUtil.gcd(x1, x2);
    }

    private static int gcd(int x1, int x2) {
        if (x1 == 0) {
            return x2;
        }
        return NumberUtil.gcd(x2 %= x1, x1);
    }

    public static boolean[] byteToBooleanArray(byte number) {
        boolean[] result = new boolean[8];
        for (int x = 0; x < 8; ++x) {
            int mask = 1 << x;
            if ((number & mask) == 0) continue;
            result[7 - x] = true;
        }
        return result;
    }

    public static String bytesToString(byte[] numbers) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < numbers.length; ++i) {
            boolean[] b = NumberUtil.byteToBooleanArray(numbers[i]);
            for (int j = 0; j < b.length; ++j) {
                buffer.append(b[j] ? "1" : "0");
            }
        }
        return new String(buffer);
    }

    public static boolean[] intToBooleanArray(int number) {
        boolean[] result = new boolean[32];
        for (int x = 0; x < 32; ++x) {
            int mask = 1 << x;
            if ((number & mask) == 0) continue;
            result[31 - x] = true;
        }
        return result;
    }

    public static String intsToString(int[] numbers) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < numbers.length; ++i) {
            boolean[] b = NumberUtil.intToBooleanArray(numbers[i]);
            for (int j = 0; j < b.length; ++j) {
                buffer.append(b[j] ? "1" : "0");
            }
        }
        return new String(buffer);
    }
}

