/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.util.LoggingUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.InputStreamPumper;
import org.apache.commons.exec.StreamPumper;
import org.apache.commons.exec.util.DebugUtils;

public class ProcessManager {
    private CommandLine commandLine;
    private ByteArrayOutputStream stdout = new ByteArrayOutputStream();
    private ByteArrayOutputStream stderr = new ByteArrayOutputStream();
    private PumpStreamHandler111 pump = new PumpStreamHandler111(this.stdout, this.stderr);
    private static final Logger logger = LoggingUtil.getLogger(ProcessManager.class);

    public ProcessManager(CommandLine commandLine) {
        this.commandLine = commandLine;
    }

    public String getStdout() {
        return this.stdout.toString();
    }

    public String getStderr() {
        return this.stderr.toString();
    }

    public Integer waitFor() throws ExecuteException, IOException {
        MyExecutor exec = new MyExecutor();
        exec.setExitValues(null);
        exec.setStreamHandler(this.pump);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        ExecuteWatchdog watchDog = new ExecuteWatchdog(-1L);
        exec.setWatchdog(watchDog);
        logger.fine("Starting process: " + this.commandLine);
        exec.execute(this.commandLine, (ExecuteResultHandler)handler);
        logger.fine("Started process : " + this.commandLine);
        try {
            handler.waitFor(5000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        logger.finest("Process finished");
        String errors = this.stderr.toString();
        if (errors != null && errors.length() > 0) {
            logger.warning(errors);
        }
        if (!handler.hasResult()) {
            logger.log(Level.WARNING, "Process failed");
            watchDog.destroyProcess();
            this.pump.setStopTimeout(1000L);
            try {
                this.pump.stopREMOVE_THIS();
            }
            catch (ExecuteException e) {
                logger.log(Level.WARNING, "pump.stop timed out", e);
            }
            exec.getExecutorThread().interrupt();
            return null;
        }
        if (handler.getException() != null) {
            logger.log(Level.WARNING, "Process failed", handler.getException());
            return null;
        }
        return handler.getExitValue();
    }

    public class PumpStreamHandler111
    implements ExecuteStreamHandler {
        private static final long STOP_TIMEOUT_ADDITION = 2000L;
        private Thread outputThread;
        private Thread errorThread;
        private Thread inputThread;
        private final OutputStream out;
        private final OutputStream err;
        private final InputStream input;
        private InputStreamPumper inputStreamPumper;
        private long stopTimeout;
        private IOException caught = null;

        public PumpStreamHandler111() {
            this(System.out, System.err);
        }

        public PumpStreamHandler111(OutputStream outAndErr) {
            this(outAndErr, outAndErr);
        }

        public PumpStreamHandler111(OutputStream out, OutputStream err) {
            this(out, err, null);
        }

        public PumpStreamHandler111(OutputStream out, OutputStream err, InputStream input) {
            this.out = out;
            this.err = err;
            this.input = input;
        }

        public void setStopTimeout(long timeout) {
            this.stopTimeout = timeout;
        }

        public void setProcessOutputStream(InputStream is) {
            if (this.out != null) {
                this.createProcessOutputPump(is, this.out);
            }
        }

        public void setProcessErrorStream(InputStream is) {
            if (this.err != null) {
                this.createProcessErrorPump(is, this.err);
            }
        }

        public void setProcessInputStream(OutputStream os) {
            if (this.input != null) {
                this.inputThread = this.input == System.in ? this.createSystemInPump(this.input, os) : this.createPump(this.input, os, true);
            } else {
                try {
                    os.close();
                }
                catch (IOException e) {
                    String msg = "Got exception while closing output stream";
                    DebugUtils.handleException((String)msg, (Exception)e);
                }
            }
        }

        public void start() {
            if (this.outputThread != null) {
                this.outputThread.start();
            }
            if (this.errorThread != null) {
                this.errorThread.start();
            }
            if (this.inputThread != null) {
                this.inputThread.start();
            }
        }

        public void stop() {
            try {
                this.stopREMOVE_THIS();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void stopREMOVE_THIS() throws IOException {
            String msg;
            if (this.inputStreamPumper != null) {
                this.inputStreamPumper.stopProcessing();
            }
            this.stopThread(this.outputThread, this.stopTimeout);
            this.stopThread(this.errorThread, this.stopTimeout);
            this.stopThread(this.inputThread, this.stopTimeout);
            if (this.err != null && this.err != this.out) {
                try {
                    this.err.flush();
                }
                catch (IOException e) {
                    msg = "Got exception while flushing the error stream : " + e.getMessage();
                    DebugUtils.handleException((String)msg, (Exception)e);
                }
            }
            if (this.out != null) {
                try {
                    this.out.flush();
                }
                catch (IOException e) {
                    msg = "Got exception while flushing the output stream";
                    DebugUtils.handleException((String)msg, (Exception)e);
                }
            }
            if (this.caught != null) {
                throw this.caught;
            }
        }

        protected OutputStream getErr() {
            return this.err;
        }

        protected OutputStream getOut() {
            return this.out;
        }

        protected void createProcessOutputPump(InputStream is, OutputStream os) {
            this.outputThread = this.createPump(is, os);
        }

        protected void createProcessErrorPump(InputStream is, OutputStream os) {
            this.errorThread = this.createPump(is, os);
        }

        protected Thread createPump(InputStream is, OutputStream os) {
            boolean closeWhenExhausted = os instanceof PipedOutputStream;
            return this.createPump(is, os, closeWhenExhausted);
        }

        protected Thread createPump(InputStream is, OutputStream os, boolean closeWhenExhausted) {
            Thread result = new Thread((Runnable)new StreamPumper(is, os, closeWhenExhausted), "Exec Stream Pumper");
            result.setDaemon(true);
            return result;
        }

        protected void stopThread(Thread thread, long timeout) {
            if (thread != null) {
                try {
                    if (timeout == 0L) {
                        thread.join();
                    } else {
                        long timeToWait = timeout + 2000L;
                        long startTime = System.currentTimeMillis();
                        thread.join(timeToWait);
                        if (System.currentTimeMillis() >= startTime + timeToWait) {
                            String msg = "The stop timeout of " + timeout + " ms was exceeded";
                            this.caught = new ExecuteException(msg, -559038737);
                        }
                    }
                }
                catch (InterruptedException e) {
                    thread.interrupt();
                }
            }
        }

        private Thread createSystemInPump(InputStream is, OutputStream os) {
            this.inputStreamPumper = new InputStreamPumper(is, os);
            Thread result = new Thread((Runnable)this.inputStreamPumper, "Exec Input Stream Pumper");
            result.setDaemon(true);
            return result;
        }
    }

    private static class MyExecutor
    extends DefaultExecutor {
        private MyExecutor() {
        }

        protected Thread getExecutorThread() {
            return super.getExecutorThread();
        }
    }
}

