/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.core.calculations.BondClassifier;
import chemaxon.core.calculations.RingClassifier;
import chemaxon.enumeration.homology.StaticRgMoleculeUtil;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.util.RgMoleculeRingClassifier;
import chemaxon.util.RingMembership;
import chemaxon.util.RingMembershipRecord;
import java.util.ArrayList;
import java.util.List;

public class RgMoleculeBondClassifier
implements RingClassifier,
RgMoleculeRingClassifier {
    private RgMolecule rgMol = null;
    private MoleculeGraph union = null;
    private BondClassifier unionClassifier = null;
    private BondClassifier bondClassifier = null;
    private StaticRgMoleculeUtil srgm = null;
    private int[][] ctab = null;
    private RingMembershipRecord[] ringMembershipRecords = null;

    @Override
    public void classify(MoleculeGraph graph) {
        if (!(graph instanceof Molecule)) {
            throw new IllegalArgumentException("RgMoleculeBondClassifier accepts only Molecule objects.");
        }
        if (graph instanceof RgMolecule) {
            this.rgMol = (RgMolecule)graph;
        } else {
            this.rgMol = new RgMolecule();
            this.rgMol.setRoot((Molecule)graph);
        }
        this.union = this.rgMol.getGraphUnion();
        this.ringMembershipRecords = new RingMembershipRecord[this.union.getAtomCount()];
        for (int i = 0; i < this.ringMembershipRecords.length; ++i) {
            this.ringMembershipRecords[i] = new RingMembershipRecord();
        }
        this.bondClassifier = new BondClassifier();
        this.unionClassifier = new BondClassifier();
        this.unionClassifier.classify(this.union);
        this.srgm = new StaticRgMoleculeUtil(this.rgMol);
    }

    @Override
    public boolean isRingAtom(int i) {
        return this.getRingmembershipOfAtom(i) == RingMembership.IN_RING;
    }

    @Override
    public boolean isRingBond(int i, int j) {
        return this.getRingmembershipOfBond(i, j) == RingMembership.IN_RING;
    }

    private RingMembership getRingmembership(int l1, int a, int l2) {
        if (a < 0) {
            return RingMembership.NOT_RING;
        }
        RingMembership rm = this.ringMembershipRecords[a].getRingMembership(l1, a, l2);
        if (rm != null) {
            return rm;
        }
        MolAtom atom = this.union.getAtom(a);
        MoleculeGraph p = atom.getParent();
        if (!(p instanceof Molecule)) {
            return RingMembership.NOT_RING;
        }
        Molecule def = (Molecule)p;
        int bondAndAttach = MolImportUtil.countBondsAndAttachments(atom);
        if (bondAndAttach < 2 && (bondAndAttach != 1 || atom.getAtno() != 138)) {
            this.ringMembershipRecords[a].setRingMembership(l1, a, l2, RingMembership.NOT_RING);
            return RingMembership.NOT_RING;
        }
        if (this.areAllInRingInUnion(l1, a, l2)) {
            this.ringMembershipRecords[a].setRingMembership(l1, a, l2, RingMembership.IN_RING);
            return RingMembership.IN_RING;
        }
        return this.getRingmembershipThroughParents(l1, a, l2, def);
    }

    private RingMembership getRingmembershipThroughParents(int l1, int a, int l2, Molecule def) {
        MolAtom[] attachAtoms = MolImportUtil.getAttachments(def);
        if (def.getAtomCount() == 1 && attachAtoms.length == 0) {
            int[] parentRAtoms = this.getParentRAtoms(a);
            if (parentRAtoms.length == 0) {
                this.ringMembershipRecords[a].setRingMembership(l1, a, l2, RingMembership.NOT_RING);
                return RingMembership.NOT_RING;
            }
            for (int parentRAtomIndex : parentRAtoms) {
                this.getParentsParentWalksAndAddIt(new int[]{-1, a, -1}, new int[]{-1, parentRAtomIndex, -1}, new IntVector());
            }
            this.ringMembershipRecords[a].mergeParentWalks(l1, a, l2);
            return this.ringMembershipRecords[a].getRingMembership(l1, a, l2);
        }
        IntVector parentRAtoms = new IntVector(this.getParentRAtoms(a));
        ArrayList<IntVector> walkTillParent = this.initWalkTillParents(parentRAtoms);
        for (int parentIndex = 0; parentIndex < parentRAtoms.size(); ++parentIndex) {
            int rAtomIndex = parentRAtoms.get(parentIndex);
            IntVector walkTillP = walkTillParent.get(parentIndex);
            MolAtom rAtom = this.union.getAtom(rAtomIndex);
            MoleculeGraph d = rAtom.getParent();
            if (!(d instanceof Molecule)) continue;
            if (d.getAtomCount() == 1) {
                this.addSingleDefinitionsParentsAndWalks(parentRAtoms, walkTillParent, parentIndex);
                continue;
            }
            Molecule rAtomDef = (Molecule)d;
            for (int i = 0; i < attachAtoms.length; ++i) {
                for (int j = 0; j < i; ++j) {
                    MolAtom att1 = attachAtoms[i];
                    MolAtom att2 = attachAtoms[j];
                    if (!this.isAtomBetweenAttachments(att1, att2, l1, a, l2, def)) continue;
                    int ratomLigand1Ind = this.getLigandIndexByOrder(rAtomIndex, i + 1);
                    int ratomLigand2Ind = this.getLigandIndexByOrder(rAtomIndex, j + 1);
                    MolAtom ratomLigand2 = MolImportUtil.getLigandByOrder(rAtom, j + 1);
                    if (ratomLigand1Ind == -1 || ratomLigand2Ind == -1) continue;
                    this.getParentsParentWalksAndAddIt(new int[]{l1, a, l2}, new int[]{ratomLigand1Ind, rAtomIndex, ratomLigand2Ind}, walkTillP);
                }
            }
        }
        if (this.ringMembershipRecords[a].getRingParentWalks(l1, a, l2).size() == 0) {
            this.ringMembershipRecords[a].setRingMembership(l1, a, l2, RingMembership.NOT_RING);
        }
        this.ringMembershipRecords[a].mergeParentWalks(l1, a, l2);
        return this.ringMembershipRecords[a].getRingMembership(l1, a, l2);
    }

    private void getParentsParentWalksAndAddIt(int[] atomAndNeigh, int[] parentAndNeigh, IntVector walkTillP) {
        int l1 = atomAndNeigh[0];
        int l2 = atomAndNeigh[2];
        int a = atomAndNeigh[1];
        int ratomLigand1Ind = parentAndNeigh[0];
        int ratomLigand2Ind = parentAndNeigh[2];
        int rAtomIndex = parentAndNeigh[1];
        this.getRingmembership(ratomLigand1Ind, rAtomIndex, ratomLigand2Ind);
        List<IntVector> ringparentWalks = this.ringMembershipRecords[rAtomIndex].getRingParentWalks(ratomLigand1Ind, rAtomIndex, ratomLigand2Ind);
        List<IntVector> nonringparentWalks = this.ringMembershipRecords[rAtomIndex].getNonRingParentWalks(ratomLigand1Ind, rAtomIndex, ratomLigand2Ind);
        this.ringMembershipRecords[a].addParentWalks(l1, a, l2, ringparentWalks, walkTillP, true);
        this.ringMembershipRecords[a].addParentWalks(l1, a, l2, nonringparentWalks, walkTillP, false);
    }

    private int getLigandIndexByOrder(int atomIndex, int order) {
        if (this.ctab == null) {
            this.ctab = this.union.getCtab();
        }
        int[] atomNeighBours = this.ctab[atomIndex];
        MolAtom atom = this.union.getAtom(atomIndex);
        for (int neighIndex : atomNeighBours) {
            if (atom.getLigandOrder(this.union.getAtom(neighIndex)) != order) continue;
            return neighIndex;
        }
        return -1;
    }

    private void addSingleDefinitionsParentsAndWalks(IntVector parentRAtoms, ArrayList<IntVector> walkTillParent, int parentIndex) {
        int rAtomIndex = parentRAtoms.get(parentIndex);
        int[] grandParents = this.getParentRAtoms(rAtomIndex);
        parentRAtoms.addAll(new IntVector(grandParents));
        IntVector walk = new IntVector();
        walk.addAll(walkTillParent.get(parentIndex));
        walk.add(rAtomIndex);
        for (int grandParent : grandParents) {
            walkTillParent.add(walk);
        }
    }

    private ArrayList<IntVector> initWalkTillParents(IntVector parentRAtoms) {
        ArrayList<IntVector> walkTillParent = new ArrayList<IntVector>();
        for (int i = 0; i < parentRAtoms.size(); ++i) {
            walkTillParent.add(new IntVector());
        }
        return walkTillParent;
    }

    public int[] getParentRAtoms(int atomInd) {
        if (atomInd < 0) {
            return new int[0];
        }
        return this.srgm.getParentIndexes(atomInd).toArray();
    }

    private boolean isAtomBetweenAttachments(MolAtom att1, MolAtom att2, int l1, int a, int l2, Molecule def) {
        MolAtom atom = this.union.getAtom(a);
        if (atom == att1 || atom == att2) {
            return true;
        }
        boolean bound = false;
        if (att1 != att2 && !att1.isBoundTo(att2)) {
            MolBond attBond = new MolBond(att1, att2);
            def.add(attBond);
            bound = this.areAllInRingInDef(def, l1, a, l2);
            def.removeBond(attBond);
        }
        return bound;
    }

    private boolean areAllInRingInDef(Molecule def, int l1, int a, int l2) {
        MolAtom atom = this.union.getAtom(a);
        this.bondClassifier.classify(def);
        int atomIndInDef = def.indexOf(atom);
        if (this.bondClassifier.isRingAtom(atomIndInDef)) {
            int[] ligandArray;
            for (int l : ligandArray = new int[]{l1, l2}) {
                int ligandIndInDef;
                if (l < 0 || this.bondClassifier.isRingBond(atomIndInDef, ligandIndInDef = def.indexOf(this.union.getAtom(l)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean areAllInRingInUnion(int l1, int a, int l2) {
        int[][] sssr;
        if (l1 == -1 && l2 == -1) {
            return this.unionClassifier.isRingAtom(a);
        }
        if (l1 == -1) {
            return this.unionClassifier.isRingBond(a, l2);
        }
        if (l2 == -1) {
            return this.unionClassifier.isRingBond(a, l1);
        }
        if (this.union.getAtom(a).getBondCount() < 4) {
            return this.unionClassifier.isRingBond(a, l2) && this.unionClassifier.isRingBond(a, l1);
        }
        if (!this.unionClassifier.isRingBond(a, l2) || !this.unionClassifier.isRingBond(a, l1)) {
            return false;
        }
        MolAtom atom = this.union.getAtom(a);
        MoleculeGraph parent = atom.getParent();
        if (parent == null) {
            return false;
        }
        int parentAInd = parent.indexOf(atom);
        int parentL1Ind = parent.indexOf(this.union.getAtom(l1));
        int parentL2Ind = parent.indexOf(this.union.getAtom(l2));
        for (int[] ring : sssr = parent.getSSSR()) {
            if (!ArrayTools.contains(ring, parentL1Ind) || !ArrayTools.contains(ring, parentAInd) || !ArrayTools.contains(ring, parentL2Ind)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RingMembership getRingmembershipOfAtom(int i) {
        return this.getRingmembership(-1, i, -1);
    }

    @Override
    public RingMembership getRingmembershipOfAtom(int i, int[] graphWalkToAtom) {
        RingMembership rm = this.getRingmembershipOfAtom(i);
        if (rm != RingMembership.AMBIGUOUS) {
            return rm;
        }
        graphWalkToAtom = this.removeRepeatedIndexes(graphWalkToAtom);
        return this.ringMembershipRecords[i].getRingMembership(-1, i, -1, graphWalkToAtom);
    }

    @Override
    public RingMembership getRingmembershipOfBond(int i, int j) {
        MolAtom atom2;
        MolAtom atom1 = this.rgMol.getAtom(i);
        MolBond bond = atom1.getBondTo(atom2 = this.rgMol.getAtom(j));
        if (bond == null) {
            return null;
        }
        int smallerIndex = i < j ? i : j;
        int largerIndex = i < j ? j : i;
        return this.getRingmembership(largerIndex, smallerIndex, -1);
    }

    @Override
    public RingMembership getRingmembershipOfBond(int i, int j, int[] graphWalkToAtom) {
        RingMembership rm = this.getRingmembershipOfBond(i, j);
        if (rm != RingMembership.AMBIGUOUS) {
            return rm;
        }
        int smallerIndex = i < j ? i : j;
        int largerIndex = i < j ? j : i;
        if ((graphWalkToAtom = this.removeRepeatedIndexes(graphWalkToAtom)).length > 0 && graphWalkToAtom[graphWalkToAtom.length - 1] == largerIndex) {
            graphWalkToAtom[graphWalkToAtom.length - 1] = smallerIndex;
        }
        return this.ringMembershipRecords[smallerIndex].getRingMembership(largerIndex, smallerIndex, -1, graphWalkToAtom);
    }

    private int[] removeRepeatedIndexes(int[] graphWalkToAtom) {
        if (graphWalkToAtom.length < 2) {
            return graphWalkToAtom;
        }
        IntVector graphWalk = new IntVector(graphWalkToAtom);
        for (int i = graphWalk.size() - 1; i >= 1; --i) {
            if (graphWalk.get(i) != graphWalk.get(i - 1)) continue;
            graphWalk.remove(i);
        }
        return graphWalk.toArray();
    }
}

